/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone.internal;

import java.util.LinkedHashMap;
import java.util.Map;

public class BasicLruCache<K, V> {
    private final CacheMap<K, V> map;

    public BasicLruCache(int maxSize) {
        if (maxSize <= 0) {
            throw new IllegalArgumentException("maxSize <= 0");
        }
        this.map = new CacheMap(maxSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(K key) {
        Object result;
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        BasicLruCache basicLruCache = this;
        synchronized (basicLruCache) {
            result = this.map.get(key);
            if (result != null) {
                return result;
            }
        }
        result = this.create(key);
        basicLruCache = this;
        synchronized (basicLruCache) {
            if (result != null) {
                this.map.put(key, result);
            }
        }
        return result;
    }

    public synchronized V put(K key, V value) {
        if (key == null) {
            throw new NullPointerException("key == null");
        }
        if (value == null) {
            throw new NullPointerException("value == null");
        }
        V previous = this.map.put(key, value);
        return previous;
    }

    protected V create(K key) {
        return null;
    }

    public synchronized void evictAll() {
        this.map.clear();
    }

    private static class CacheMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxSize;

        private CacheMap(int maxSize) {
            super(0, 0.75f, true);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
            return this.size() > this.maxSize;
        }
    }
}

