/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.prediction.AppPredictor;
import android.app.prediction.AppTarget;
import android.app.prediction.AppTargetEvent;
import android.app.prediction.AppTargetId;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.os.Message;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.ChooserActivityLogger;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverRankerServiceResolverComparator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;

class AppPredictionServiceResolverComparator
extends AbstractResolverComparator {
    private static final String TAG = "APSResolverComparator";
    private final AppPredictor mAppPredictor;
    private final Context mContext;
    private final Map<ComponentName, Integer> mTargetRanks = new HashMap<ComponentName, Integer>();
    private final Map<ComponentName, Integer> mTargetScores = new HashMap<ComponentName, Integer>();
    private final UserHandle mUser;
    private final Intent mIntent;
    private final String mReferrerPackage;
    private ResolverRankerServiceResolverComparator mResolverRankerService;

    AppPredictionServiceResolverComparator(Context context, Intent intent, String referrerPackage, AppPredictor appPredictor, UserHandle user, ChooserActivityLogger chooserActivityLogger) {
        super(context, intent);
        this.mContext = context;
        this.mIntent = intent;
        this.mAppPredictor = appPredictor;
        this.mUser = user;
        this.mReferrerPackage = referrerPackage;
        this.setChooserActivityLogger(chooserActivityLogger);
    }

    @Override
    int compare(ResolveInfo lhs, ResolveInfo rhs) {
        if (this.mResolverRankerService != null) {
            return this.mResolverRankerService.compare(lhs, rhs);
        }
        Integer lhsRank = this.mTargetRanks.get(new ComponentName(lhs.activityInfo.packageName, lhs.activityInfo.name));
        Integer rhsRank = this.mTargetRanks.get(new ComponentName(rhs.activityInfo.packageName, rhs.activityInfo.name));
        if (lhsRank == null && rhsRank == null) {
            return 0;
        }
        if (lhsRank == null) {
            return -1;
        }
        if (rhsRank == null) {
            return 1;
        }
        return lhsRank - rhsRank;
    }

    @Override
    void doCompute(List<ResolverActivity.ResolvedComponentInfo> targets) {
        if (targets.isEmpty()) {
            this.mHandler.sendEmptyMessage(0);
            return;
        }
        ArrayList<AppTarget> appTargets = new ArrayList<AppTarget>();
        for (ResolverActivity.ResolvedComponentInfo target : targets) {
            appTargets.add(new AppTarget.Builder(new AppTargetId(target.name.flattenToString()), target.name.getPackageName(), this.mUser).setClassName(target.name.getClassName()).build());
        }
        this.mAppPredictor.sortTargets(appTargets, Executors.newSingleThreadExecutor(), sortedAppTargets -> {
            if (sortedAppTargets.isEmpty()) {
                Log.i(TAG, "AppPredictionService disabled. Using resolver.");
                this.mResolverRankerService = new ResolverRankerServiceResolverComparator(this.mContext, this.mIntent, this.mReferrerPackage, () -> this.mHandler.sendEmptyMessage(0), this.getChooserActivityLogger());
                this.mResolverRankerService.compute(targets);
            } else {
                Log.i(TAG, "AppPredictionService response received");
                this.handleResult((List<AppTarget>)sortedAppTargets);
            }
        });
    }

    @Override
    void handleResultMessage(Message msg) {
        if (msg.what == 0 && msg.obj != null) {
            List sortedAppTargets = (List)msg.obj;
            this.handleSortedAppTargets(sortedAppTargets);
        } else if (msg.obj == null && this.mResolverRankerService == null) {
            Log.e(TAG, "Unexpected null result");
        }
    }

    private void handleResult(List<AppTarget> sortedAppTargets) {
        if (this.mHandler.hasMessages(1)) {
            this.handleSortedAppTargets(sortedAppTargets);
            this.mHandler.removeMessages(1);
            this.afterCompute();
        }
    }

    private void handleSortedAppTargets(List<AppTarget> sortedAppTargets) {
        if (this.checkAppTargetRankValid(sortedAppTargets)) {
            sortedAppTargets.forEach(target -> this.mTargetScores.put(new ComponentName(target.getPackageName(), target.getClassName()), target.getRank()));
        }
        for (int i = 0; i < sortedAppTargets.size(); ++i) {
            ComponentName componentName = new ComponentName(sortedAppTargets.get(i).getPackageName(), sortedAppTargets.get(i).getClassName());
            this.mTargetRanks.put(componentName, i);
            Log.i(TAG, "handleSortedAppTargets, sortedAppTargets #" + i + ": " + componentName);
        }
    }

    private boolean checkAppTargetRankValid(List<AppTarget> sortedAppTargets) {
        for (AppTarget target : sortedAppTargets) {
            if (target.getRank() == 0) continue;
            return true;
        }
        return false;
    }

    @Override
    float getScore(ComponentName name) {
        if (this.mResolverRankerService != null) {
            return this.mResolverRankerService.getScore(name);
        }
        Integer rank = this.mTargetRanks.get(name);
        if (rank == null) {
            Log.w(TAG, "Score requested for unknown component. Did you call compute yet?");
            return 0.0f;
        }
        int consecutiveSumOfRanks = (this.mTargetRanks.size() - 1) * this.mTargetRanks.size() / 2;
        return 1.0f - (float)rank.intValue() / (float)consecutiveSumOfRanks;
    }

    @Override
    List<ComponentName> getTopComponentNames(int topK) {
        if (this.mResolverRankerService != null) {
            return this.mResolverRankerService.getTopComponentNames(topK);
        }
        return this.mTargetRanks.entrySet().stream().sorted(Map.Entry.comparingByValue()).limit(topK).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    void updateModel(ComponentName componentName) {
        if (this.mResolverRankerService != null) {
            this.mResolverRankerService.updateModel(componentName);
            return;
        }
        this.mAppPredictor.notifyAppTargetEvent(new AppTargetEvent.Builder(new AppTarget.Builder(new AppTargetId(componentName.toString()), componentName.getPackageName(), this.mUser).setClassName(componentName.getClassName()).build(), 1).build());
    }

    @Override
    void destroy() {
        if (this.mResolverRankerService != null) {
            this.mResolverRankerService.destroy();
            this.mResolverRankerService = null;
        }
    }
}

