/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.AggregateBatteryConsumer;
import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.util.SparseArray;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;

public class AudioPowerCalculator
extends PowerCalculator {
    private final UsageBasedPowerEstimator mPowerEstimator;

    public AudioPowerCalculator(PowerProfile powerProfile) {
        this.mPowerEstimator = new UsageBasedPowerEstimator(powerProfile.getAveragePower("audio"));
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        PowerAndDuration total = new PowerAndDuration();
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            this.calculateApp(app, total, app.getBatteryStatsUid(), rawRealtimeUs);
        }
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(0).setUsageDurationMillis(4, total.durationMs)).setConsumedPower(4, total.powerMah);
        ((AggregateBatteryConsumer.Builder)builder.getAggregateBatteryConsumerBuilder(1).setUsageDurationMillis(4, total.durationMs)).setConsumedPower(4, total.powerMah);
    }

    private void calculateApp(UidBatteryConsumer.Builder app, PowerAndDuration total, BatteryStats.Uid u, long rawRealtimeUs) {
        long durationMs = this.mPowerEstimator.calculateDuration(u.getAudioTurnedOnTimer(), rawRealtimeUs, 0);
        double powerMah = this.mPowerEstimator.calculatePower(durationMs);
        ((UidBatteryConsumer.Builder)app.setUsageDurationMillis(4, durationMs)).setConsumedPower(4, powerMah);
        total.durationMs += durationMs;
        total.powerMah += powerMah;
    }

    private static class PowerAndDuration {
        public long durationMs;
        public double powerMah;

        private PowerAndDuration() {
        }
    }
}

