/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.BatteryStats;
import android.os.BatteryUsageStats;
import android.os.BatteryUsageStatsQuery;
import android.os.UidBatteryConsumer;
import android.os.UserHandle;
import android.util.ArrayMap;
import android.util.Log;
import android.util.SparseArray;
import com.android.internal.os.BatterySipper;
import com.android.internal.os.PowerCalculator;
import com.android.internal.os.PowerProfile;
import com.android.internal.os.UsageBasedPowerEstimator;
import java.util.List;

public class CpuPowerCalculator
extends PowerCalculator {
    private static final String TAG = "CpuPowerCalculator";
    private static final boolean DEBUG = false;
    private final int mNumCpuClusters;
    private final UsageBasedPowerEstimator mCpuActivePowerEstimator;
    private final UsageBasedPowerEstimator[] mPerClusterPowerEstimators;
    private final UsageBasedPowerEstimator[][] mPerCpuFreqPowerEstimators;

    public CpuPowerCalculator(PowerProfile profile) {
        int cluster;
        this.mNumCpuClusters = profile.getNumCpuClusters();
        this.mCpuActivePowerEstimator = new UsageBasedPowerEstimator(profile.getAveragePower("cpu.active"));
        this.mPerClusterPowerEstimators = new UsageBasedPowerEstimator[this.mNumCpuClusters];
        for (cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
            this.mPerClusterPowerEstimators[cluster] = new UsageBasedPowerEstimator(profile.getAveragePowerForCpuCluster(cluster));
        }
        this.mPerCpuFreqPowerEstimators = new UsageBasedPowerEstimator[this.mNumCpuClusters][];
        for (cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
            int speedsForCluster = profile.getNumSpeedStepsInCpuCluster(cluster);
            this.mPerCpuFreqPowerEstimators[cluster] = new UsageBasedPowerEstimator[speedsForCluster];
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                this.mPerCpuFreqPowerEstimators[cluster][speed] = new UsageBasedPowerEstimator(profile.getAveragePowerForCpuCore(cluster, speed));
            }
        }
    }

    @Override
    public void calculate(BatteryUsageStats.Builder builder, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, BatteryUsageStatsQuery query) {
        double totalPowerMah = 0.0;
        Result result = new Result();
        SparseArray<UidBatteryConsumer.Builder> uidBatteryConsumerBuilders = builder.getUidBatteryConsumerBuilders();
        for (int i = uidBatteryConsumerBuilders.size() - 1; i >= 0; --i) {
            UidBatteryConsumer.Builder app = uidBatteryConsumerBuilders.valueAt(i);
            this.calculateApp(app, app.getBatteryStatsUid(), query, result);
            totalPowerMah += result.powerMah;
        }
        long consumptionUC = batteryStats.getCpuMeasuredBatteryConsumptionUC();
        int powerModel = CpuPowerCalculator.getPowerModel(consumptionUC, query);
        builder.getAggregateBatteryConsumerBuilder(1).setConsumedPower(1, totalPowerMah);
        builder.getAggregateBatteryConsumerBuilder(0).setConsumedPower(1, powerModel == 2 ? CpuPowerCalculator.uCtoMah(consumptionUC) : totalPowerMah, powerModel);
    }

    private void calculateApp(UidBatteryConsumer.Builder app, BatteryStats.Uid u, BatteryUsageStatsQuery query, Result result) {
        long consumptionUC = u.getCpuMeasuredBatteryConsumptionUC();
        int powerModel = CpuPowerCalculator.getPowerModel(consumptionUC, query);
        this.calculatePowerAndDuration(u, powerModel, consumptionUC, 0, result);
        ((UidBatteryConsumer.Builder)((UidBatteryConsumer.Builder)app.setConsumedPower(1, result.powerMah, powerModel)).setUsageDurationMillis(1, result.durationMs)).setPackageWithHighestDrain(result.packageWithHighestDrain);
    }

    @Override
    public void calculate(List<BatterySipper> sippers, BatteryStats batteryStats, long rawRealtimeUs, long rawUptimeUs, int statsType, SparseArray<UserHandle> asUsers) {
        Result result = new Result();
        for (int i = sippers.size() - 1; i >= 0; --i) {
            BatterySipper app = sippers.get(i);
            if (app.drainType != BatterySipper.DrainType.APP) continue;
            this.calculateApp(app, app.uidObj, statsType, result);
        }
    }

    private void calculateApp(BatterySipper app, BatteryStats.Uid u, int statsType, Result result) {
        long consumptionUC = u.getCpuMeasuredBatteryConsumptionUC();
        int powerModel = CpuPowerCalculator.getPowerModel(consumptionUC);
        this.calculatePowerAndDuration(u, powerModel, consumptionUC, statsType, result);
        app.cpuPowerMah = result.powerMah;
        app.cpuTimeMs = result.durationMs;
        app.cpuFgTimeMs = result.durationFgMs;
        app.packageWithHighestDrain = result.packageWithHighestDrain;
    }

    private void calculatePowerAndDuration(BatteryStats.Uid u, int powerModel, long consumptionUC, int statsType, Result result) {
        double powerMah;
        long durationMs = (u.getUserCpuTimeUs(statsType) + u.getSystemCpuTimeUs(statsType)) / 1000L;
        switch (powerModel) {
            case 2: {
                powerMah = CpuPowerCalculator.uCtoMah(consumptionUC);
                break;
            }
            default: {
                powerMah = this.calculateUidModeledPowerMah(u, statsType);
            }
        }
        double highestDrain = 0.0;
        String packageWithHighestDrain = null;
        long durationFgMs = 0L;
        ArrayMap<String, ? extends BatteryStats.Uid.Proc> processStats = u.getProcessStats();
        int processStatsCount = processStats.size();
        for (int i = 0; i < processStatsCount; ++i) {
            BatteryStats.Uid.Proc ps = processStats.valueAt(i);
            String processName = processStats.keyAt(i);
            durationFgMs += ps.getForegroundTime(statsType);
            long costValue = ps.getUserTime(statsType) + ps.getSystemTime(statsType) + ps.getForegroundTime(statsType);
            if (packageWithHighestDrain == null || packageWithHighestDrain.startsWith("*")) {
                highestDrain = costValue;
                packageWithHighestDrain = processName;
                continue;
            }
            if (!(highestDrain < (double)costValue) || processName.startsWith("*")) continue;
            highestDrain = costValue;
            packageWithHighestDrain = processName;
        }
        if (durationFgMs > durationMs) {
            durationMs = durationFgMs;
        }
        result.durationMs = durationMs;
        result.durationFgMs = durationFgMs;
        result.powerMah = powerMah;
        result.packageWithHighestDrain = packageWithHighestDrain;
    }

    public double calculateUidModeledPowerMah(BatteryStats.Uid u, int statsType) {
        int cluster;
        double powerMah = this.calculateActiveCpuPowerMah(u.getCpuActiveTime());
        long[] cpuClusterTimes = u.getCpuClusterTimes();
        if (cpuClusterTimes != null) {
            if (cpuClusterTimes.length == this.mNumCpuClusters) {
                for (cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
                    double power = this.calculatePerCpuClusterPowerMah(cluster, cpuClusterTimes[cluster]);
                    powerMah += power;
                }
            } else {
                Log.w(TAG, "UID " + u.getUid() + " CPU cluster # mismatch: Power Profile # " + this.mNumCpuClusters + " actual # " + cpuClusterTimes.length);
            }
        }
        for (cluster = 0; cluster < this.mNumCpuClusters; ++cluster) {
            int speedsForCluster = this.mPerCpuFreqPowerEstimators[cluster].length;
            for (int speed = 0; speed < speedsForCluster; ++speed) {
                long timeUs = u.getTimeAtCpuSpeed(cluster, speed, statsType);
                double power = this.calculatePerCpuFreqPowerMah(cluster, speed, timeUs / 1000L);
                powerMah += power;
            }
        }
        return powerMah;
    }

    public double calculateActiveCpuPowerMah(long durationsMs) {
        return this.mCpuActivePowerEstimator.calculatePower(durationsMs);
    }

    public double calculatePerCpuClusterPowerMah(int cluster, long clusterDurationMs) {
        return this.mPerClusterPowerEstimators[cluster].calculatePower(clusterDurationMs);
    }

    public double calculatePerCpuFreqPowerMah(int cluster, int speedStep, long clusterSpeedDurationsMs) {
        return this.mPerCpuFreqPowerEstimators[cluster][speedStep].calculatePower(clusterSpeedDurationsMs);
    }

    private static class Result {
        public long durationMs;
        public double powerMah;
        public long durationFgMs;
        public String packageWithHighestDrain;

        private Result() {
        }
    }
}

