/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.RippleDrawable;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RemoteViews;
import android.widget.TextView;
import com.android.internal.widget.EmphasizedNotificationButton;
import java.util.ArrayList;
import java.util.Comparator;

@RemoteViews.RemoteView
public class NotificationActionListLayout
extends LinearLayout {
    private final int mGravity;
    private int mTotalWidth = 0;
    private int mExtraStartPadding = 0;
    private ArrayList<TextViewInfo> mMeasureOrderTextViews = new ArrayList();
    private ArrayList<View> mMeasureOrderOther = new ArrayList();
    private boolean mEmphasizedMode;
    private int mDefaultPaddingBottom;
    private int mDefaultPaddingTop;
    private int mEmphasizedHeight;
    private int mRegularHeight;
    private int mCollapsibleIndentDimen = 17105368;
    public static final Comparator<TextViewInfo> MEASURE_ORDER_COMPARATOR = (a, b) -> {
        int priorityComparison = -Boolean.compare(a.mIsPriority, b.mIsPriority);
        return priorityComparison != 0 ? priorityComparison : Integer.compare(a.mTextLength, b.mTextLength);
    };

    public NotificationActionListLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NotificationActionListLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public NotificationActionListLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        int[] attrIds = new int[]{16842927};
        TypedArray ta = context.obtainStyledAttributes(attrs, attrIds, defStyleAttr, defStyleRes);
        this.mGravity = ta.getInt(0, 0);
        ta.recycle();
    }

    private static boolean isPriority(View actionView) {
        return actionView instanceof EmphasizedNotificationButton && ((EmphasizedNotificationButton)actionView).isPriority();
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int N = this.getChildCount();
        int textViews = 0;
        int otherViews = 0;
        int notGoneChildren = 0;
        int priorityChildren = 0;
        for (int i = 0; i < N; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView) {
                ++textViews;
            } else {
                ++otherViews;
            }
            if (c.getVisibility() == 8) continue;
            ++notGoneChildren;
            if (!NotificationActionListLayout.isPriority(c)) continue;
            ++priorityChildren;
        }
        boolean needRebuild = false;
        if (textViews != this.mMeasureOrderTextViews.size() || otherViews != this.mMeasureOrderOther.size()) {
            needRebuild = true;
        }
        if (!needRebuild) {
            int size = this.mMeasureOrderTextViews.size();
            for (int i = 0; i < size; ++i) {
                if (!this.mMeasureOrderTextViews.get(i).needsRebuild()) continue;
                needRebuild = true;
                break;
            }
        }
        if (needRebuild) {
            this.rebuildMeasureOrder(textViews, otherViews);
        }
        boolean constrained = View.MeasureSpec.getMode(widthMeasureSpec) != 0;
        int innerWidth = View.MeasureSpec.getSize(widthMeasureSpec) - this.mPaddingLeft - this.mPaddingRight;
        int otherSize = this.mMeasureOrderOther.size();
        int usedWidth = 0;
        int measuredChildren = 0;
        int measuredPriorityChildren = 0;
        for (int i = 0; i < N; ++i) {
            boolean isPriority;
            View c;
            if (i < otherSize) {
                c = this.mMeasureOrderOther.get(i);
                isPriority = false;
            } else {
                TextViewInfo info = this.mMeasureOrderTextViews.get(i - otherSize);
                c = info.mTextView;
                isPriority = info.mIsPriority;
            }
            if (c.getVisibility() == 8) continue;
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)c.getLayoutParams();
            int usedWidthForChild = usedWidth;
            if (constrained) {
                int availableWidth = innerWidth - usedWidth;
                int unmeasuredChildren = notGoneChildren - measuredChildren;
                int maxWidthForChild = availableWidth / unmeasuredChildren;
                if (isPriority) {
                    int unmeasuredPriorityChildren = priorityChildren - measuredPriorityChildren;
                    int unmeasuredOtherChildren = unmeasuredChildren - unmeasuredPriorityChildren;
                    int widthReservedForOtherChildren = innerWidth * unmeasuredOtherChildren / 4;
                    int widthAvailableForPriority = availableWidth - widthReservedForOtherChildren;
                    maxWidthForChild = widthAvailableForPriority / unmeasuredPriorityChildren;
                }
                usedWidthForChild = innerWidth - maxWidthForChild;
            }
            this.measureChildWithMargins(c, widthMeasureSpec, usedWidthForChild, heightMeasureSpec, 0);
            usedWidth += c.getMeasuredWidth() + lp.rightMargin + lp.leftMargin;
            ++measuredChildren;
            if (!isPriority) continue;
            ++measuredPriorityChildren;
        }
        int collapsibleIndent = this.mCollapsibleIndentDimen == 0 ? 0 : this.getResources().getDimensionPixelOffset(this.mCollapsibleIndentDimen);
        this.mExtraStartPadding = innerWidth - usedWidth > collapsibleIndent ? collapsibleIndent : 0;
        this.mTotalWidth = usedWidth + this.mPaddingRight + this.mPaddingLeft + this.mExtraStartPadding;
        this.setMeasuredDimension(NotificationActionListLayout.resolveSize(this.getSuggestedMinimumWidth(), widthMeasureSpec), NotificationActionListLayout.resolveSize(this.getSuggestedMinimumHeight(), heightMeasureSpec));
    }

    private void rebuildMeasureOrder(int capacityText, int capacityOther) {
        this.clearMeasureOrder();
        this.mMeasureOrderTextViews.ensureCapacity(capacityText);
        this.mMeasureOrderOther.ensureCapacity(capacityOther);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View c = this.getChildAt(i);
            if (c instanceof TextView && ((TextView)c).getText().length() > 0) {
                this.mMeasureOrderTextViews.add(new TextViewInfo((TextView)c));
                continue;
            }
            this.mMeasureOrderOther.add(c);
        }
        this.mMeasureOrderTextViews.sort(MEASURE_ORDER_COMPARATOR);
    }

    private void clearMeasureOrder() {
        this.mMeasureOrderOther.clear();
        this.mMeasureOrderTextViews.clear();
    }

    @Override
    public void onViewAdded(View child) {
        super.onViewAdded(child);
        this.clearMeasureOrder();
        if (child.getBackground() instanceof RippleDrawable) {
            ((RippleDrawable)child.getBackground()).setForceSoftware(true);
        }
    }

    @Override
    public void onViewRemoved(View child) {
        super.onViewRemoved(child);
        this.clearMeasureOrder();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int childLeft;
        boolean centerAligned;
        boolean isLayoutRtl = this.isLayoutRtl();
        int paddingTop = this.mPaddingTop;
        boolean bl = centerAligned = (this.mGravity & 1) != 0;
        if (centerAligned) {
            childLeft = this.mPaddingLeft + left + (right - left) / 2 - this.mTotalWidth / 2;
        } else {
            childLeft = this.mPaddingLeft;
            int absoluteGravity = Gravity.getAbsoluteGravity(0x800003, this.getLayoutDirection());
            childLeft = absoluteGravity == 5 ? (childLeft += right - left - this.mTotalWidth) : (childLeft += this.mExtraStartPadding);
        }
        int height = bottom - top;
        int innerHeight = height - paddingTop - this.mPaddingBottom;
        int count = this.getChildCount();
        int start = 0;
        int dir = 1;
        if (isLayoutRtl) {
            start = count - 1;
            dir = -1;
        }
        for (int i = 0; i < count; ++i) {
            int childIndex = start + dir * i;
            View child = this.getChildAt(childIndex);
            if (child.getVisibility() == 8) continue;
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            ViewGroup.MarginLayoutParams lp = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
            int childTop = paddingTop + (innerHeight - childHeight) / 2 + lp.topMargin - lp.bottomMargin;
            child.layout(childLeft += lp.leftMargin, childTop, childLeft + childWidth, childTop + childHeight);
            childLeft += childWidth + lp.rightMargin;
        }
    }

    @Override
    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mDefaultPaddingBottom = this.getPaddingBottom();
        this.mDefaultPaddingTop = this.getPaddingTop();
        this.updateHeights();
    }

    private void updateHeights() {
        int paddingTop = this.getResources().getDimensionPixelSize(17105376);
        int paddingBottom = this.getResources().getDimensionPixelSize(17105377);
        this.mEmphasizedHeight = paddingBottom + paddingTop + this.getResources().getDimensionPixelSize(17105363);
        this.mRegularHeight = this.getResources().getDimensionPixelSize(17105364);
    }

    @RemotableViewMethod
    public void setCollapsibleIndentDimen(int collapsibleIndentDimen) {
        if (this.mCollapsibleIndentDimen != collapsibleIndentDimen) {
            this.mCollapsibleIndentDimen = collapsibleIndentDimen;
            this.requestLayout();
        }
    }

    @RemotableViewMethod
    public void setEmphasizedMode(boolean emphasizedMode) {
        int height;
        this.mEmphasizedMode = emphasizedMode;
        if (emphasizedMode) {
            int paddingTop = this.getResources().getDimensionPixelSize(17105376);
            int paddingBottom = this.getResources().getDimensionPixelSize(17105377);
            height = this.mEmphasizedHeight;
            int buttonPaddingInternal = this.getResources().getDimensionPixelSize(17104967);
            this.setPaddingRelative(this.getPaddingStart(), paddingTop - buttonPaddingInternal, this.getPaddingEnd(), paddingBottom - buttonPaddingInternal);
        } else {
            this.setPaddingRelative(this.getPaddingStart(), this.mDefaultPaddingTop, this.getPaddingEnd(), this.mDefaultPaddingBottom);
            height = this.mRegularHeight;
        }
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        layoutParams.height = height;
        this.setLayoutParams(layoutParams);
    }

    public int getExtraMeasureHeight() {
        if (this.mEmphasizedMode) {
            return this.mEmphasizedHeight - this.mRegularHeight;
        }
        return 0;
    }

    private static class TextViewInfo {
        final boolean mIsPriority;
        final int mTextLength;
        final TextView mTextView;

        TextViewInfo(TextView textView) {
            this.mIsPriority = NotificationActionListLayout.isPriority(textView);
            this.mTextLength = textView.getText().length();
            this.mTextView = textView;
        }

        boolean needsRebuild() {
            return this.mTextView.getText().length() != this.mTextLength || NotificationActionListLayout.isPriority(this.mTextView) != this.mIsPriority;
        }
    }
}

