/*
 * Decompiled with CFR 0.152.
 */
package com.android.net.module.util;

import android.net.NetworkCapabilities;
import com.android.internal.annotations.VisibleForTesting;
import com.android.net.module.util.CollectionUtils;

public class NetworkCapabilitiesUtils {
    public static final int TRANSPORT_USB = 8;
    private static final int[] DISPLAY_TRANSPORT_PRIORITIES = new int[]{4, 0, 5, 2, 1, 3, 8};
    public static final int NET_CAPABILITY_OEM_PRIVATE = 26;
    public static final int NET_CAPABILITY_VEHICLE_INTERNAL = 27;
    public static final int NET_CAPABILITY_NOT_VCN_MANAGED = 28;
    public static final int NET_CAPABILITY_ENTERPRISE = 29;
    public static final int NET_CAPABILITY_VSIM = 30;
    public static final int NET_CAPABILITY_BIP = 31;
    @VisibleForTesting
    static final long RESTRICTED_CAPABILITIES = -394262596L;
    private static final long FORCE_RESTRICTED_CAPABILITIES = 0x24400000L;
    @VisibleForTesting
    static final long UNRESTRICTED_CAPABILITIES = 4163L;

    public static int getDisplayTransport(int[] transports) {
        for (int transport : DISPLAY_TRANSPORT_PRIORITIES) {
            if (!CollectionUtils.contains(transports, transport)) continue;
            return transport;
        }
        if (transports.length < 1) {
            throw new IllegalArgumentException("No transport in the provided array");
        }
        return transports[0];
    }

    public static boolean inferRestrictedCapability(NetworkCapabilities nc) {
        for (int capability : NetworkCapabilitiesUtils.unpackBits(0x24400000L)) {
            if (!nc.hasCapability(capability)) continue;
            return true;
        }
        for (int capability : NetworkCapabilitiesUtils.unpackBits(4163L)) {
            if (!nc.hasCapability(capability)) continue;
            return false;
        }
        for (int capability : NetworkCapabilitiesUtils.unpackBits(-394262596L)) {
            if (!nc.hasCapability(capability)) continue;
            return true;
        }
        return false;
    }

    public static int[] unpackBits(long val) {
        int size = Long.bitCount(val);
        int[] result = new int[size];
        int index = 0;
        int bitPos = 0;
        while (val != 0L) {
            if ((val & 1L) == 1L) {
                result[index++] = bitPos;
            }
            val >>>= 1;
            ++bitPos;
        }
        return result;
    }

    public static long packBits(int[] bits) {
        long packed = 0L;
        for (int b : bits) {
            packed |= 1L << b;
        }
        return packed;
    }
}

