/*
 * Decompiled with CFR 0.152.
 */
package com.android.telephony;

import android.text.TextUtils;
import android.util.Base64;
import android.util.Log;
import com.android.internal.telephony.util.TelephonyUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Rlog {
    private static final boolean USER_BUILD = TelephonyUtils.IS_USER;

    private Rlog() {
    }

    private static int log(int priority, String tag, String msg) {
        return Log.logToRadioBuffer(priority, tag, msg);
    }

    public static int v(String tag, String msg) {
        return Rlog.log(2, tag, msg);
    }

    public static int v(String tag, String msg, Throwable tr) {
        return Rlog.log(2, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int d(String tag, String msg) {
        return Rlog.log(3, tag, msg);
    }

    public static int d(String tag, String msg, Throwable tr) {
        return Rlog.log(3, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int i(String tag, String msg) {
        return Rlog.log(4, tag, msg);
    }

    public static int i(String tag, String msg, Throwable tr) {
        return Rlog.log(4, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, String msg) {
        return Rlog.log(5, tag, msg);
    }

    public static int w(String tag, String msg, Throwable tr) {
        return Rlog.log(5, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int w(String tag, Throwable tr) {
        return Rlog.log(5, tag, Log.getStackTraceString(tr));
    }

    public static int e(String tag, String msg) {
        return Rlog.log(6, tag, msg);
    }

    public static int e(String tag, String msg, Throwable tr) {
        return Rlog.log(6, tag, msg + '\n' + Log.getStackTraceString(tr));
    }

    public static int println(int priority, String tag, String msg) {
        return Rlog.log(priority, tag, msg);
    }

    public static boolean isLoggable(String tag, int level) {
        return Log.isLoggable(tag, level);
    }

    public static String pii(String tag, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || Rlog.isLoggable(tag, 2)) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    public static String pii(boolean enablePiiLogging, Object pii) {
        String val = String.valueOf(pii);
        if (pii == null || TextUtils.isEmpty(val) || enablePiiLogging) {
            return val;
        }
        return "[" + Rlog.secureHash(val.getBytes()) + "]";
    }

    private static String secureHash(byte[] input) {
        MessageDigest messageDigest;
        if (USER_BUILD) {
            return "****";
        }
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            return "####";
        }
        byte[] result = messageDigest.digest(input);
        return Base64.encodeToString(result, 11);
    }
}

