/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.suggestions;

import com.google.android.apps.common.testing.accessibility.framework.suggestions.FixSuggestion;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.base.StandardSystemProperty;
import com.google.common.collect.ImmutableList;
import java.util.Locale;

@Beta
public class CompoundFixSuggestions
implements FixSuggestion {
    private final ImmutableList<FixSuggestion> fixSuggestions;

    public CompoundFixSuggestions(ImmutableList<FixSuggestion> fixSuggestions) {
        Preconditions.checkArgument((fixSuggestions.size() > 1 ? 1 : 0) != 0, (Object)"The fix suggestion list must contain at least 2 fix suggestions");
        this.fixSuggestions = fixSuggestions;
    }

    public ImmutableList<FixSuggestion> getFixSuggestions() {
        return this.fixSuggestions;
    }

    @Override
    public CharSequence getRawDescription(Locale locale) {
        String description = "";
        for (int i = 0; i < this.fixSuggestions.size(); ++i) {
            String string2 = String.valueOf(description);
            String string3 = String.valueOf(((FixSuggestion)this.fixSuggestions.get(i)).getRawDescription(locale));
            description = new StringBuilder(String.valueOf(string2).length() + String.valueOf(string3).length()).append(string2).append(string3).toString();
            if (i >= this.fixSuggestions.size() - 1) continue;
            String string4 = String.valueOf(description);
            String string5 = String.valueOf(StandardSystemProperty.LINE_SEPARATOR.value());
            description = string5.length() != 0 ? string4.concat(string5) : new String(string4);
        }
        return description;
    }
}

