/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.uielement;

import android.os.StrictMode;
import android.view.View;
import android.widget.Checkable;
import com.google.android.apps.common.testing.accessibility.framework.uielement.CustomViewBuilderAndroid;
import com.google.android.apps.common.testing.accessibility.framework.uielement.ViewHierarchyElementAndroid;
import com.google.android.libraries.accessibility.utils.log.LogUtils;
import com.google.android.material.button.MaterialButton;
import org.checkerframework.checker.nullness.qual.Nullable;

public class DefaultCustomViewBuilderAndroid
implements CustomViewBuilderAndroid {
    private static final String TAG = "DefaultClassByNameResolverAndroid";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public @Nullable Class<?> getClassByName(ViewHierarchyElementAndroid view, String className) {
        StrictMode.ThreadPolicy oldPolicy = StrictMode.allowThreadDiskReads();
        try {
            ClassLoader classLoader = view.getClass().getClassLoader();
            if (classLoader != null) {
                Class<?> clazz = classLoader.loadClass(className);
                return clazz;
            }
            LogUtils.w(TAG, "Unsuccessful attempt to get ClassLoader to load %1$s", className);
        }
        catch (ClassNotFoundException e) {
            LogUtils.w(TAG, "Unsuccessful attempt to load class %1$s.", className);
        }
        finally {
            StrictMode.setThreadPolicy(oldPolicy);
        }
        return null;
    }

    @Override
    public boolean isCheckable(View fromView) {
        if (fromView instanceof MaterialButton) {
            return ((MaterialButton)fromView).isCheckable();
        }
        return fromView instanceof Checkable;
    }
}

