/*
 * Decompiled with CFR 0.152.
 */
package libcore.io;

import dalvik.system.BlockGuard;

public class IoTracker {
    private int opCount;
    private int totalByteCount;
    private boolean isOpen = true;
    private Mode mode = Mode.READ;

    public void trackIo(int byteCount) {
        ++this.opCount;
        this.totalByteCount += byteCount;
        if (this.isOpen && this.opCount > 10 && this.totalByteCount < 5120) {
            BlockGuard.getThreadPolicy().onUnbufferedIO();
            this.isOpen = false;
        }
    }

    public void trackIo(int byteCount, Mode mode) {
        if (this.mode != mode) {
            this.reset();
            this.mode = mode;
        }
        this.trackIo(byteCount);
    }

    public void reset() {
        this.opCount = 0;
        this.totalByteCount = 0;
    }

    public static enum Mode {
        READ,
        WRITE;

    }
}

