/*
 * Decompiled with CFR 0.152.
 */
package android.app.servertransaction;

import android.app.ActivityOptions;
import android.app.ActivityThread;
import android.app.ClientTransactionHandler;
import android.app.servertransaction.ActivityLifecycleItem;
import android.app.servertransaction.ObjectPool;
import android.app.servertransaction.PendingTransactionActions;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.Trace;

public class StartActivityItem
extends ActivityLifecycleItem {
    private static final String TAG = "StartActivityItem";
    private ActivityOptions mActivityOptions;
    public static final Parcelable.Creator<StartActivityItem> CREATOR = new Parcelable.Creator<StartActivityItem>(){

        @Override
        public StartActivityItem createFromParcel(Parcel in) {
            return new StartActivityItem(in);
        }

        public StartActivityItem[] newArray(int size) {
            return new StartActivityItem[size];
        }
    };

    @Override
    public void execute(ClientTransactionHandler client, ActivityThread.ActivityClientRecord r, PendingTransactionActions pendingActions) {
        Trace.traceBegin(64L, "startActivityItem");
        client.handleStartActivity(r, pendingActions, this.mActivityOptions);
        Trace.traceEnd(64L);
    }

    @Override
    public int getTargetState() {
        return 2;
    }

    private StartActivityItem() {
    }

    public static StartActivityItem obtain(ActivityOptions activityOptions) {
        StartActivityItem instance = ObjectPool.obtain(StartActivityItem.class);
        if (instance == null) {
            instance = new StartActivityItem();
        }
        instance.mActivityOptions = activityOptions;
        return instance;
    }

    @Override
    public void recycle() {
        super.recycle();
        this.mActivityOptions = null;
        ObjectPool.recycle(this);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeBundle(this.mActivityOptions != null ? this.mActivityOptions.toBundle() : null);
    }

    private StartActivityItem(Parcel in) {
        this.mActivityOptions = ActivityOptions.fromBundle(in.readBundle());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartActivityItem other = (StartActivityItem)o;
        return this.mActivityOptions == null == (other.mActivityOptions == null);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.mActivityOptions != null ? 1 : 0);
        return result;
    }

    public String toString() {
        return "StartActivityItem{options=" + this.mActivityOptions + "}";
    }
}

