/*
 * Decompiled with CFR 0.152.
 */
package android.app.timedetector;

import android.os.Parcel;
import android.os.Parcelable;
import android.os.TimestampedValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class GnssTimeSuggestion
implements Parcelable {
    public static final Parcelable.Creator<GnssTimeSuggestion> CREATOR = new Parcelable.Creator<GnssTimeSuggestion>(){

        @Override
        public GnssTimeSuggestion createFromParcel(Parcel in) {
            return GnssTimeSuggestion.createFromParcel(in);
        }

        public GnssTimeSuggestion[] newArray(int size) {
            return new GnssTimeSuggestion[size];
        }
    };
    private final TimestampedValue<Long> mUtcTime;
    private ArrayList<String> mDebugInfo;

    public GnssTimeSuggestion(TimestampedValue<Long> utcTime) {
        this.mUtcTime = Objects.requireNonNull(utcTime);
        Objects.requireNonNull(utcTime.getValue());
    }

    private static GnssTimeSuggestion createFromParcel(Parcel in) {
        ArrayList debugInfo;
        TimestampedValue utcTime = (TimestampedValue)in.readParcelable(null);
        GnssTimeSuggestion suggestion = new GnssTimeSuggestion(utcTime);
        suggestion.mDebugInfo = debugInfo = in.readArrayList(null);
        return suggestion;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mUtcTime, 0);
        dest.writeList(this.mDebugInfo);
    }

    public TimestampedValue<Long> getUtcTime() {
        return this.mUtcTime;
    }

    public List<String> getDebugInfo() {
        return this.mDebugInfo == null ? Collections.emptyList() : Collections.unmodifiableList(this.mDebugInfo);
    }

    public void addDebugInfo(String ... debugInfos) {
        if (this.mDebugInfo == null) {
            this.mDebugInfo = new ArrayList();
        }
        this.mDebugInfo.addAll(Arrays.asList(debugInfos));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GnssTimeSuggestion that = (GnssTimeSuggestion)o;
        return Objects.equals(this.mUtcTime, that.mUtcTime);
    }

    public int hashCode() {
        return Objects.hash(this.mUtcTime);
    }

    public String toString() {
        return "GnssTimeSuggestion{mUtcTime=" + this.mUtcTime + ", mDebugInfo=" + this.mDebugInfo + '}';
    }
}

