/*
 * Decompiled with CFR 0.152.
 */
package android.app.usage;

import android.annotation.SystemApi;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.ArrayMap;
import android.util.SparseArray;
import android.util.SparseIntArray;

public class UsageStats
implements Parcelable {
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public String mPackageName;
    public int mPackageToken = -1;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public long mBeginTimeStamp;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public long mEndTimeStamp;
    @UnsupportedAppUsage(maxTargetSdk=28, trackingBug=115609023L)
    public long mLastTimeUsed;
    public long mLastTimeVisible;
    @UnsupportedAppUsage
    public long mTotalTimeInForeground;
    public long mTotalTimeVisible;
    public long mLastTimeForegroundServiceUsed;
    public long mTotalTimeForegroundServiceUsed;
    public long mLastTimeComponentUsed;
    @UnsupportedAppUsage
    public int mLaunchCount;
    public int mAppLaunchCount;
    @Deprecated
    @UnsupportedAppUsage
    public int mLastEvent;
    public SparseIntArray mActivities = new SparseIntArray();
    public ArrayMap<String, Integer> mForegroundServices = new ArrayMap();
    public ArrayMap<String, ArrayMap<String, Integer>> mChooserCounts = new ArrayMap();
    public SparseArray<SparseIntArray> mChooserCountsObfuscated = new SparseArray();
    public static final Parcelable.Creator<UsageStats> CREATOR = new Parcelable.Creator<UsageStats>(){

        @Override
        public UsageStats createFromParcel(Parcel in) {
            UsageStats stats = new UsageStats();
            stats.mPackageName = in.readString();
            stats.mBeginTimeStamp = in.readLong();
            stats.mEndTimeStamp = in.readLong();
            stats.mLastTimeUsed = in.readLong();
            stats.mLastTimeVisible = in.readLong();
            stats.mLastTimeComponentUsed = in.readLong();
            stats.mLastTimeForegroundServiceUsed = in.readLong();
            stats.mTotalTimeInForeground = in.readLong();
            stats.mTotalTimeVisible = in.readLong();
            stats.mTotalTimeForegroundServiceUsed = in.readLong();
            stats.mLaunchCount = in.readInt();
            stats.mAppLaunchCount = in.readInt();
            stats.mLastEvent = in.readInt();
            Bundle allCounts = in.readBundle();
            if (allCounts != null) {
                stats.mChooserCounts = new ArrayMap();
                for (String action : allCounts.keySet()) {
                    Bundle currentCounts;
                    if (!stats.mChooserCounts.containsKey(action)) {
                        ArrayMap newCounts = new ArrayMap();
                        stats.mChooserCounts.put(action, newCounts);
                    }
                    if ((currentCounts = allCounts.getBundle(action)) == null) continue;
                    for (String key : currentCounts.keySet()) {
                        int value = currentCounts.getInt(key);
                        if (value <= 0) continue;
                        stats.mChooserCounts.get(action).put(key, value);
                    }
                }
            }
            this.readSparseIntArray(in, stats.mActivities);
            this.readBundleToEventMap(in.readBundle(), stats.mForegroundServices);
            return stats;
        }

        private void readSparseIntArray(Parcel in, SparseIntArray arr) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                int key = in.readInt();
                int value = in.readInt();
                arr.put(key, value);
            }
        }

        private void readBundleToEventMap(Bundle bundle, ArrayMap<String, Integer> eventMap) {
            if (bundle != null) {
                for (String className : bundle.keySet()) {
                    int event = bundle.getInt(className);
                    eventMap.put(className, event);
                }
            }
        }

        public UsageStats[] newArray(int size) {
            return new UsageStats[size];
        }
    };

    public UsageStats() {
    }

    public UsageStats(UsageStats stats) {
        this.mPackageName = stats.mPackageName;
        this.mBeginTimeStamp = stats.mBeginTimeStamp;
        this.mEndTimeStamp = stats.mEndTimeStamp;
        this.mLastTimeUsed = stats.mLastTimeUsed;
        this.mLastTimeVisible = stats.mLastTimeVisible;
        this.mLastTimeComponentUsed = stats.mLastTimeComponentUsed;
        this.mLastTimeForegroundServiceUsed = stats.mLastTimeForegroundServiceUsed;
        this.mTotalTimeInForeground = stats.mTotalTimeInForeground;
        this.mTotalTimeVisible = stats.mTotalTimeVisible;
        this.mTotalTimeForegroundServiceUsed = stats.mTotalTimeForegroundServiceUsed;
        this.mLaunchCount = stats.mLaunchCount;
        this.mAppLaunchCount = stats.mAppLaunchCount;
        this.mLastEvent = stats.mLastEvent;
        this.mActivities = stats.mActivities;
        this.mForegroundServices = stats.mForegroundServices;
        this.mChooserCounts = stats.mChooserCounts;
    }

    public UsageStats getObfuscatedForInstantApp() {
        UsageStats ret = new UsageStats(this);
        ret.mPackageName = "android.instant_app";
        return ret;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public long getFirstTimeStamp() {
        return this.mBeginTimeStamp;
    }

    public long getLastTimeStamp() {
        return this.mEndTimeStamp;
    }

    public long getLastTimeUsed() {
        return this.mLastTimeUsed;
    }

    public long getLastTimeVisible() {
        return this.mLastTimeVisible;
    }

    public long getTotalTimeInForeground() {
        return this.mTotalTimeInForeground;
    }

    public long getTotalTimeVisible() {
        return this.mTotalTimeVisible;
    }

    public long getLastTimeForegroundServiceUsed() {
        return this.mLastTimeForegroundServiceUsed;
    }

    public long getTotalTimeForegroundServiceUsed() {
        return this.mTotalTimeForegroundServiceUsed;
    }

    @SystemApi
    public long getLastTimeAnyComponentUsed() {
        return this.mLastTimeComponentUsed;
    }

    @SystemApi
    public int getAppLaunchCount() {
        return this.mAppLaunchCount;
    }

    private void mergeEventMap(SparseIntArray left, SparseIntArray right) {
        int size = right.size();
        for (int i = 0; i < size; ++i) {
            int instanceId = right.keyAt(i);
            int event = right.valueAt(i);
            int index = left.indexOfKey(instanceId);
            if (index >= 0) {
                left.put(instanceId, Math.max(left.valueAt(index), event));
                continue;
            }
            left.put(instanceId, event);
        }
    }

    private void mergeEventMap(ArrayMap<String, Integer> left, ArrayMap<String, Integer> right) {
        int size = right.size();
        for (int i = 0; i < size; ++i) {
            String className = right.keyAt(i);
            Integer event = right.valueAt(i);
            if (left.containsKey(className)) {
                left.put(className, Math.max(left.get(className), event));
                continue;
            }
            left.put(className, event);
        }
    }

    public void add(UsageStats right) {
        if (!this.mPackageName.equals(right.mPackageName)) {
            throw new IllegalArgumentException("Can't merge UsageStats for package '" + this.mPackageName + "' with UsageStats for package '" + right.mPackageName + "'.");
        }
        if (right.mBeginTimeStamp > this.mBeginTimeStamp) {
            this.mergeEventMap(this.mActivities, right.mActivities);
            this.mergeEventMap(this.mForegroundServices, right.mForegroundServices);
            this.mLastTimeUsed = Math.max(this.mLastTimeUsed, right.mLastTimeUsed);
            this.mLastTimeVisible = Math.max(this.mLastTimeVisible, right.mLastTimeVisible);
            this.mLastTimeComponentUsed = Math.max(this.mLastTimeComponentUsed, right.mLastTimeComponentUsed);
            this.mLastTimeForegroundServiceUsed = Math.max(this.mLastTimeForegroundServiceUsed, right.mLastTimeForegroundServiceUsed);
        }
        this.mBeginTimeStamp = Math.min(this.mBeginTimeStamp, right.mBeginTimeStamp);
        this.mEndTimeStamp = Math.max(this.mEndTimeStamp, right.mEndTimeStamp);
        this.mTotalTimeInForeground += right.mTotalTimeInForeground;
        this.mTotalTimeVisible += right.mTotalTimeVisible;
        this.mTotalTimeForegroundServiceUsed += right.mTotalTimeForegroundServiceUsed;
        this.mLaunchCount += right.mLaunchCount;
        this.mAppLaunchCount += right.mAppLaunchCount;
        if (this.mChooserCounts == null) {
            this.mChooserCounts = right.mChooserCounts;
        } else if (right.mChooserCounts != null) {
            int chooserCountsSize = right.mChooserCounts.size();
            for (int i = 0; i < chooserCountsSize; ++i) {
                String action = right.mChooserCounts.keyAt(i);
                ArrayMap<String, Integer> counts = right.mChooserCounts.valueAt(i);
                if (!this.mChooserCounts.containsKey(action) || this.mChooserCounts.get(action) == null) {
                    this.mChooserCounts.put(action, counts);
                    continue;
                }
                int annotationSize = counts.size();
                for (int j = 0; j < annotationSize; ++j) {
                    String key = counts.keyAt(j);
                    int rightValue = counts.valueAt(j);
                    int leftValue = this.mChooserCounts.get(action).getOrDefault(key, 0);
                    this.mChooserCounts.get(action).put(key, leftValue + rightValue);
                }
            }
        }
    }

    private boolean hasForegroundActivity() {
        int size = this.mActivities.size();
        for (int i = 0; i < size; ++i) {
            if (this.mActivities.valueAt(i) != 1) continue;
            return true;
        }
        return false;
    }

    private boolean hasVisibleActivity() {
        int size = this.mActivities.size();
        for (int i = 0; i < size; ++i) {
            int type = this.mActivities.valueAt(i);
            if (type != 1 && type != 2) continue;
            return true;
        }
        return false;
    }

    private boolean anyForegroundServiceStarted() {
        return !this.mForegroundServices.isEmpty();
    }

    private void incrementTimeUsed(long timeStamp) {
        if (timeStamp > this.mLastTimeUsed) {
            this.mTotalTimeInForeground += timeStamp - this.mLastTimeUsed;
            this.mLastTimeUsed = timeStamp;
        }
    }

    private void incrementTimeVisible(long timeStamp) {
        if (timeStamp > this.mLastTimeVisible) {
            this.mTotalTimeVisible += timeStamp - this.mLastTimeVisible;
            this.mLastTimeVisible = timeStamp;
        }
    }

    private void incrementServiceTimeUsed(long timeStamp) {
        if (timeStamp > this.mLastTimeForegroundServiceUsed) {
            this.mTotalTimeForegroundServiceUsed += timeStamp - this.mLastTimeForegroundServiceUsed;
            this.mLastTimeForegroundServiceUsed = timeStamp;
        }
    }

    private void updateActivity(String className, long timeStamp, int eventType, int instanceId) {
        if (eventType != 1 && eventType != 2 && eventType != 23 && eventType != 24) {
            return;
        }
        int index = this.mActivities.indexOfKey(instanceId);
        if (index >= 0) {
            int lastEvent = this.mActivities.valueAt(index);
            switch (lastEvent) {
                case 1: {
                    this.incrementTimeUsed(timeStamp);
                    this.incrementTimeVisible(timeStamp);
                    break;
                }
                case 2: {
                    this.incrementTimeVisible(timeStamp);
                    break;
                }
            }
        }
        switch (eventType) {
            case 1: {
                if (!this.hasVisibleActivity()) {
                    this.mLastTimeUsed = timeStamp;
                    this.mLastTimeVisible = timeStamp;
                } else if (!this.hasForegroundActivity()) {
                    this.mLastTimeUsed = timeStamp;
                }
                this.mActivities.put(instanceId, eventType);
                break;
            }
            case 2: {
                if (!this.hasVisibleActivity()) {
                    this.mLastTimeVisible = timeStamp;
                }
                this.mActivities.put(instanceId, eventType);
                break;
            }
            case 23: 
            case 24: {
                this.mActivities.delete(instanceId);
                break;
            }
        }
    }

    private void updateForegroundService(String className, long timeStamp, int eventType) {
        if (eventType != 20 && eventType != 19) {
            return;
        }
        Integer lastEvent = this.mForegroundServices.get(className);
        if (lastEvent != null) {
            switch (lastEvent) {
                case 19: 
                case 21: {
                    this.incrementServiceTimeUsed(timeStamp);
                    break;
                }
            }
        }
        switch (eventType) {
            case 19: {
                if (!this.anyForegroundServiceStarted()) {
                    this.mLastTimeForegroundServiceUsed = timeStamp;
                }
                this.mForegroundServices.put(className, eventType);
                break;
            }
            case 20: {
                this.mForegroundServices.remove(className);
                break;
            }
        }
    }

    public void update(String className, long timeStamp, int eventType, int instanceId) {
        switch (eventType) {
            case 1: 
            case 2: 
            case 23: 
            case 24: {
                this.updateActivity(className, timeStamp, eventType, instanceId);
                break;
            }
            case 3: {
                if (this.hasForegroundActivity()) {
                    this.incrementTimeUsed(timeStamp);
                }
                if (!this.hasVisibleActivity()) break;
                this.incrementTimeVisible(timeStamp);
                break;
            }
            case 19: 
            case 20: {
                this.updateForegroundService(className, timeStamp, eventType);
                break;
            }
            case 22: {
                if (!this.anyForegroundServiceStarted()) break;
                this.incrementServiceTimeUsed(timeStamp);
                break;
            }
            case 21: {
                this.mLastTimeForegroundServiceUsed = timeStamp;
                this.mForegroundServices.put(className, eventType);
                break;
            }
            case 25: 
            case 26: {
                if (this.hasForegroundActivity()) {
                    this.incrementTimeUsed(timeStamp);
                }
                if (this.hasVisibleActivity()) {
                    this.incrementTimeVisible(timeStamp);
                }
                if (!this.anyForegroundServiceStarted()) break;
                this.incrementServiceTimeUsed(timeStamp);
                break;
            }
            case 7: {
                if (this.hasForegroundActivity()) {
                    this.incrementTimeUsed(timeStamp);
                } else {
                    this.mLastTimeUsed = timeStamp;
                }
                if (this.hasVisibleActivity()) {
                    this.incrementTimeVisible(timeStamp);
                    break;
                }
                this.mLastTimeVisible = timeStamp;
                break;
            }
            case 31: {
                this.mLastTimeComponentUsed = timeStamp;
                break;
            }
        }
        this.mEndTimeStamp = timeStamp;
        if (eventType == 1) {
            ++this.mLaunchCount;
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.mPackageName);
        dest.writeLong(this.mBeginTimeStamp);
        dest.writeLong(this.mEndTimeStamp);
        dest.writeLong(this.mLastTimeUsed);
        dest.writeLong(this.mLastTimeVisible);
        dest.writeLong(this.mLastTimeComponentUsed);
        dest.writeLong(this.mLastTimeForegroundServiceUsed);
        dest.writeLong(this.mTotalTimeInForeground);
        dest.writeLong(this.mTotalTimeVisible);
        dest.writeLong(this.mTotalTimeForegroundServiceUsed);
        dest.writeInt(this.mLaunchCount);
        dest.writeInt(this.mAppLaunchCount);
        dest.writeInt(this.mLastEvent);
        Bundle allCounts = new Bundle();
        if (this.mChooserCounts != null) {
            int chooserCountSize = this.mChooserCounts.size();
            for (int i = 0; i < chooserCountSize; ++i) {
                String action = this.mChooserCounts.keyAt(i);
                ArrayMap<String, Integer> counts = this.mChooserCounts.valueAt(i);
                Bundle currentCounts = new Bundle();
                int annotationSize = counts.size();
                for (int j = 0; j < annotationSize; ++j) {
                    currentCounts.putInt(counts.keyAt(j), counts.valueAt(j));
                }
                allCounts.putBundle(action, currentCounts);
            }
        }
        dest.writeBundle(allCounts);
        this.writeSparseIntArray(dest, this.mActivities);
        dest.writeBundle(this.eventMapToBundle(this.mForegroundServices));
    }

    private void writeSparseIntArray(Parcel dest, SparseIntArray arr) {
        int size = arr.size();
        dest.writeInt(size);
        for (int i = 0; i < size; ++i) {
            dest.writeInt(arr.keyAt(i));
            dest.writeInt(arr.valueAt(i));
        }
    }

    private Bundle eventMapToBundle(ArrayMap<String, Integer> eventMap) {
        Bundle bundle = new Bundle();
        int size = eventMap.size();
        for (int i = 0; i < size; ++i) {
            bundle.putInt(eventMap.keyAt(i), eventMap.valueAt(i));
        }
        return bundle;
    }

    public static class Builder {
        private final UsageStats mUsageStats = new UsageStats();

        public UsageStats build() {
            return this.mUsageStats;
        }

        public Builder setPackageName(String packageName) {
            this.mUsageStats.mPackageName = packageName;
            return this;
        }

        public Builder setFirstTimeStamp(long firstTimeStamp) {
            this.mUsageStats.mBeginTimeStamp = firstTimeStamp;
            return this;
        }

        public Builder setLastTimeStamp(long lastTimeStamp) {
            this.mUsageStats.mEndTimeStamp = lastTimeStamp;
            return this;
        }

        public Builder setTotalTimeInForeground(long totalTimeInForeground) {
            this.mUsageStats.mTotalTimeInForeground = totalTimeInForeground;
            return this;
        }

        public Builder setLastTimeUsed(long lastTimeUsed) {
            this.mUsageStats.mLastTimeUsed = lastTimeUsed;
            return this;
        }
    }
}

