/*
 * Decompiled with CFR 0.152.
 */
package android.apphibernation;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IAppHibernationService
extends IInterface {
    public static final String DESCRIPTOR = "android.apphibernation.IAppHibernationService";

    public boolean isHibernatingForUser(String var1, int var2) throws RemoteException;

    public void setHibernatingForUser(String var1, int var2, boolean var3) throws RemoteException;

    public boolean isHibernatingGlobally(String var1) throws RemoteException;

    public void setHibernatingGlobally(String var1, boolean var2) throws RemoteException;

    public List<String> getHibernatingPackagesForUser(int var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IAppHibernationService {
        static final int TRANSACTION_isHibernatingForUser = 1;
        static final int TRANSACTION_setHibernatingForUser = 2;
        static final int TRANSACTION_isHibernatingGlobally = 3;
        static final int TRANSACTION_setHibernatingGlobally = 4;
        static final int TRANSACTION_getHibernatingPackagesForUser = 5;

        public Stub() {
            this.attachInterface(this, IAppHibernationService.DESCRIPTOR);
        }

        public static IAppHibernationService asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(IAppHibernationService.DESCRIPTOR);
            if (iin != null && iin instanceof IAppHibernationService) {
                return (IAppHibernationService)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "isHibernatingForUser";
                }
                case 2: {
                    return "setHibernatingForUser";
                }
                case 3: {
                    return "isHibernatingGlobally";
                }
                case 4: {
                    return "setHibernatingGlobally";
                }
                case 5: {
                    return "getHibernatingPackagesForUser";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = IAppHibernationService.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _result = this.isHibernatingForUser(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.setHibernatingForUser(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.isHibernatingGlobally(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setHibernatingGlobally(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    List<String> _result = this.getHibernatingPackagesForUser(_arg0);
                    reply.writeNoException();
                    reply.writeStringList(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IAppHibernationService impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IAppHibernationService getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IAppHibernationService {
            private IBinder mRemote;
            public static IAppHibernationService sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return IAppHibernationService.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHibernatingForUser(String packageName, int userId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isHibernatingForUser(packageName, userId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHibernatingForUser(String packageName, int userId, boolean isHibernating) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(userId);
                    _data.writeInt(isHibernating ? 1 : 0);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setHibernatingForUser(packageName, userId, isHibernating);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isHibernatingGlobally(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isHibernatingGlobally(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setHibernatingGlobally(String packageName, boolean isHibernating) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(isHibernating ? 1 : 0);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setHibernatingGlobally(packageName, isHibernating);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<String> getHibernatingPackagesForUser(int userId) throws RemoteException {
                ArrayList<String> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(IAppHibernationService.DESCRIPTOR);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<String> list = Stub.getDefaultImpl().getHibernatingPackagesForUser(userId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createStringArrayList();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IAppHibernationService {
        @Override
        public boolean isHibernatingForUser(String packageName, int userId) throws RemoteException {
            return false;
        }

        @Override
        public void setHibernatingForUser(String packageName, int userId, boolean isHibernating) throws RemoteException {
        }

        @Override
        public boolean isHibernatingGlobally(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void setHibernatingGlobally(String packageName, boolean isHibernating) throws RemoteException {
        }

        @Override
        public List<String> getHibernatingPackagesForUser(int userId) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

