/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.graphics.Bitmap;
import android.graphics.Shader;

public class BitmapShader
extends Shader {
    Bitmap mBitmap;
    private int mTileX;
    private int mTileY;
    private boolean mFilterFromPaint;

    public BitmapShader(Bitmap bitmap, Shader.TileMode tileX, Shader.TileMode tileY) {
        this(bitmap, tileX.nativeInt, tileY.nativeInt);
    }

    private BitmapShader(Bitmap bitmap, int tileX, int tileY) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap must be non-null");
        }
        this.mBitmap = bitmap;
        this.mTileX = tileX;
        this.mTileY = tileY;
        this.mFilterFromPaint = false;
    }

    @Override
    protected long createNativeInstance(long nativeMatrix, boolean filterFromPaint) {
        this.mFilterFromPaint = filterFromPaint;
        return BitmapShader.nativeCreate(nativeMatrix, this.mBitmap.getNativeInstance(), this.mTileX, this.mTileY, this.mFilterFromPaint);
    }

    @Override
    protected boolean shouldDiscardNativeInstance(boolean filterFromPaint) {
        return this.mFilterFromPaint != filterFromPaint;
    }

    private static native long nativeCreate(long var0, long var2, int var4, int var5, boolean var6);
}

