/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.app.AlarmManager;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Binder;
import android.os.Environment;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.SharedMemory;
import android.os.Trace;
import android.os.UserHandle;
import android.system.ErrnoException;
import android.util.Log;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import com.android.internal.lang.System_Delegate;
import com.android.internal.util.DumpUtils;
import com.android.internal.util.FastPrintWriter;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashSet;
import java.util.TimeZone;

public class GraphicsStatsService
extends IGraphicsStats.Stub {
    public static final String GRAPHICS_STATS_SERVICE = "graphicsstats";
    private static final String TAG = "GraphicsStatsService";
    private static final int SAVE_BUFFER = 1;
    private static final int DELETE_OLD = 2;
    private static final int AID_STATSD = 1066;
    private final int mAshmemSize = GraphicsStatsService.nGetAshmemSize();
    private final byte[] mZeroData = new byte[this.mAshmemSize];
    private final Context mContext;
    private final AppOpsManager mAppOps;
    private final AlarmManager mAlarmManager;
    private final Object mLock = new Object();
    private ArrayList<ActiveBuffer> mActive = new ArrayList();
    private File mGraphicsStatsDir;
    private final Object mFileAccessLock = new Object();
    private Handler mWriteOutHandler;
    private boolean mRotateIsScheduled = false;

    public GraphicsStatsService(Context context) {
        this.mContext = context;
        this.mAppOps = context.getSystemService(AppOpsManager.class);
        this.mAlarmManager = context.getSystemService(AlarmManager.class);
        File systemDataDir = new File(Environment.getDataDirectory(), "system");
        this.mGraphicsStatsDir = new File(systemDataDir, GRAPHICS_STATS_SERVICE);
        this.mGraphicsStatsDir.mkdirs();
        if (!this.mGraphicsStatsDir.exists()) {
            throw new IllegalStateException("Graphics stats directory does not exist: " + this.mGraphicsStatsDir.getAbsolutePath());
        }
        HandlerThread bgthread = new HandlerThread("GraphicsStats-disk", 10);
        bgthread.start();
        this.mWriteOutHandler = new Handler(bgthread.getLooper(), new Handler.Callback(){

            @Override
            public boolean handleMessage(Message msg) {
                switch (msg.what) {
                    case 1: {
                        GraphicsStatsService.this.saveBuffer((HistoricalBuffer)msg.obj);
                        break;
                    }
                    case 2: {
                        GraphicsStatsService.this.deleteOldBuffers();
                    }
                }
                return true;
            }
        });
        this.nativeInit();
    }

    private void scheduleRotateLocked() {
        if (this.mRotateIsScheduled) {
            return;
        }
        this.mRotateIsScheduled = true;
        Calendar calendar = this.normalizeDate(System_Delegate.currentTimeMillis());
        calendar.add(5, 1);
        this.mAlarmManager.setExact(1, calendar.getTimeInMillis(), TAG, this::onAlarm, this.mWriteOutHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onAlarm() {
        ActiveBuffer[] activeBufferArray = this.mLock;
        synchronized (this.mLock) {
            this.mRotateIsScheduled = false;
            this.scheduleRotateLocked();
            ActiveBuffer[] activeCopy = this.mActive.toArray(new ActiveBuffer[0]);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            for (ActiveBuffer active : activeCopy) {
                try {
                    active.mCallback.onRotateGraphicsStatsBuffer();
                }
                catch (RemoteException e) {
                    Log.w(TAG, String.format("Failed to notify '%s' (pid=%d) to rotate buffers", active.mInfo.mPackageName, active.mPid), e);
                }
            }
            this.mWriteOutHandler.sendEmptyMessageDelayed(2, 10000L);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ParcelFileDescriptor requestBufferForProcess(String packageName, IGraphicsStatsCallback token) throws RemoteException {
        int uid = Binder.getCallingUid();
        int pid = Binder.getCallingPid();
        ParcelFileDescriptor pfd = null;
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            this.mAppOps.checkPackage(uid, packageName);
            PackageInfo info = this.mContext.getPackageManager().getPackageInfoAsUser(packageName, 0, UserHandle.getUserId(uid));
            Object object = this.mLock;
            synchronized (object) {
                pfd = this.requestBufferForProcessLocked(token, uid, pid, packageName, info.getLongVersionCode());
            }
        }
        catch (PackageManager.NameNotFoundException ex) {
            throw new RemoteException("Unable to find package: '" + packageName + "'");
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
        return pfd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullGraphicsStats(boolean lastFullDay, long pulledData) throws RemoteException {
        StringWriter sw;
        FastPrintWriter pw;
        int uid = Binder.getCallingUid();
        if (uid != 1066 && !DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, pw = new FastPrintWriter(sw = new StringWriter()))) {
            ((PrintWriter)pw).flush();
            throw new RemoteException(sw.toString());
        }
        long callingIdentity = Binder.clearCallingIdentity();
        try {
            this.pullGraphicsStatsImpl(lastFullDay, pulledData);
        }
        finally {
            Binder.restoreCallingIdentity(callingIdentity);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pullGraphicsStatsImpl(boolean lastFullDay, long pulledData) {
        ArrayList<HistoricalBuffer> buffers;
        long targetDay = lastFullDay ? this.normalizeDate(System_Delegate.currentTimeMillis() - 86400000L).getTimeInMillis() : this.normalizeDate(System_Delegate.currentTimeMillis()).getTimeInMillis();
        Object object = this.mLock;
        synchronized (object) {
            buffers = new ArrayList<HistoricalBuffer>(this.mActive.size());
            for (int i = 0; i < this.mActive.size(); ++i) {
                ActiveBuffer buffer = this.mActive.get(i);
                if (buffer.mInfo.mStartTime != targetDay) continue;
                try {
                    buffers.add(new HistoricalBuffer(buffer));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        long dump = GraphicsStatsService.nCreateDump(-1, true);
        try {
            Object object2 = this.mFileAccessLock;
            synchronized (object2) {
                HashSet<File> skipList = this.dumpActiveLocked(dump, buffers);
                buffers.clear();
                String subPath = String.format("%d", targetDay);
                File dateDir = new File(this.mGraphicsStatsDir, subPath);
                if (dateDir.exists()) {
                    for (File pkg : dateDir.listFiles()) {
                        for (File version : pkg.listFiles()) {
                            File data = new File(version, "total");
                            if (skipList.contains(data)) continue;
                            GraphicsStatsService.nAddToDump(dump, data.getAbsolutePath());
                        }
                    }
                }
            }
        }
        finally {
            GraphicsStatsService.nFinishDumpInMemory(dump, pulledData, lastFullDay);
        }
    }

    private ParcelFileDescriptor requestBufferForProcessLocked(IGraphicsStatsCallback token, int uid, int pid, String packageName, long versionCode) throws RemoteException {
        ActiveBuffer buffer = this.fetchActiveBuffersLocked(token, uid, pid, packageName, versionCode);
        this.scheduleRotateLocked();
        return buffer.getPfd();
    }

    private Calendar normalizeDate(long timestamp) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(timestamp);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar;
    }

    private File pathForApp(BufferInfo info) {
        String subPath = String.format("%d/%s/%d/total", this.normalizeDate(info.mStartTime).getTimeInMillis(), info.mPackageName, info.mVersionCode);
        return new File(this.mGraphicsStatsDir, subPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveBuffer(HistoricalBuffer buffer) {
        if (Trace.isTagEnabled(524288L)) {
            Trace.traceBegin(524288L, "saving graphicsstats for " + buffer.mInfo.mPackageName);
        }
        Object object = this.mFileAccessLock;
        synchronized (object) {
            File path = this.pathForApp(buffer.mInfo);
            File parent = path.getParentFile();
            parent.mkdirs();
            if (!parent.exists()) {
                Log.w(TAG, "Unable to create path: '" + parent.getAbsolutePath() + "'");
                return;
            }
            GraphicsStatsService.nSaveBuffer(path.getAbsolutePath(), buffer.mInfo.mPackageName, buffer.mInfo.mVersionCode, buffer.mInfo.mStartTime, buffer.mInfo.mEndTime, buffer.mData);
        }
        Trace.traceEnd(524288L);
    }

    private void deleteRecursiveLocked(File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.deleteRecursiveLocked(child);
            }
        }
        if (!file.delete()) {
            Log.w(TAG, "Failed to delete '" + file.getAbsolutePath() + "'!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteOldBuffers() {
        Trace.traceBegin(524288L, "deleting old graphicsstats buffers");
        Object object = this.mFileAccessLock;
        synchronized (object) {
            int i;
            File[] files = this.mGraphicsStatsDir.listFiles();
            if (files == null || files.length <= 3) {
                return;
            }
            long[] sortedDates = new long[files.length];
            for (i = 0; i < files.length; ++i) {
                try {
                    sortedDates[i] = Long.parseLong(files[i].getName());
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (sortedDates.length <= 3) {
                return;
            }
            Arrays.sort(sortedDates);
            for (i = 0; i < sortedDates.length - 3; ++i) {
                this.deleteRecursiveLocked(new File(this.mGraphicsStatsDir, Long.toString(sortedDates[i])));
            }
        }
        Trace.traceEnd(524288L);
    }

    private void addToSaveQueue(ActiveBuffer buffer) {
        try {
            HistoricalBuffer data = new HistoricalBuffer(buffer);
            Message.obtain(this.mWriteOutHandler, 1, data).sendToTarget();
        }
        catch (IOException e) {
            Log.w(TAG, "Failed to copy graphicsstats from " + buffer.mInfo.mPackageName, e);
        }
        buffer.closeAllBuffers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDied(ActiveBuffer buffer) {
        Object object = this.mLock;
        synchronized (object) {
            this.mActive.remove(buffer);
        }
        this.addToSaveQueue(buffer);
    }

    private ActiveBuffer fetchActiveBuffersLocked(IGraphicsStatsCallback token, int uid, int pid, String packageName, long versionCode) throws RemoteException {
        int size = this.mActive.size();
        long today = this.normalizeDate(System_Delegate.currentTimeMillis()).getTimeInMillis();
        for (int i = 0; i < size; ++i) {
            ActiveBuffer buffer = this.mActive.get(i);
            if (buffer.mPid != pid || buffer.mUid != uid) continue;
            if (buffer.mInfo.mStartTime < today) {
                buffer.binderDied();
                break;
            }
            return buffer;
        }
        try {
            ActiveBuffer buffers = new ActiveBuffer(token, uid, pid, packageName, versionCode);
            this.mActive.add(buffers);
            return buffers;
        }
        catch (IOException ex) {
            throw new RemoteException("Failed to allocate space");
        }
    }

    private HashSet<File> dumpActiveLocked(long dump, ArrayList<HistoricalBuffer> buffers) {
        HashSet<File> skipFiles = new HashSet<File>(buffers.size());
        for (int i = 0; i < buffers.size(); ++i) {
            HistoricalBuffer buffer = buffers.get(i);
            File path = this.pathForApp(buffer.mInfo);
            skipFiles.add(path);
            GraphicsStatsService.nAddToDump(dump, path.getAbsolutePath(), buffer.mInfo.mPackageName, buffer.mInfo.mVersionCode, buffer.mInfo.mStartTime, buffer.mInfo.mEndTime, buffer.mData);
        }
        return skipFiles;
    }

    private void dumpHistoricalLocked(long dump, HashSet<File> skipFiles) {
        for (File date : this.mGraphicsStatsDir.listFiles()) {
            for (File pkg : date.listFiles()) {
                for (File version : pkg.listFiles()) {
                    File data = new File(version, "total");
                    if (skipFiles.contains(data)) continue;
                    GraphicsStatsService.nAddToDump(dump, data.getAbsolutePath());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dump(FileDescriptor fd, PrintWriter fout, String[] args) {
        ArrayList<HistoricalBuffer> buffers;
        if (!DumpUtils.checkDumpAndUsageStatsPermission(this.mContext, TAG, fout)) {
            return;
        }
        boolean dumpProto = false;
        for (String str : args) {
            if (!"--proto".equals(str)) continue;
            dumpProto = true;
            break;
        }
        Object object = this.mLock;
        synchronized (object) {
            buffers = new ArrayList<HistoricalBuffer>(this.mActive.size());
            for (int i = 0; i < this.mActive.size(); ++i) {
                try {
                    buffers.add(new HistoricalBuffer(this.mActive.get(i)));
                    continue;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        long dump = GraphicsStatsService.nCreateDump(fd.getInt$(), dumpProto);
        try {
            Object object2 = this.mFileAccessLock;
            synchronized (object2) {
                HashSet<File> skipList = this.dumpActiveLocked(dump, buffers);
                buffers.clear();
                this.dumpHistoricalLocked(dump, skipList);
            }
        }
        finally {
            GraphicsStatsService.nFinishDump(dump);
        }
    }

    protected void finalize() throws Throwable {
        GraphicsStatsService.nativeDestructor();
    }

    private void nativeInit() {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nativeInit()V", true, this);
    }

    private static void nativeDestructor() {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nativeDestructor()V", true, null);
    }

    private static int nGetAshmemSize() {
        return OverrideMethod.invokeI("android.graphics.GraphicsStatsService#nGetAshmemSize()I", true, null);
    }

    private static long nCreateDump(int n, boolean bl) {
        return OverrideMethod.invokeL("android.graphics.GraphicsStatsService#nCreateDump(IZ)J", true, null);
    }

    private static void nAddToDump(long l, String string2, String string3, long l2, long l3, long l4, byte[] byArray) {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nAddToDump(JLjava/lang/String;Ljava/lang/String;JJJ[B)V", true, null);
    }

    private static void nAddToDump(long l, String string2) {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nAddToDump(JLjava/lang/String;)V", true, null);
    }

    private static void nFinishDump(long l) {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nFinishDump(J)V", true, null);
    }

    private static void nFinishDumpInMemory(long l, long l2, boolean bl) {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nFinishDumpInMemory(JJZ)V", true, null);
    }

    private static void nSaveBuffer(String string2, String string3, long l, long l2, long l3, byte[] byArray) {
        OverrideMethod.invokeV("android.graphics.GraphicsStatsService#nSaveBuffer(Ljava/lang/String;Ljava/lang/String;JJJ[B)V", true, null);
    }

    private class HistoricalBuffer {
        final BufferInfo mInfo;
        final byte[] mData;

        HistoricalBuffer(ActiveBuffer active) throws IOException {
            this.mData = new byte[GraphicsStatsService.this.mAshmemSize];
            this.mInfo = active.mInfo;
            this.mInfo.mEndTime = System_Delegate.currentTimeMillis();
            active.readBytes(this.mData, GraphicsStatsService.this.mAshmemSize);
        }
    }

    private class ActiveBuffer
    implements IBinder.DeathRecipient {
        final BufferInfo mInfo;
        final int mUid;
        final int mPid;
        final IGraphicsStatsCallback mCallback;
        final IBinder mToken;
        SharedMemory mProcessBuffer;
        ByteBuffer mMapping;

        ActiveBuffer(IGraphicsStatsCallback token, int uid, int pid, String packageName, long versionCode) throws RemoteException, IOException {
            this.mInfo = new BufferInfo(packageName, versionCode, System_Delegate.currentTimeMillis());
            this.mUid = uid;
            this.mPid = pid;
            this.mCallback = token;
            this.mToken = this.mCallback.asBinder();
            this.mToken.linkToDeath(this, 0);
            try {
                this.mProcessBuffer = SharedMemory.create("GFXStats-" + pid, GraphicsStatsService.this.mAshmemSize);
                this.mMapping = this.mProcessBuffer.mapReadWrite();
            }
            catch (ErrnoException ex) {
                ex.rethrowAsIOException();
            }
            this.mMapping.position(0);
            this.mMapping.put(GraphicsStatsService.this.mZeroData, 0, GraphicsStatsService.this.mAshmemSize);
        }

        @Override
        public void binderDied() {
            this.mToken.unlinkToDeath(this, 0);
            GraphicsStatsService.this.processDied(this);
        }

        void closeAllBuffers() {
            if (this.mMapping != null) {
                SharedMemory.unmap(this.mMapping);
                this.mMapping = null;
            }
            if (this.mProcessBuffer != null) {
                this.mProcessBuffer.close();
                this.mProcessBuffer = null;
            }
        }

        ParcelFileDescriptor getPfd() {
            try {
                return this.mProcessBuffer.getFdDup();
            }
            catch (IOException ex) {
                throw new IllegalStateException("Failed to get PFD from memory file", ex);
            }
        }

        void readBytes(byte[] buffer, int count) throws IOException {
            if (this.mMapping == null) {
                throw new IOException("SharedMemory has been deactivated");
            }
            this.mMapping.position(0);
            this.mMapping.get(buffer, 0, count);
        }
    }

    private class BufferInfo {
        final String mPackageName;
        final long mVersionCode;
        long mStartTime;
        long mEndTime;

        BufferInfo(String packageName, long versionCode, long startTime) {
            this.mPackageName = packageName;
            this.mVersionCode = versionCode;
            this.mStartTime = startTime;
        }
    }
}

