/*
 * Decompiled with CFR 0.152.
 */
package android.graphics;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.Surface;
import com.android.tools.layoutlib.create.OverrideMethod;
import java.lang.ref.WeakReference;

public class SurfaceTexture {
    private final Looper mCreatorLooper = Looper.myLooper();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private Handler mOnFrameAvailableHandler;
    @UnsupportedAppUsage(trackingBug=176388660L)
    private long mSurfaceTexture;
    @UnsupportedAppUsage(trackingBug=176388660L)
    private long mProducer;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private long mFrameAvailableListener;
    private boolean mIsSingleBuffered;

    public SurfaceTexture(int texName) {
        this(texName, false);
    }

    public SurfaceTexture(int texName, boolean singleBufferMode) {
        this.mIsSingleBuffered = singleBufferMode;
        this.nativeInit(false, texName, singleBufferMode, new WeakReference<SurfaceTexture>(this));
    }

    public SurfaceTexture(boolean singleBufferMode) {
        this.mIsSingleBuffered = singleBufferMode;
        this.nativeInit(true, 0, singleBufferMode, new WeakReference<SurfaceTexture>(this));
    }

    public void setOnFrameAvailableListener(OnFrameAvailableListener listener) {
        this.setOnFrameAvailableListener(listener, null);
    }

    public void setOnFrameAvailableListener(final OnFrameAvailableListener listener, Handler handler) {
        if (listener != null) {
            Looper looper = handler != null ? handler.getLooper() : (this.mCreatorLooper != null ? this.mCreatorLooper : Looper.getMainLooper());
            this.mOnFrameAvailableHandler = new Handler(looper, null, true){

                @Override
                public void handleMessage(Message msg) {
                    listener.onFrameAvailable(SurfaceTexture.this);
                }
            };
        } else {
            this.mOnFrameAvailableHandler = null;
        }
    }

    public void setDefaultBufferSize(int width, int height) {
        this.nativeSetDefaultBufferSize(width, height);
    }

    public void updateTexImage() {
        this.nativeUpdateTexImage();
    }

    public void releaseTexImage() {
        this.nativeReleaseTexImage();
    }

    public void detachFromGLContext() {
        int err = this.nativeDetachFromGLContext();
        if (err != 0) {
            throw new RuntimeException("Error during detachFromGLContext (see logcat for details)");
        }
    }

    public void attachToGLContext(int texName) {
        int err = this.nativeAttachToGLContext(texName);
        if (err != 0) {
            throw new RuntimeException("Error during attachToGLContext (see logcat for details)");
        }
    }

    public void getTransformMatrix(float[] mtx) {
        if (mtx.length != 16) {
            throw new IllegalArgumentException();
        }
        this.nativeGetTransformMatrix(mtx);
    }

    public long getTimestamp() {
        return this.nativeGetTimestamp();
    }

    public void release() {
        this.nativeRelease();
    }

    public boolean isReleased() {
        return this.nativeIsReleased();
    }

    protected void finalize() throws Throwable {
        try {
            this.nativeFinalize();
        }
        finally {
            super.finalize();
        }
    }

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private static void postEventFromNative(WeakReference<SurfaceTexture> weakSelf) {
        Handler handler;
        SurfaceTexture st = (SurfaceTexture)weakSelf.get();
        if (st != null && (handler = st.mOnFrameAvailableHandler) != null) {
            handler.sendEmptyMessage(0);
        }
    }

    public boolean isSingleBuffered() {
        return this.mIsSingleBuffered;
    }

    private void nativeInit(boolean bl, int n, boolean bl2, WeakReference<SurfaceTexture> weakReference) throws Surface.OutOfResourcesException {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeInit(ZIZLjava/lang/ref/WeakReference;)V", true, this);
    }

    private void nativeFinalize() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeFinalize()V", true, this);
    }

    private void nativeGetTransformMatrix(float[] fArray) {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeGetTransformMatrix([F)V", true, this);
    }

    private long nativeGetTimestamp() {
        return OverrideMethod.invokeL("android.graphics.SurfaceTexture#nativeGetTimestamp()J", true, this);
    }

    private void nativeSetDefaultBufferSize(int n, int n2) {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeSetDefaultBufferSize(II)V", true, this);
    }

    private void nativeUpdateTexImage() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeUpdateTexImage()V", true, this);
    }

    private void nativeReleaseTexImage() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeReleaseTexImage()V", true, this);
    }

    @UnsupportedAppUsage
    private int nativeDetachFromGLContext() {
        return OverrideMethod.invokeI("android.graphics.SurfaceTexture#nativeDetachFromGLContext()I", true, this);
    }

    private int nativeAttachToGLContext(int n) {
        return OverrideMethod.invokeI("android.graphics.SurfaceTexture#nativeAttachToGLContext(I)I", true, this);
    }

    private void nativeRelease() {
        OverrideMethod.invokeV("android.graphics.SurfaceTexture#nativeRelease()V", true, this);
    }

    private boolean nativeIsReleased() {
        return OverrideMethod.invokeI("android.graphics.SurfaceTexture#nativeIsReleased()Z", true, this) != 0;
    }

    @Deprecated
    public static class OutOfResourcesException
    extends Exception {
        public OutOfResourcesException() {
        }

        public OutOfResourcesException(String name) {
            super(name);
        }
    }

    public static interface OnFrameAvailableListener {
        public void onFrameAvailable(SurfaceTexture var1);
    }
}

