/*
 * Decompiled with CFR 0.152.
 */
package android.graphics.drawable;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Insets;
import android.graphics.Outline;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.util.AttributeSet;
import android.util.TypedValue;
import com.android.internal.R;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class InsetDrawable
extends DrawableWrapper {
    private final Rect mTmpRect = new Rect();
    private final Rect mTmpInsetRect = new Rect();
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private InsetState mState;

    InsetDrawable() {
        this(new InsetState(null, null), null);
    }

    public InsetDrawable(Drawable drawable2, int inset) {
        this(drawable2, inset, inset, inset, inset);
    }

    public InsetDrawable(Drawable drawable2, float inset) {
        this(drawable2, inset, inset, inset, inset);
    }

    public InsetDrawable(Drawable drawable2, int insetLeft, int insetTop, int insetRight, int insetBottom) {
        this(new InsetState(null, null), null);
        this.mState.mInsetLeft = new InsetValue(0.0f, insetLeft);
        this.mState.mInsetTop = new InsetValue(0.0f, insetTop);
        this.mState.mInsetRight = new InsetValue(0.0f, insetRight);
        this.mState.mInsetBottom = new InsetValue(0.0f, insetBottom);
        this.setDrawable(drawable2);
    }

    public InsetDrawable(Drawable drawable2, float insetLeftFraction, float insetTopFraction, float insetRightFraction, float insetBottomFraction) {
        this(new InsetState(null, null), null);
        this.mState.mInsetLeft = new InsetValue(insetLeftFraction, 0);
        this.mState.mInsetTop = new InsetValue(insetTopFraction, 0);
        this.mState.mInsetRight = new InsetValue(insetRightFraction, 0);
        this.mState.mInsetBottom = new InsetValue(insetBottomFraction, 0);
        this.setDrawable(drawable2);
    }

    @Override
    public void inflate(Resources r, XmlPullParser parser, AttributeSet attrs, Resources.Theme theme) throws XmlPullParserException, IOException {
        TypedArray a = InsetDrawable.obtainAttributes(r, theme, attrs, R.styleable.InsetDrawable);
        super.inflate(r, parser, attrs, theme);
        this.updateStateFromTypedArray(a);
        this.verifyRequiredAttributes(a);
        a.recycle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyTheme(Resources.Theme t) {
        super.applyTheme(t);
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        if (state.mThemeAttrs != null) {
            TypedArray a = t.resolveAttributes(state.mThemeAttrs, R.styleable.InsetDrawable);
            try {
                this.updateStateFromTypedArray(a);
                this.verifyRequiredAttributes(a);
            }
            catch (XmlPullParserException e) {
                InsetDrawable.rethrowAsRuntimeException((Exception)((Object)e));
            }
            finally {
                a.recycle();
            }
        }
    }

    private void verifyRequiredAttributes(TypedArray a) throws XmlPullParserException {
        if (this.getDrawable() == null && (this.mState.mThemeAttrs == null || this.mState.mThemeAttrs[1] == 0)) {
            throw new XmlPullParserException(a.getPositionDescription() + ": <inset> tag requires a 'drawable' attribute or child tag defining a drawable");
        }
    }

    private void updateStateFromTypedArray(TypedArray a) {
        InsetState state = this.mState;
        if (state == null) {
            return;
        }
        state.mChangingConfigurations |= a.getChangingConfigurations();
        InsetState.access$002(state, a.extractThemeAttrs());
        if (a.hasValue(6)) {
            InsetValue inset;
            state.mInsetLeft = inset = this.getInset(a, 6, new InsetValue());
            state.mInsetTop = inset;
            state.mInsetRight = inset;
            state.mInsetBottom = inset;
        }
        state.mInsetLeft = this.getInset(a, 2, state.mInsetLeft);
        state.mInsetTop = this.getInset(a, 4, state.mInsetTop);
        state.mInsetRight = this.getInset(a, 3, state.mInsetRight);
        state.mInsetBottom = this.getInset(a, 5, state.mInsetBottom);
    }

    private InsetValue getInset(TypedArray a, int index, InsetValue defaultValue) {
        if (a.hasValue(index)) {
            TypedValue tv = a.peekValue(index);
            if (tv.type == 6) {
                float f = tv.getFraction(1.0f, 1.0f);
                if (f >= 1.0f) {
                    throw new IllegalStateException("Fraction cannot be larger than 1");
                }
                return new InsetValue(f, 0);
            }
            int dimension = a.getDimensionPixelOffset(index, 0);
            if (dimension != 0) {
                return new InsetValue(0.0f, dimension);
            }
        }
        return defaultValue;
    }

    private void getInsets(Rect out) {
        Rect b = this.getBounds();
        out.left = this.mState.mInsetLeft.getDimension(b.width());
        out.right = this.mState.mInsetRight.getDimension(b.width());
        out.top = this.mState.mInsetTop.getDimension(b.height());
        out.bottom = this.mState.mInsetBottom.getDimension(b.height());
    }

    @Override
    public boolean getPadding(Rect padding) {
        boolean pad = super.getPadding(padding);
        this.getInsets(this.mTmpInsetRect);
        padding.left += this.mTmpInsetRect.left;
        padding.right += this.mTmpInsetRect.right;
        padding.top += this.mTmpInsetRect.top;
        padding.bottom += this.mTmpInsetRect.bottom;
        return pad || (this.mTmpInsetRect.left | this.mTmpInsetRect.right | this.mTmpInsetRect.top | this.mTmpInsetRect.bottom) != 0;
    }

    @Override
    public Insets getOpticalInsets() {
        Insets contentInsets = super.getOpticalInsets();
        this.getInsets(this.mTmpInsetRect);
        return Insets.of(contentInsets.left + this.mTmpInsetRect.left, contentInsets.top + this.mTmpInsetRect.top, contentInsets.right + this.mTmpInsetRect.right, contentInsets.bottom + this.mTmpInsetRect.bottom);
    }

    @Override
    public int getOpacity() {
        InsetState state = this.mState;
        int opacity = this.getDrawable().getOpacity();
        this.getInsets(this.mTmpInsetRect);
        if (opacity == -1 && (this.mTmpInsetRect.left > 0 || this.mTmpInsetRect.top > 0 || this.mTmpInsetRect.right > 0 || this.mTmpInsetRect.bottom > 0)) {
            return -3;
        }
        return opacity;
    }

    @Override
    protected void onBoundsChange(Rect bounds) {
        Rect r = this.mTmpRect;
        r.set(bounds);
        r.left += this.mState.mInsetLeft.getDimension(bounds.width());
        r.top += this.mState.mInsetTop.getDimension(bounds.height());
        r.right -= this.mState.mInsetRight.getDimension(bounds.width());
        r.bottom -= this.mState.mInsetBottom.getDimension(bounds.height());
        super.onBoundsChange(r);
    }

    @Override
    public int getIntrinsicWidth() {
        int childWidth = this.getDrawable().getIntrinsicWidth();
        float fraction2 = this.mState.mInsetLeft.mFraction + this.mState.mInsetRight.mFraction;
        if (childWidth < 0 || fraction2 >= 1.0f) {
            return -1;
        }
        return (int)((float)childWidth / (1.0f - fraction2)) + this.mState.mInsetLeft.mDimension + this.mState.mInsetRight.mDimension;
    }

    @Override
    public int getIntrinsicHeight() {
        int childHeight = this.getDrawable().getIntrinsicHeight();
        float fraction2 = this.mState.mInsetTop.mFraction + this.mState.mInsetBottom.mFraction;
        if (childHeight < 0 || fraction2 >= 1.0f) {
            return -1;
        }
        return (int)((float)childHeight / (1.0f - fraction2)) + this.mState.mInsetTop.mDimension + this.mState.mInsetBottom.mDimension;
    }

    @Override
    public void getOutline(Outline outline) {
        this.getDrawable().getOutline(outline);
    }

    @Override
    DrawableWrapper.DrawableWrapperState mutateConstantState() {
        this.mState = new InsetState(this.mState, null);
        return this.mState;
    }

    private InsetDrawable(InsetState state, Resources res) {
        super(state, res);
        this.mState = state;
    }

    static class InsetValue
    implements Cloneable {
        final float mFraction;
        int mDimension;

        public InsetValue() {
            this(0.0f, 0);
        }

        public InsetValue(float fraction2, int dimension) {
            this.mFraction = fraction2;
            this.mDimension = dimension;
        }

        int getDimension(int boundSize) {
            return (int)((float)boundSize * this.mFraction) + this.mDimension;
        }

        void scaleFromDensity(int sourceDensity, int targetDensity) {
            if (this.mDimension != 0) {
                this.mDimension = Bitmap.scaleFromDensity(this.mDimension, sourceDensity, targetDensity);
            }
        }

        public InsetValue clone() {
            return new InsetValue(this.mFraction, this.mDimension);
        }
    }

    static class InsetState
    extends DrawableWrapper.DrawableWrapperState {
        private int[] mThemeAttrs;
        InsetValue mInsetLeft;
        InsetValue mInsetTop;
        InsetValue mInsetRight;
        InsetValue mInsetBottom;

        InsetState(InsetState orig, Resources res) {
            super(orig, res);
            if (orig != null) {
                this.mInsetLeft = orig.mInsetLeft.clone();
                this.mInsetTop = orig.mInsetTop.clone();
                this.mInsetRight = orig.mInsetRight.clone();
                this.mInsetBottom = orig.mInsetBottom.clone();
                if (orig.mDensity != this.mDensity) {
                    this.applyDensityScaling(orig.mDensity, this.mDensity);
                }
            } else {
                this.mInsetLeft = new InsetValue();
                this.mInsetTop = new InsetValue();
                this.mInsetRight = new InsetValue();
                this.mInsetBottom = new InsetValue();
            }
        }

        @Override
        void onDensityChanged(int sourceDensity, int targetDensity) {
            super.onDensityChanged(sourceDensity, targetDensity);
            this.applyDensityScaling(sourceDensity, targetDensity);
        }

        private void applyDensityScaling(int sourceDensity, int targetDensity) {
            this.mInsetLeft.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetTop.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetRight.scaleFromDensity(sourceDensity, targetDensity);
            this.mInsetBottom.scaleFromDensity(sourceDensity, targetDensity);
        }

        @Override
        public Drawable newDrawable(Resources res) {
            InsetState state;
            if (res != null) {
                int density;
                int densityDpi = res.getDisplayMetrics().densityDpi;
                int n = density = densityDpi == 0 ? 160 : densityDpi;
                state = density != this.mDensity ? new InsetState(this, res) : this;
            } else {
                state = this;
            }
            return new InsetDrawable(state, res);
        }

        static /* synthetic */ int[] access$002(InsetState x0, int[] x1) {
            x0.mThemeAttrs = x1;
            return x1;
        }
    }
}

