/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.content.Context;
import android.hardware.CameraStatus;
import android.hardware.ICameraService;
import android.hardware.ICameraServiceListener;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraExtensionCharacteristics;
import android.hardware.camera2.CameraInjectionSession;
import android.hardware.camera2.ICameraDeviceUser;
import android.hardware.camera2.ICameraInjectionSession;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.hardware.camera2.impl.CameraInjectionSessionImpl;
import android.hardware.camera2.impl.CameraMetadataNative;
import android.hardware.camera2.params.SessionConfiguration;
import android.hardware.camera2.params.StreamConfiguration;
import android.hardware.camera2.utils.CameraIdAndSessionConfiguration;
import android.hardware.camera2.utils.ConcurrentCameraIdCombination;
import android.hardware.display.DisplayManager;
import android.os.Binder;
import android.os.DeadObjectException;
import android.os.Handler;
import android.os.IBinder;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.ServiceSpecificException;
import android.os.SystemProperties;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class CameraManager {
    private static final String TAG = "CameraManager";
    private final boolean DEBUG = false;
    private static final int USE_CALLING_UID = -1;
    private static final int API_VERSION_1 = 1;
    private static final int API_VERSION_2 = 2;
    private static final int CAMERA_TYPE_BACKWARD_COMPATIBLE = 0;
    private static final int CAMERA_TYPE_ALL = 1;
    private ArrayList<String> mDeviceIdList;
    private final Context mContext;
    private final Object mLock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraManager(Context context) {
        Object object = this.mLock = new Object();
        synchronized (object) {
            this.mContext = context;
        }
    }

    public String[] getCameraIdList() throws CameraAccessException {
        return CameraManagerGlobal.get().getCameraIdList();
    }

    public String[] getCameraIdListNoLazy() throws CameraAccessException {
        return CameraManagerGlobal.get().getCameraIdListNoLazy();
    }

    public Set<Set<String>> getConcurrentCameraIds() throws CameraAccessException {
        return CameraManagerGlobal.get().getConcurrentCameraIds();
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public boolean isConcurrentSessionConfigurationSupported(Map<String, SessionConfiguration> cameraIdAndSessionConfig) throws CameraAccessException {
        return CameraManagerGlobal.get().isConcurrentSessionConfigurationSupported(cameraIdAndSessionConfig, this.mContext.getApplicationInfo().targetSdkVersion);
    }

    public void registerAvailabilityCallback(AvailabilityCallback callback, Handler handler) {
        CameraManagerGlobal.get().registerAvailabilityCallback(callback, CameraDeviceImpl.checkAndWrapHandler(handler));
    }

    public void registerAvailabilityCallback(Executor executor, AvailabilityCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        CameraManagerGlobal.get().registerAvailabilityCallback(callback, executor);
    }

    public void unregisterAvailabilityCallback(AvailabilityCallback callback) {
        CameraManagerGlobal.get().unregisterAvailabilityCallback(callback);
    }

    public void registerTorchCallback(TorchCallback callback, Handler handler) {
        CameraManagerGlobal.get().registerTorchCallback(callback, CameraDeviceImpl.checkAndWrapHandler(handler));
    }

    public void registerTorchCallback(Executor executor, TorchCallback callback) {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        CameraManagerGlobal.get().registerTorchCallback(callback, executor);
    }

    public void unregisterTorchCallback(TorchCallback callback) {
        CameraManagerGlobal.get().unregisterTorchCallback(callback);
    }

    private Size getDisplaySize() {
        Size ret = new Size(0, 0);
        try {
            DisplayManager displayManager = (DisplayManager)this.mContext.getSystemService("display");
            Display display = displayManager.getDisplay(0);
            if (display != null) {
                int width = display.getWidth();
                int height = display.getHeight();
                if (height > width) {
                    height = width;
                    width = display.getHeight();
                }
                ret = new Size(width, height);
            } else {
                Log.e(TAG, "Invalid default display!");
            }
        }
        catch (Exception e) {
            Log.e(TAG, "getDisplaySize Failed. " + e.toString());
        }
        return ret;
    }

    private Map<String, StreamConfiguration[]> getPhysicalCameraMultiResolutionConfigs(String cameraId, CameraMetadataNative info, ICameraService cameraService) throws CameraAccessException {
        HashMap<String, StreamConfiguration[]> multiResolutionStreamConfigurations = new HashMap<String, StreamConfiguration[]>();
        Boolean multiResolutionStreamSupported = info.get(CameraCharacteristics.SCALER_MULTI_RESOLUTION_STREAM_SUPPORTED);
        if (multiResolutionStreamSupported == null || !multiResolutionStreamSupported.booleanValue()) {
            return multiResolutionStreamConfigurations;
        }
        Set<String> physicalCameraIds = info.getPhysicalCameraIds();
        if (physicalCameraIds.size() == 0 && info.isUltraHighResolutionSensor()) {
            StreamConfiguration[] configs = info.get(CameraCharacteristics.SCALER_PHYSICAL_CAMERA_MULTI_RESOLUTION_STREAM_CONFIGURATIONS);
            if (configs != null) {
                multiResolutionStreamConfigurations.put(cameraId, configs);
            }
            return multiResolutionStreamConfigurations;
        }
        try {
            for (String physicalCameraId : physicalCameraIds) {
                CameraMetadataNative physicalCameraInfo = cameraService.getCameraCharacteristics(physicalCameraId, this.mContext.getApplicationInfo().targetSdkVersion);
                StreamConfiguration[] configs = physicalCameraInfo.get(CameraCharacteristics.SCALER_PHYSICAL_CAMERA_MULTI_RESOLUTION_STREAM_CONFIGURATIONS);
                if (configs == null) continue;
                multiResolutionStreamConfigurations.put(physicalCameraId, configs);
            }
        }
        catch (RemoteException e) {
            ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
            CameraManager.throwAsPublicException(sse);
        }
        return multiResolutionStreamConfigurations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CameraCharacteristics getCameraCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics characteristics = null;
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        Object object = this.mLock;
        synchronized (object) {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                throw new CameraAccessException(2, "Camera service is currently unavailable");
            }
            try {
                Size displaySize = this.getDisplaySize();
                CameraMetadataNative info = cameraService.getCameraCharacteristics(cameraId, this.mContext.getApplicationInfo().targetSdkVersion);
                try {
                    info.setCameraId(Integer.parseInt(cameraId));
                }
                catch (NumberFormatException e) {
                    Log.v(TAG, "Failed to parse camera Id " + cameraId + " to integer");
                }
                boolean hasConcurrentStreams = CameraManagerGlobal.get().cameraIdHasConcurrentStreamsLocked(cameraId);
                info.setHasMandatoryConcurrentStreams(hasConcurrentStreams);
                info.setDisplaySize(displaySize);
                Map<String, StreamConfiguration[]> multiResolutionSizeMap = this.getPhysicalCameraMultiResolutionConfigs(cameraId, info, cameraService);
                if (multiResolutionSizeMap.size() > 0) {
                    info.setMultiResolutionStreamConfigurationMap(multiResolutionSizeMap);
                }
                characteristics = new CameraCharacteristics(info);
            }
            catch (ServiceSpecificException e) {
                CameraManager.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                throw new CameraAccessException(2, "Camera service is currently unavailable", e);
            }
        }
        return characteristics;
    }

    public CameraExtensionCharacteristics getCameraExtensionCharacteristics(String cameraId) throws CameraAccessException {
        CameraCharacteristics chars = this.getCameraCharacteristics(cameraId);
        return new CameraExtensionCharacteristics(this.mContext, cameraId, chars);
    }

    private Map<String, CameraCharacteristics> getPhysicalIdToCharsMap(CameraCharacteristics chars) throws CameraAccessException {
        HashMap<String, CameraCharacteristics> physicalIdsToChars = new HashMap<String, CameraCharacteristics>();
        Set<String> physicalCameraIds = chars.getPhysicalCameraIds();
        for (String physicalCameraId : physicalCameraIds) {
            CameraCharacteristics physicalChars = this.getCameraCharacteristics(physicalCameraId);
            physicalIdsToChars.put(physicalCameraId, physicalChars);
        }
        return physicalIdsToChars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid, int oomScoreOffset) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl device = null;
        Map<String, CameraCharacteristics> physicalIdsToChars = this.getPhysicalIdToCharsMap(characteristics);
        Object object = this.mLock;
        synchronized (object) {
            ICameraDeviceUser cameraUser = null;
            CameraDeviceImpl deviceImpl = new CameraDeviceImpl(cameraId, callback, executor, characteristics, physicalIdsToChars, this.mContext.getApplicationInfo().targetSdkVersion, this.mContext);
            CameraDeviceImpl.CameraDeviceCallbacks callbacks = deviceImpl.getCallbacks();
            try {
                ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
                if (cameraService == null) {
                    throw new ServiceSpecificException(4, "Camera service is currently unavailable");
                }
                cameraUser = cameraService.connectDevice(callbacks, cameraId, this.mContext.getOpPackageName(), this.mContext.getAttributionTag(), uid, oomScoreOffset, this.mContext.getApplicationInfo().targetSdkVersion);
            }
            catch (ServiceSpecificException e) {
                if (e.errorCode == 9) {
                    throw new AssertionError((Object)"Should've gone down the shim path");
                }
                if (e.errorCode == 7 || e.errorCode == 8 || e.errorCode == 6 || e.errorCode == 4 || e.errorCode == 10) {
                    deviceImpl.setRemoteFailure(e);
                    if (e.errorCode == 6 || e.errorCode == 4 || e.errorCode == 7) {
                        CameraManager.throwAsPublicException(e);
                    }
                } else {
                    CameraManager.throwAsPublicException(e);
                }
            }
            catch (RemoteException e) {
                ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
                deviceImpl.setRemoteFailure(sse);
                CameraManager.throwAsPublicException(sse);
            }
            deviceImpl.setRemoteDevice(cameraUser);
            device = deviceImpl;
        }
        return device;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        this.openCameraForUid(cameraId, callback, CameraDeviceImpl.checkAndWrapHandler(handler), -1);
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public void openCamera(String cameraId, Executor executor, CameraDevice.StateCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        this.openCameraForUid(cameraId, callback, executor, -1);
    }

    @SystemApi
    @RequiresPermission(allOf={"android.permission.SYSTEM_CAMERA", "android.permission.CAMERA"})
    public void openCamera(String cameraId, int oomScoreOffset, Executor executor, CameraDevice.StateCallback callback) throws CameraAccessException {
        if (executor == null) {
            throw new IllegalArgumentException("executor was null");
        }
        if (oomScoreOffset < 0) {
            throw new IllegalArgumentException("oomScoreOffset < 0, cannot increase priority of camera client");
        }
        this.openCameraForUid(cameraId, callback, executor, -1, oomScoreOffset);
    }

    public void openCameraForUid(String cameraId, CameraDevice.StateCallback callback, Executor executor, int clientUid, int oomScoreOffset) throws CameraAccessException {
        if (cameraId == null) {
            throw new IllegalArgumentException("cameraId was null");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback was null");
        }
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        this.openCameraDeviceUserAsync(cameraId, callback, executor, clientUid, oomScoreOffset);
    }

    public void openCameraForUid(String cameraId, CameraDevice.StateCallback callback, Executor executor, int clientUid) throws CameraAccessException {
        this.openCameraForUid(cameraId, callback, executor, clientUid, 0);
    }

    public void setTorchMode(String cameraId, boolean enabled) throws CameraAccessException {
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        CameraManagerGlobal.get().setTorchMode(cameraId, enabled);
    }

    public static void throwAsPublicException(Throwable t) throws CameraAccessException {
        if (t instanceof ServiceSpecificException) {
            ServiceSpecificException e = (ServiceSpecificException)t;
            int reason = 3;
            switch (e.errorCode) {
                case 4: {
                    reason = 2;
                    break;
                }
                case 6: {
                    reason = 1;
                    break;
                }
                case 7: {
                    reason = 4;
                    break;
                }
                case 8: {
                    reason = 5;
                    break;
                }
                case 9: {
                    reason = 1000;
                    break;
                }
                case 2: 
                case 3: {
                    throw new IllegalArgumentException(e.getMessage(), e);
                }
                case 1: {
                    throw new SecurityException(e.getMessage(), e);
                }
                default: {
                    reason = 3;
                }
            }
            throw new CameraAccessException(reason, e.getMessage(), e);
        }
        if (t instanceof DeadObjectException) {
            throw new CameraAccessException(2, "Camera service has died unexpectedly", t);
        }
        if (t instanceof RemoteException) {
            throw new UnsupportedOperationException("An unknown RemoteException was thrown which should never happen.", t);
        }
        if (t instanceof RuntimeException) {
            RuntimeException e = (RuntimeException)t;
            throw e;
        }
    }

    public static boolean isHiddenPhysicalCamera(String cameraId) {
        try {
            ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
            if (cameraService == null) {
                return false;
            }
            return cameraService.isHiddenPhysicalCamera(cameraId);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA_INJECT_EXTERNAL_CAMERA")
    public void injectCamera(String packageName, String internalCamId, String externalCamId, Executor executor, CameraInjectionSession.InjectionStatusCallback callback) throws CameraAccessException, SecurityException, IllegalArgumentException {
        if (CameraManagerGlobal.sCameraServiceDisabled) {
            throw new IllegalArgumentException("No cameras available on device");
        }
        ICameraService cameraService = CameraManagerGlobal.get().getCameraService();
        if (cameraService == null) {
            throw new CameraAccessException(2, "Camera service is currently unavailable");
        }
        Object object = this.mLock;
        synchronized (object) {
            try {
                CameraInjectionSessionImpl injectionSessionImpl = new CameraInjectionSessionImpl(callback, executor);
                CameraInjectionSessionImpl.CameraInjectionCallback cameraInjectionCallback = injectionSessionImpl.getCallback();
                ICameraInjectionSession injectionSession = cameraService.injectCamera(packageName, internalCamId, externalCamId, cameraInjectionCallback);
                injectionSessionImpl.setRemoteInjectionSession(injectionSession);
            }
            catch (ServiceSpecificException e) {
                CameraManager.throwAsPublicException(e);
            }
            catch (RemoteException e) {
                ServiceSpecificException sse = new ServiceSpecificException(4, "Camera service is currently unavailable");
                CameraManager.throwAsPublicException(sse);
            }
        }
    }

    private static class CameraManagerGlobal
    extends ICameraServiceListener.Stub
    implements IBinder.DeathRecipient {
        private static final String TAG = "CameraManagerGlobal";
        private final boolean DEBUG = false;
        private final int CAMERA_SERVICE_RECONNECT_DELAY_MS = 1000;
        private static final CameraManagerGlobal gCameraManager = new CameraManagerGlobal();
        private static final String CAMERA_SERVICE_BINDER_NAME = "media.camera";
        private final ScheduledExecutorService mScheduler = Executors.newScheduledThreadPool(1);
        private final ArrayMap<String, Integer> mDeviceStatus = new ArrayMap();
        private final ArrayMap<String, ArrayList<String>> mUnavailablePhysicalDevices = new ArrayMap();
        private final Set<Set<String>> mConcurrentCameraIdCombinations = new ArraySet<Set<String>>();
        private final ArrayMap<AvailabilityCallback, Executor> mCallbackMap = new ArrayMap();
        private Binder mTorchClientBinder = new Binder();
        private final ArrayMap<String, Integer> mTorchStatus = new ArrayMap();
        private final ArrayMap<TorchCallback, Executor> mTorchCallbackMap = new ArrayMap();
        private final Object mLock = new Object();
        private ICameraService mCameraService;
        public static final boolean sCameraServiceDisabled = SystemProperties.getBoolean("config.disable_cameraservice", false);

        private CameraManagerGlobal() {
        }

        public static CameraManagerGlobal get() {
            return gCameraManager;
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ICameraService getCameraService() {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                if (this.mCameraService == null && !sCameraServiceDisabled) {
                    Log.e(TAG, "Camera service is unavailable");
                }
                return this.mCameraService;
            }
        }

        private void connectCameraServiceLocked() {
            if (this.mCameraService != null || sCameraServiceDisabled) {
                return;
            }
            Log.i(TAG, "Connecting to camera service");
            IBinder cameraServiceBinder = ServiceManager.getService(CAMERA_SERVICE_BINDER_NAME);
            if (cameraServiceBinder == null) {
                return;
            }
            try {
                cameraServiceBinder.linkToDeath(this, 0);
            }
            catch (RemoteException e) {
                return;
            }
            ICameraService cameraService = ICameraService.Stub.asInterface(cameraServiceBinder);
            try {
                CameraMetadataNative.setupGlobalVendorTagDescriptor();
            }
            catch (ServiceSpecificException e) {
                this.handleRecoverableSetupErrors(e);
            }
            try {
                CameraStatus[] cameraStatuses = cameraService.addListener(this);
                for (Parcelable parcelable : cameraStatuses) {
                    this.onStatusChangedLocked(((CameraStatus)parcelable).status, ((CameraStatus)parcelable).cameraId);
                    if (((CameraStatus)parcelable).unavailablePhysicalCameras == null) continue;
                    for (String unavailPhysicalCamera : ((CameraStatus)parcelable).unavailablePhysicalCameras) {
                        this.onPhysicalCameraStatusChangedLocked(0, ((CameraStatus)parcelable).cameraId, unavailPhysicalCamera);
                    }
                }
                this.mCameraService = cameraService;
            }
            catch (ServiceSpecificException e) {
                throw new IllegalStateException("Failed to register a camera service listener", e);
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                ConcurrentCameraIdCombination[] cameraIdCombinations = cameraService.getConcurrentCameraIds();
                for (Parcelable parcelable : cameraIdCombinations) {
                    this.mConcurrentCameraIdCombinations.add(((ConcurrentCameraIdCombination)parcelable).getConcurrentCameraIdCombination());
                }
            }
            catch (ServiceSpecificException e) {
                throw new IllegalStateException("Failed to get concurrent camera id combinations", e);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }

        private String[] extractCameraIdListLocked() {
            int status;
            int i;
            String[] cameraIds = null;
            int idCount = 0;
            for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                status = this.mDeviceStatus.valueAt(i);
                if (status == 0 || status == 2) continue;
                ++idCount;
            }
            cameraIds = new String[idCount];
            idCount = 0;
            for (i = 0; i < this.mDeviceStatus.size(); ++i) {
                status = this.mDeviceStatus.valueAt(i);
                if (status == 0 || status == 2) continue;
                cameraIds[idCount] = this.mDeviceStatus.keyAt(i);
                ++idCount;
            }
            return cameraIds;
        }

        private Set<Set<String>> extractConcurrentCameraIdListLocked() {
            ArraySet<Set<String>> concurrentCameraIds = new ArraySet<Set<String>>();
            for (Set<String> cameraIds : this.mConcurrentCameraIdCombinations) {
                ArraySet<String> extractedCameraIds = new ArraySet<String>();
                for (String cameraId : cameraIds) {
                    Integer status = this.mDeviceStatus.get(cameraId);
                    if (status == null || status == 2 || status == 0) continue;
                    extractedCameraIds.add(cameraId);
                }
                concurrentCameraIds.add(extractedCameraIds);
            }
            return concurrentCameraIds;
        }

        private static void sortCameraIds(String[] cameraIds) {
            Arrays.sort(cameraIds, new Comparator<String>(){

                @Override
                public int compare(String s1, String s2) {
                    int s1Int = 0;
                    int s2Int = 0;
                    try {
                        s1Int = Integer.parseInt(s1);
                    }
                    catch (NumberFormatException e) {
                        s1Int = -1;
                    }
                    try {
                        s2Int = Integer.parseInt(s2);
                    }
                    catch (NumberFormatException e) {
                        s2Int = -1;
                    }
                    if (s1Int >= 0 && s2Int >= 0) {
                        return s1Int - s2Int;
                    }
                    if (s1Int >= 0) {
                        return -1;
                    }
                    if (s2Int >= 0) {
                        return 1;
                    }
                    return s1.compareTo(s2);
                }
            });
        }

        public static boolean cameraStatusesContains(CameraStatus[] cameraStatuses, String id2) {
            for (CameraStatus c : cameraStatuses) {
                if (!c.cameraId.equals(id2)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getCameraIdListNoLazy() {
            if (sCameraServiceDisabled) {
                return new String[0];
            }
            ICameraServiceListener.Stub testListener = new ICameraServiceListener.Stub(){

                @Override
                public void onStatusChanged(int status, String id2) throws RemoteException {
                }

                @Override
                public void onPhysicalCameraStatusChanged(int status, String id2, String physicalId) throws RemoteException {
                }

                @Override
                public void onTorchStatusChanged(int status, String id2) throws RemoteException {
                }

                @Override
                public void onCameraAccessPrioritiesChanged() {
                }

                @Override
                public void onCameraOpened(String id2, String clientPackageId) {
                }

                @Override
                public void onCameraClosed(String id2) {
                }
            };
            String[] cameraIds = null;
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                try {
                    CameraStatus[] cameraStatuses = this.mCameraService.addListener(testListener);
                    this.mCameraService.removeListener(testListener);
                    for (CameraStatus c : cameraStatuses) {
                        this.onStatusChangedLocked(c.status, c.cameraId);
                    }
                    Set<String> deviceCameraIds = this.mDeviceStatus.keySet();
                    ArrayList<String> deviceIdsToRemove = new ArrayList<String>();
                    for (String deviceCameraId : deviceCameraIds) {
                        if (CameraManagerGlobal.cameraStatusesContains(cameraStatuses, deviceCameraId)) continue;
                        deviceIdsToRemove.add(deviceCameraId);
                    }
                    for (String id2 : deviceIdsToRemove) {
                        this.onStatusChangedLocked(0, id2);
                        this.mTorchStatus.remove(id2);
                    }
                }
                catch (ServiceSpecificException e) {
                    throw new IllegalStateException("Failed to register a camera service listener", e);
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                cameraIds = this.extractCameraIdListLocked();
            }
            CameraManagerGlobal.sortCameraIds(cameraIds);
            return cameraIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String[] getCameraIdList() {
            String[] cameraIds = null;
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                cameraIds = this.extractCameraIdListLocked();
            }
            CameraManagerGlobal.sortCameraIds(cameraIds);
            return cameraIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<Set<String>> getConcurrentCameraIds() {
            Set<Set<String>> concurrentStreamingCameraIds = null;
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                concurrentStreamingCameraIds = this.extractConcurrentCameraIdListLocked();
            }
            return concurrentStreamingCameraIds;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isConcurrentSessionConfigurationSupported(Map<String, SessionConfiguration> cameraIdsAndSessionConfigurations, int targetSdkVersion) throws CameraAccessException {
            if (cameraIdsAndSessionConfigurations == null) {
                throw new IllegalArgumentException("cameraIdsAndSessionConfigurations was null");
            }
            int size = cameraIdsAndSessionConfigurations.size();
            if (size == 0) {
                throw new IllegalArgumentException("camera id and session combination is empty");
            }
            Object object = this.mLock;
            synchronized (object) {
                boolean subsetFound = false;
                for (Set<String> combination : this.mConcurrentCameraIdCombinations) {
                    if (!combination.containsAll(cameraIdsAndSessionConfigurations.keySet())) continue;
                    subsetFound = true;
                }
                if (!subsetFound) {
                    Log.v(TAG, "isConcurrentSessionConfigurationSupported called with a subset ofcamera ids not returned by getConcurrentCameraIds");
                    return false;
                }
                CameraIdAndSessionConfiguration[] cameraIdsAndConfigs = new CameraIdAndSessionConfiguration[size];
                int i = 0;
                for (Map.Entry<String, SessionConfiguration> pair : cameraIdsAndSessionConfigurations.entrySet()) {
                    cameraIdsAndConfigs[i] = new CameraIdAndSessionConfiguration(pair.getKey(), pair.getValue());
                    ++i;
                }
                try {
                    return this.mCameraService.isConcurrentSessionConfigurationSupported(cameraIdsAndConfigs, targetSdkVersion);
                }
                catch (ServiceSpecificException e) {
                    CameraManager.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable", e);
                }
            }
            return false;
        }

        public boolean cameraIdHasConcurrentStreamsLocked(String cameraId) {
            if (!this.mDeviceStatus.containsKey(cameraId)) {
                return false;
            }
            for (Set<String> comb : this.mConcurrentCameraIdCombinations) {
                if (!comb.contains(cameraId)) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setTorchMode(String cameraId, boolean enabled) throws CameraAccessException {
            Object object = this.mLock;
            synchronized (object) {
                if (cameraId == null) {
                    throw new IllegalArgumentException("cameraId was null");
                }
                ICameraService cameraService = this.getCameraService();
                if (cameraService == null) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
                try {
                    cameraService.setTorchMode(cameraId, enabled, this.mTorchClientBinder);
                }
                catch (ServiceSpecificException e) {
                    CameraManager.throwAsPublicException(e);
                }
                catch (RemoteException e) {
                    throw new CameraAccessException(2, "Camera service is currently unavailable");
                }
            }
        }

        private void handleRecoverableSetupErrors(ServiceSpecificException e) {
            switch (e.errorCode) {
                case 4: {
                    Log.w(TAG, e.getMessage());
                    break;
                }
                default: {
                    throw new IllegalStateException(e);
                }
            }
        }

        private boolean isAvailable(int status) {
            switch (status) {
                case 1: {
                    return true;
                }
            }
            return false;
        }

        private boolean validStatus(int status) {
            switch (status) {
                case -2: 
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        private boolean validTorchStatus(int status) {
            switch (status) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleAccessPriorityChangeUpdate(final AvailabilityCallback callback, Executor executor) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraAccessPrioritiesChanged();
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleCameraOpenedUpdate(final AvailabilityCallback callback, Executor executor, final String id2, final String packageId) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraOpened(id2, packageId);
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleCameraClosedUpdate(final AvailabilityCallback callback, Executor executor, final String id2) {
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCameraClosed(id2);
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleUpdate(final AvailabilityCallback callback, Executor executor, final String id2, final String physicalId, int status) {
            if (this.isAvailable(status)) {
                long ident = Binder.clearCallingIdentity();
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            if (physicalId == null) {
                                callback.onCameraAvailable(id2);
                            } else {
                                callback.onPhysicalCameraAvailable(id2, physicalId);
                            }
                        }
                    });
                }
                finally {
                    Binder.restoreCallingIdentity(ident);
                }
            }
            long ident = Binder.clearCallingIdentity();
            try {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        if (physicalId == null) {
                            callback.onCameraUnavailable(id2);
                        } else {
                            callback.onPhysicalCameraUnavailable(id2, physicalId);
                        }
                    }
                });
            }
            finally {
                Binder.restoreCallingIdentity(ident);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void postSingleTorchUpdate(TorchCallback callback, Executor executor, String id2, int status) {
            switch (status) {
                case 1: 
                case 2: {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onTorchModeChanged(id2, status == 2));
                        break;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
                default: {
                    long ident = Binder.clearCallingIdentity();
                    try {
                        executor.execute(() -> callback.onTorchModeUnavailable(id2));
                        break;
                    }
                    finally {
                        Binder.restoreCallingIdentity(ident);
                    }
                }
            }
        }

        private void updateCallbackLocked(AvailabilityCallback callback, Executor executor) {
            for (int i = 0; i < this.mDeviceStatus.size(); ++i) {
                String id2 = this.mDeviceStatus.keyAt(i);
                Integer status = this.mDeviceStatus.valueAt(i);
                this.postSingleUpdate(callback, executor, id2, null, status);
                if (!this.isAvailable(status) || !this.mUnavailablePhysicalDevices.containsKey(id2)) continue;
                ArrayList<String> unavailableIds = this.mUnavailablePhysicalDevices.get(id2);
                for (String unavailableId : unavailableIds) {
                    this.postSingleUpdate(callback, executor, id2, unavailableId, 0);
                }
            }
        }

        private void onStatusChangedLocked(int status, String id2) {
            Integer oldStatus;
            if (!this.validStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s status 0x%x", id2, status));
                return;
            }
            if (status == 0) {
                oldStatus = this.mDeviceStatus.remove(id2);
                this.mUnavailablePhysicalDevices.remove(id2);
            } else {
                oldStatus = this.mDeviceStatus.put(id2, status);
                if (oldStatus == null) {
                    this.mUnavailablePhysicalDevices.put(id2, new ArrayList());
                }
            }
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            if (oldStatus != null && this.isAvailable(status) == this.isAvailable(oldStatus)) {
                return;
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Executor executor = this.mCallbackMap.valueAt(i);
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                this.postSingleUpdate(callback, executor, id2, null, status);
            }
        }

        private void onPhysicalCameraStatusChangedLocked(int status, String id2, String physicalId) {
            if (!this.validStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s physical device %s status 0x%x", id2, physicalId, status));
                return;
            }
            if (!(this.mDeviceStatus.containsKey(id2) && this.isAvailable(this.mDeviceStatus.get(id2)) && this.mUnavailablePhysicalDevices.containsKey(id2))) {
                Log.e(TAG, String.format("Camera %s is not available. Ignore physical camera status change", id2));
                return;
            }
            ArrayList<String> unavailablePhysicalDevices = this.mUnavailablePhysicalDevices.get(id2);
            if (!this.isAvailable(status) && !unavailablePhysicalDevices.contains(physicalId)) {
                unavailablePhysicalDevices.add(physicalId);
            } else if (this.isAvailable(status) && unavailablePhysicalDevices.contains(physicalId)) {
                unavailablePhysicalDevices.remove(physicalId);
            } else {
                return;
            }
            int callbackCount = this.mCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Executor executor = this.mCallbackMap.valueAt(i);
                AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                this.postSingleUpdate(callback, executor, id2, physicalId, status);
            }
        }

        private void updateTorchCallbackLocked(TorchCallback callback, Executor executor) {
            for (int i = 0; i < this.mTorchStatus.size(); ++i) {
                String id2 = this.mTorchStatus.keyAt(i);
                Integer status = this.mTorchStatus.valueAt(i);
                this.postSingleTorchUpdate(callback, executor, id2, status);
            }
        }

        private void onTorchStatusChangedLocked(int status, String id2) {
            if (!this.validTorchStatus(status)) {
                Log.e(TAG, String.format("Ignoring invalid device %s torch status 0x%x", id2, status));
                return;
            }
            Integer oldStatus = this.mTorchStatus.put(id2, status);
            if (oldStatus != null && oldStatus == status) {
                return;
            }
            int callbackCount = this.mTorchCallbackMap.size();
            for (int i = 0; i < callbackCount; ++i) {
                Executor executor = this.mTorchCallbackMap.valueAt(i);
                TorchCallback callback = this.mTorchCallbackMap.keyAt(i);
                this.postSingleTorchUpdate(callback, executor, id2, status);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerAvailabilityCallback(AvailabilityCallback callback, Executor executor) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                Executor oldExecutor = this.mCallbackMap.put(callback, executor);
                if (oldExecutor == null) {
                    this.updateCallbackLocked(callback, executor);
                }
                if (this.mCameraService == null) {
                    this.scheduleCameraServiceReconnectionLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterAvailabilityCallback(AvailabilityCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void registerTorchCallback(TorchCallback callback, Executor executor) {
            Object object = this.mLock;
            synchronized (object) {
                this.connectCameraServiceLocked();
                Executor oldExecutor = this.mTorchCallbackMap.put(callback, executor);
                if (oldExecutor == null) {
                    this.updateTorchCallbackLocked(callback, executor);
                }
                if (this.mCameraService == null) {
                    this.scheduleCameraServiceReconnectionLocked();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterTorchCallback(TorchCallback callback) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTorchCallbackMap.remove(callback);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onStatusChangedLocked(status, cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onPhysicalCameraStatusChanged(int status, String cameraId, String physicalCameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onPhysicalCameraStatusChangedLocked(status, cameraId, physicalCameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onTorchStatusChanged(int status, String cameraId) throws RemoteException {
            Object object = this.mLock;
            synchronized (object) {
                this.onTorchStatusChangedLocked(status, cameraId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraAccessPrioritiesChanged() {
            Object object = this.mLock;
            synchronized (object) {
                int callbackCount = this.mCallbackMap.size();
                for (int i = 0; i < callbackCount; ++i) {
                    Executor executor = this.mCallbackMap.valueAt(i);
                    AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                    this.postSingleAccessPriorityChangeUpdate(callback, executor);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpened(String cameraId, String clientPackageId) {
            Object object = this.mLock;
            synchronized (object) {
                int callbackCount = this.mCallbackMap.size();
                for (int i = 0; i < callbackCount; ++i) {
                    Executor executor = this.mCallbackMap.valueAt(i);
                    AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                    this.postSingleCameraOpenedUpdate(callback, executor, cameraId, clientPackageId);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraClosed(String cameraId) {
            Object object = this.mLock;
            synchronized (object) {
                int callbackCount = this.mCallbackMap.size();
                for (int i = 0; i < callbackCount; ++i) {
                    Executor executor = this.mCallbackMap.valueAt(i);
                    AvailabilityCallback callback = this.mCallbackMap.keyAt(i);
                    this.postSingleCameraClosedUpdate(callback, executor, cameraId);
                }
            }
        }

        private void scheduleCameraServiceReconnectionLocked() {
            if (this.mCallbackMap.isEmpty() && this.mTorchCallbackMap.isEmpty()) {
                return;
            }
            try {
                this.mScheduler.schedule(() -> {
                    ICameraService cameraService = this.getCameraService();
                    if (cameraService == null) {
                        Object object = this.mLock;
                        synchronized (object) {
                            this.scheduleCameraServiceReconnectionLocked();
                        }
                    }
                }, 1000L, TimeUnit.MILLISECONDS);
            }
            catch (RejectedExecutionException e) {
                Log.e(TAG, "Failed to schedule camera service re-connect: " + e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void binderDied() {
            Object object = this.mLock;
            synchronized (object) {
                String cameraId;
                int i;
                if (this.mCameraService == null) {
                    return;
                }
                this.mCameraService = null;
                for (i = this.mDeviceStatus.size() - 1; i >= 0; --i) {
                    cameraId = this.mDeviceStatus.keyAt(i);
                    this.onStatusChangedLocked(0, cameraId);
                }
                for (i = 0; i < this.mTorchStatus.size(); ++i) {
                    cameraId = this.mTorchStatus.keyAt(i);
                    this.onTorchStatusChangedLocked(0, cameraId);
                }
                this.mConcurrentCameraIdCombinations.clear();
                this.scheduleCameraServiceReconnectionLocked();
            }
        }
    }

    public static abstract class TorchCallback {
        public void onTorchModeUnavailable(String cameraId) {
        }

        public void onTorchModeChanged(String cameraId, boolean enabled) {
        }
    }

    public static abstract class AvailabilityCallback {
        public void onCameraAvailable(String cameraId) {
        }

        public void onCameraUnavailable(String cameraId) {
        }

        public void onCameraAccessPrioritiesChanged() {
        }

        public void onPhysicalCameraAvailable(String cameraId, String physicalCameraId) {
        }

        public void onPhysicalCameraUnavailable(String cameraId, String physicalCameraId) {
        }

        @SystemApi
        @RequiresPermission(value="android.permission.CAMERA_OPEN_CLOSE_LISTENER")
        public void onCameraOpened(String cameraId, String packageId) {
        }

        @SystemApi
        @RequiresPermission(value="android.permission.CAMERA_OPEN_CLOSE_LISTENER")
        public void onCameraClosed(String cameraId) {
        }
    }
}

