/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.camera2.extension;

import android.hardware.camera2.extension.CameraSessionConfig;
import android.hardware.camera2.extension.ICaptureCallback;
import android.hardware.camera2.extension.IRequestProcessorImpl;
import android.hardware.camera2.extension.OutputSurface;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ISessionProcessorImpl
extends IInterface {
    public static final String DESCRIPTOR = "android.hardware.camera2.extension.ISessionProcessorImpl";

    public CameraSessionConfig initSession(String var1, OutputSurface var2, OutputSurface var3) throws RemoteException;

    public void deInitSession() throws RemoteException;

    public void onCaptureSessionStart(IRequestProcessorImpl var1) throws RemoteException;

    public void onCaptureSessionEnd() throws RemoteException;

    public int startRepeating(ICaptureCallback var1) throws RemoteException;

    public void stopRepeating() throws RemoteException;

    public int startCapture(ICaptureCallback var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ISessionProcessorImpl {
        static final int TRANSACTION_initSession = 1;
        static final int TRANSACTION_deInitSession = 2;
        static final int TRANSACTION_onCaptureSessionStart = 3;
        static final int TRANSACTION_onCaptureSessionEnd = 4;
        static final int TRANSACTION_startRepeating = 5;
        static final int TRANSACTION_stopRepeating = 6;
        static final int TRANSACTION_startCapture = 7;

        public Stub() {
            this.attachInterface(this, ISessionProcessorImpl.DESCRIPTOR);
        }

        public static ISessionProcessorImpl asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ISessionProcessorImpl.DESCRIPTOR);
            if (iin != null && iin instanceof ISessionProcessorImpl) {
                return (ISessionProcessorImpl)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "initSession";
                }
                case 2: {
                    return "deInitSession";
                }
                case 3: {
                    return "onCaptureSessionStart";
                }
                case 4: {
                    return "onCaptureSessionEnd";
                }
                case 5: {
                    return "startRepeating";
                }
                case 6: {
                    return "stopRepeating";
                }
                case 7: {
                    return "startCapture";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ISessionProcessorImpl.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    OutputSurface _arg1 = 0 != data.readInt() ? OutputSurface.CREATOR.createFromParcel(data) : null;
                    OutputSurface _arg2 = 0 != data.readInt() ? OutputSurface.CREATOR.createFromParcel(data) : null;
                    CameraSessionConfig _result = this.initSession(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.deInitSession();
                    reply.writeNoException();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IRequestProcessorImpl _arg0 = IRequestProcessorImpl.Stub.asInterface(data.readStrongBinder());
                    this.onCaptureSessionStart(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    this.onCaptureSessionEnd();
                    reply.writeNoException();
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ICaptureCallback _arg0 = ICaptureCallback.Stub.asInterface(data.readStrongBinder());
                    int _result = this.startRepeating(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    this.stopRepeating();
                    reply.writeNoException();
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ICaptureCallback _arg0 = ICaptureCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    int _result = this.startCapture(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ISessionProcessorImpl impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ISessionProcessorImpl getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ISessionProcessorImpl {
            private IBinder mRemote;
            public static ISessionProcessorImpl sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ISessionProcessorImpl.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public CameraSessionConfig initSession(String cameraId, OutputSurface previewSurface, OutputSurface imageCaptureSurface) throws RemoteException {
                CameraSessionConfig _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeString(cameraId);
                    if (previewSurface != null) {
                        _data.writeInt(1);
                        previewSurface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (imageCaptureSurface != null) {
                        _data.writeInt(1);
                        imageCaptureSurface.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        CameraSessionConfig cameraSessionConfig = Stub.getDefaultImpl().initSession(cameraId, previewSurface, imageCaptureSurface);
                        return cameraSessionConfig;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? CameraSessionConfig.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void deInitSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().deInitSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSessionStart(IRequestProcessorImpl requestProcessor) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeStrongBinder(requestProcessor != null ? requestProcessor.asBinder() : null);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureSessionStart(requestProcessor);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onCaptureSessionEnd() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onCaptureSessionEnd();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startRepeating(ICaptureCallback callback) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().startRepeating(callback);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRepeating() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopRepeating();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startCapture(ICaptureCallback callback, int jpegRotation, int jpegQuality) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ISessionProcessorImpl.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(jpegRotation);
                    _data.writeInt(jpegQuality);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().startCapture(callback, jpegRotation, jpegQuality);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements ISessionProcessorImpl {
        @Override
        public CameraSessionConfig initSession(String cameraId, OutputSurface previewSurface, OutputSurface imageCaptureSurface) throws RemoteException {
            return null;
        }

        @Override
        public void deInitSession() throws RemoteException {
        }

        @Override
        public void onCaptureSessionStart(IRequestProcessorImpl requestProcessor) throws RemoteException {
        }

        @Override
        public void onCaptureSessionEnd() throws RemoteException {
        }

        @Override
        public int startRepeating(ICaptureCallback callback) throws RemoteException {
            return 0;
        }

        @Override
        public void stopRepeating() throws RemoteException {
        }

        @Override
        public int startCapture(ICaptureCallback callback, int jpegRotation, int jpegQuality) throws RemoteException {
            return 0;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

