/*
 * Decompiled with CFR 0.152.
 */
package android.hardware.lights;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.lights.ILightsManager;
import android.hardware.lights.Light;
import android.hardware.lights.LightState;
import android.hardware.lights.LightsManager;
import android.hardware.lights.LightsRequest;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.CloseGuard;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import java.lang.ref.Reference;
import java.util.List;

public class SystemLightsManager
extends LightsManager {
    private static final String TAG = "LightsManager";
    private final ILightsManager mService;

    public SystemLightsManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this(context, ILightsManager.Stub.asInterface(ServiceManager.getServiceOrThrow("lights")));
    }

    @VisibleForTesting
    public SystemLightsManager(Context context, ILightsManager service) {
        super(context);
        this.mService = Preconditions.checkNotNull(service);
    }

    @Override
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public List<Light> getLights() {
        try {
            return this.mService.getLights();
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public LightState getLightState(Light light) {
        Preconditions.checkNotNull(light);
        try {
            return this.mService.getLightState(light.getId());
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public LightsManager.LightsSession openSession() {
        try {
            SystemLightsSession session = new SystemLightsSession();
            this.mService.openSession(session.getToken(), 0);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
    public LightsManager.LightsSession openSession(int priority) {
        try {
            SystemLightsSession session = new SystemLightsSession();
            this.mService.openSession(session.getToken(), priority);
            return session;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public class SystemLightsSession
    extends LightsManager.LightsSession
    implements AutoCloseable {
        private final CloseGuard mCloseGuard = new CloseGuard();
        private boolean mClosed = false;

        @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
        private SystemLightsSession() {
            this.mCloseGuard.open("close");
        }

        @Override
        @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
        public void requestLights(LightsRequest request) {
            Preconditions.checkNotNull(request);
            if (!this.mClosed) {
                try {
                    List<Integer> idList = request.getLights();
                    List<LightState> stateList = request.getLightStates();
                    int[] ids = new int[idList.size()];
                    for (int i = 0; i < idList.size(); ++i) {
                        ids[i] = idList.get(i);
                    }
                    LightState[] states = new LightState[stateList.size()];
                    for (int i = 0; i < stateList.size(); ++i) {
                        states[i] = stateList.get(i);
                    }
                    SystemLightsManager.this.mService.setLightStates(this.getToken(), ids, states);
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
        }

        @Override
        @RequiresPermission(value="android.permission.CONTROL_DEVICE_LIGHTS")
        public void close() {
            if (!this.mClosed) {
                try {
                    SystemLightsManager.this.mService.closeSession(this.getToken());
                    this.mClosed = true;
                    this.mCloseGuard.close();
                }
                catch (RemoteException e) {
                    throw e.rethrowFromSystemServer();
                }
            }
            Reference.reachabilityFence(this);
        }

        protected void finalize() throws Throwable {
            try {
                this.mCloseGuard.warnIfOpen();
                this.close();
            }
            finally {
                super.finalize();
            }
        }
    }
}

