/*
 * Decompiled with CFR 0.152.
 */
package android.icu.impl.number;

import android.icu.impl.number.DecimalQuantity;
import android.icu.impl.number.MicroProps;
import android.icu.impl.number.MicroPropsGenerator;
import android.icu.impl.units.MeasureUnitImpl;
import android.icu.impl.units.UnitsRouter;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.icu.util.ULocale;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class UsagePrefsHandler
implements MicroPropsGenerator {
    private final MicroPropsGenerator fParent;
    private UnitsRouter fUnitsRouter;

    public UsagePrefsHandler(ULocale locale, MeasureUnit inputUnit, String usage, MicroPropsGenerator parent) {
        assert (parent != null);
        this.fParent = parent;
        this.fUnitsRouter = new UnitsRouter(MeasureUnitImpl.forIdentifier(inputUnit.getIdentifier()), locale.getCountry(), usage);
    }

    protected static void mixedMeasuresToMicros(List<Measure> measures, DecimalQuantity outQuantity, MicroProps outMicros) {
        outMicros.mixedMeasures = new ArrayList<Measure>();
        if (measures.size() > 1) {
            assert (outMicros.outputUnit.getComplexity() == MeasureUnit.Complexity.MIXED);
            assert (measures.size() == outMicros.outputUnit.splitToSingleUnits().size());
            int n = measures.size() - 1;
            for (int i = 0; i < n; ++i) {
                outMicros.mixedMeasures.add(measures.get(i));
            }
        }
        outQuantity.setToBigDecimal((BigDecimal)measures.get(measures.size() - 1).getNumber());
    }

    public List<MeasureUnit> getOutputUnits() {
        return this.fUnitsRouter.getOutputUnits();
    }

    @Override
    public MicroProps processQuantity(DecimalQuantity quantity) {
        MicroProps micros = this.fParent.processQuantity(quantity);
        quantity.roundToInfinity();
        UnitsRouter.RouteResult routed = this.fUnitsRouter.route(quantity.toBigDecimal(), micros);
        List<Measure> routedMeasures = routed.measures;
        micros.outputUnit = routed.outputUnit.build();
        UsagePrefsHandler.mixedMeasuresToMicros(routedMeasures, quantity, micros);
        return micros;
    }
}

