/*
 * Decompiled with CFR 0.152.
 */
package android.media;

import android.media.AudioPlaybackConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import java.util.ArrayList;
import java.util.List;

public interface IPlaybackConfigDispatcher
extends IInterface {
    public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> var1, boolean var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IPlaybackConfigDispatcher {
        public static final String DESCRIPTOR = "android.media.IPlaybackConfigDispatcher";
        static final int TRANSACTION_dispatchPlaybackConfigChange = 1;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IPlaybackConfigDispatcher asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IPlaybackConfigDispatcher) {
                return (IPlaybackConfigDispatcher)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "dispatchPlaybackConfigChange";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    ArrayList<AudioPlaybackConfiguration> _arg0 = data.createTypedArrayList(AudioPlaybackConfiguration.CREATOR);
                    boolean _arg1 = 0 != data.readInt();
                    this.dispatchPlaybackConfigChange(_arg0, _arg1);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IPlaybackConfigDispatcher impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IPlaybackConfigDispatcher getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IPlaybackConfigDispatcher {
            private IBinder mRemote;
            public static IPlaybackConfigDispatcher sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs, boolean flush) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(configs);
                    _data.writeInt(flush ? 1 : 0);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().dispatchPlaybackConfigChange(configs, flush);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements IPlaybackConfigDispatcher {
        @Override
        public void dispatchPlaybackConfigChange(List<AudioPlaybackConfiguration> configs, boolean flush) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

