/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.INetworkAgentRegistry;
import android.net.NattKeepalivePacketData;
import android.net.QosFilterParcelable;
import android.net.TcpKeepalivePacketData;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface INetworkAgent
extends IInterface {
    public static final String DESCRIPTOR = "android.net.INetworkAgent";

    public void onRegistered(INetworkAgentRegistry var1) throws RemoteException;

    public void onDisconnected() throws RemoteException;

    public void onBandwidthUpdateRequested() throws RemoteException;

    public void onValidationStatusChanged(int var1, String var2) throws RemoteException;

    public void onSaveAcceptUnvalidated(boolean var1) throws RemoteException;

    public void onStartNattSocketKeepalive(int var1, int var2, NattKeepalivePacketData var3) throws RemoteException;

    public void onStartTcpSocketKeepalive(int var1, int var2, TcpKeepalivePacketData var3) throws RemoteException;

    public void onStopSocketKeepalive(int var1) throws RemoteException;

    public void onSignalStrengthThresholdsUpdated(int[] var1) throws RemoteException;

    public void onPreventAutomaticReconnect() throws RemoteException;

    public void onAddNattKeepalivePacketFilter(int var1, NattKeepalivePacketData var2) throws RemoteException;

    public void onAddTcpKeepalivePacketFilter(int var1, TcpKeepalivePacketData var2) throws RemoteException;

    public void onRemoveKeepalivePacketFilter(int var1) throws RemoteException;

    public void onQosFilterCallbackRegistered(int var1, QosFilterParcelable var2) throws RemoteException;

    public void onQosCallbackUnregistered(int var1) throws RemoteException;

    public void onNetworkCreated() throws RemoteException;

    public void onNetworkDestroyed() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INetworkAgent {
        static final int TRANSACTION_onRegistered = 1;
        static final int TRANSACTION_onDisconnected = 2;
        static final int TRANSACTION_onBandwidthUpdateRequested = 3;
        static final int TRANSACTION_onValidationStatusChanged = 4;
        static final int TRANSACTION_onSaveAcceptUnvalidated = 5;
        static final int TRANSACTION_onStartNattSocketKeepalive = 6;
        static final int TRANSACTION_onStartTcpSocketKeepalive = 7;
        static final int TRANSACTION_onStopSocketKeepalive = 8;
        static final int TRANSACTION_onSignalStrengthThresholdsUpdated = 9;
        static final int TRANSACTION_onPreventAutomaticReconnect = 10;
        static final int TRANSACTION_onAddNattKeepalivePacketFilter = 11;
        static final int TRANSACTION_onAddTcpKeepalivePacketFilter = 12;
        static final int TRANSACTION_onRemoveKeepalivePacketFilter = 13;
        static final int TRANSACTION_onQosFilterCallbackRegistered = 14;
        static final int TRANSACTION_onQosCallbackUnregistered = 15;
        static final int TRANSACTION_onNetworkCreated = 16;
        static final int TRANSACTION_onNetworkDestroyed = 17;

        public Stub() {
            this.attachInterface(this, INetworkAgent.DESCRIPTOR);
        }

        public static INetworkAgent asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(INetworkAgent.DESCRIPTOR);
            if (iin != null && iin instanceof INetworkAgent) {
                return (INetworkAgent)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = INetworkAgent.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    INetworkAgentRegistry _arg0 = INetworkAgentRegistry.Stub.asInterface(data.readStrongBinder());
                    this.onRegistered(_arg0);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onDisconnected();
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    this.onBandwidthUpdateRequested();
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.onValidationStatusChanged(_arg0, _arg1);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.onSaveAcceptUnvalidated(_arg0);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    NattKeepalivePacketData _arg2 = 0 != data.readInt() ? NattKeepalivePacketData.CREATOR.createFromParcel(data) : null;
                    this.onStartNattSocketKeepalive(_arg0, _arg1, _arg2);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    TcpKeepalivePacketData _arg2 = 0 != data.readInt() ? TcpKeepalivePacketData.CREATOR.createFromParcel(data) : null;
                    this.onStartTcpSocketKeepalive(_arg0, _arg1, _arg2);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onStopSocketKeepalive(_arg0);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    int[] _arg0 = data.createIntArray();
                    this.onSignalStrengthThresholdsUpdated(_arg0);
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    this.onPreventAutomaticReconnect();
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    NattKeepalivePacketData _arg1 = 0 != data.readInt() ? NattKeepalivePacketData.CREATOR.createFromParcel(data) : null;
                    this.onAddNattKeepalivePacketFilter(_arg0, _arg1);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    TcpKeepalivePacketData _arg1 = 0 != data.readInt() ? TcpKeepalivePacketData.CREATOR.createFromParcel(data) : null;
                    this.onAddTcpKeepalivePacketFilter(_arg0, _arg1);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onRemoveKeepalivePacketFilter(_arg0);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    QosFilterParcelable _arg1 = 0 != data.readInt() ? QosFilterParcelable.CREATOR.createFromParcel(data) : null;
                    this.onQosFilterCallbackRegistered(_arg0, _arg1);
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.onQosCallbackUnregistered(_arg0);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    this.onNetworkCreated();
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    this.onNetworkDestroyed();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(INetworkAgent impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static INetworkAgent getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements INetworkAgent {
            private IBinder mRemote;
            public static INetworkAgent sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return INetworkAgent.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRegistered(INetworkAgentRegistry registry) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeStrongBinder(registry != null ? registry.asBinder() : null);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRegistered(registry);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onDisconnected() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onDisconnected();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onBandwidthUpdateRequested() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onBandwidthUpdateRequested();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onValidationStatusChanged(int validationStatus, String captivePortalUrl) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(validationStatus);
                    _data.writeString(captivePortalUrl);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onValidationStatusChanged(validationStatus, captivePortalUrl);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSaveAcceptUnvalidated(boolean acceptUnvalidated) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(acceptUnvalidated ? 1 : 0);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSaveAcceptUnvalidated(acceptUnvalidated);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartNattSocketKeepalive(int slot, int intervalDurationMs, NattKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeInt(intervalDurationMs);
                    if (packetData != null) {
                        _data.writeInt(1);
                        packetData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartNattSocketKeepalive(slot, intervalDurationMs, packetData);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStartTcpSocketKeepalive(int slot, int intervalDurationMs, TcpKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    _data.writeInt(intervalDurationMs);
                    if (packetData != null) {
                        _data.writeInt(1);
                        packetData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStartTcpSocketKeepalive(slot, intervalDurationMs, packetData);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onStopSocketKeepalive(int slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onStopSocketKeepalive(slot);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSignalStrengthThresholdsUpdated(int[] thresholds) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeIntArray(thresholds);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSignalStrengthThresholdsUpdated(thresholds);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onPreventAutomaticReconnect() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(10, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onPreventAutomaticReconnect();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddNattKeepalivePacketFilter(int slot, NattKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    if (packetData != null) {
                        _data.writeInt(1);
                        packetData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(11, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAddNattKeepalivePacketFilter(slot, packetData);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onAddTcpKeepalivePacketFilter(int slot, TcpKeepalivePacketData packetData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    if (packetData != null) {
                        _data.writeInt(1);
                        packetData.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(12, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onAddTcpKeepalivePacketFilter(slot, packetData);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onRemoveKeepalivePacketFilter(int slot) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(slot);
                    boolean _status = this.mRemote.transact(13, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onRemoveKeepalivePacketFilter(slot);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQosFilterCallbackRegistered(int qosCallbackId, QosFilterParcelable filterParcel) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    if (filterParcel != null) {
                        _data.writeInt(1);
                        filterParcel.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(14, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQosFilterCallbackRegistered(qosCallbackId, filterParcel);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onQosCallbackUnregistered(int qosCallbackId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    _data.writeInt(qosCallbackId);
                    boolean _status = this.mRemote.transact(15, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onQosCallbackUnregistered(qosCallbackId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNetworkCreated() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(16, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNetworkCreated();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onNetworkDestroyed() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(INetworkAgent.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(17, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onNetworkDestroyed();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements INetworkAgent {
        @Override
        public void onRegistered(INetworkAgentRegistry registry) throws RemoteException {
        }

        @Override
        public void onDisconnected() throws RemoteException {
        }

        @Override
        public void onBandwidthUpdateRequested() throws RemoteException {
        }

        @Override
        public void onValidationStatusChanged(int validationStatus, String captivePortalUrl) throws RemoteException {
        }

        @Override
        public void onSaveAcceptUnvalidated(boolean acceptUnvalidated) throws RemoteException {
        }

        @Override
        public void onStartNattSocketKeepalive(int slot, int intervalDurationMs, NattKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onStartTcpSocketKeepalive(int slot, int intervalDurationMs, TcpKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onStopSocketKeepalive(int slot) throws RemoteException {
        }

        @Override
        public void onSignalStrengthThresholdsUpdated(int[] thresholds) throws RemoteException {
        }

        @Override
        public void onPreventAutomaticReconnect() throws RemoteException {
        }

        @Override
        public void onAddNattKeepalivePacketFilter(int slot, NattKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onAddTcpKeepalivePacketFilter(int slot, TcpKeepalivePacketData packetData) throws RemoteException {
        }

        @Override
        public void onRemoveKeepalivePacketFilter(int slot) throws RemoteException {
        }

        @Override
        public void onQosFilterCallbackRegistered(int qosCallbackId, QosFilterParcelable filterParcel) throws RemoteException {
        }

        @Override
        public void onQosCallbackUnregistered(int qosCallbackId) throws RemoteException {
        }

        @Override
        public void onNetworkCreated() throws RemoteException {
        }

        @Override
        public void onNetworkDestroyed() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

