/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.IpSecAlgorithm;
import android.net.PlatformVpnProfile;
import android.net.ProxyInfo;
import android.security.Credentials;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.net.VpnProfile;
import com.android.internal.util.Preconditions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class Ikev2VpnProfile
extends PlatformVpnProfile {
    public static final String PREFIX_KEYSTORE_ALIAS = "KEYSTORE_ALIAS:";
    public static final String PREFIX_INLINE = "INLINE:";
    private static final String ANDROID_KEYSTORE_PROVIDER = "AndroidKeyStore";
    private static final String MISSING_PARAM_MSG_TMPL = "Required parameter was not provided: %s";
    private static final String EMPTY_CERT = "";
    public static final List<String> DEFAULT_ALGORITHMS;
    private final String mServerAddr;
    private final String mUserIdentity;
    private final byte[] mPresharedKey;
    private final X509Certificate mServerRootCaCert;
    private final String mUsername;
    private final String mPassword;
    private final PrivateKey mRsaPrivateKey;
    private final X509Certificate mUserCert;
    private final ProxyInfo mProxyInfo;
    private final List<String> mAllowedAlgorithms;
    private final boolean mIsBypassable;
    private final boolean mIsMetered;
    private final int mMaxMtu;
    private final boolean mIsRestrictedToTestNetworks;

    private static void addAlgorithmIfSupported(List<String> algorithms, String ipSecAlgoName) {
        if (IpSecAlgorithm.getSupportedAlgorithms().contains(ipSecAlgoName)) {
            algorithms.add(ipSecAlgoName);
        }
    }

    private Ikev2VpnProfile(int type, String serverAddr, String userIdentity, byte[] presharedKey, X509Certificate serverRootCaCert, String username, String password, PrivateKey rsaPrivateKey, X509Certificate userCert, ProxyInfo proxyInfo, List<String> allowedAlgorithms, boolean isBypassable, boolean isMetered, int maxMtu, boolean restrictToTestNetworks) {
        super(type);
        Ikev2VpnProfile.checkNotNull(serverAddr, MISSING_PARAM_MSG_TMPL, "Server address");
        Ikev2VpnProfile.checkNotNull(userIdentity, MISSING_PARAM_MSG_TMPL, "User Identity");
        Ikev2VpnProfile.checkNotNull(allowedAlgorithms, MISSING_PARAM_MSG_TMPL, "Allowed Algorithms");
        this.mServerAddr = serverAddr;
        this.mUserIdentity = userIdentity;
        this.mPresharedKey = presharedKey == null ? null : Arrays.copyOf(presharedKey, presharedKey.length);
        this.mServerRootCaCert = serverRootCaCert;
        this.mUsername = username;
        this.mPassword = password;
        this.mRsaPrivateKey = rsaPrivateKey;
        this.mUserCert = userCert;
        this.mProxyInfo = new ProxyInfo(proxyInfo);
        this.mAllowedAlgorithms = Collections.unmodifiableList(new ArrayList<String>(allowedAlgorithms));
        this.mIsBypassable = isBypassable;
        this.mIsMetered = isMetered;
        this.mMaxMtu = maxMtu;
        this.mIsRestrictedToTestNetworks = restrictToTestNetworks;
        this.validate();
    }

    private void validate() {
        Preconditions.checkStringNotEmpty(this.mServerAddr, MISSING_PARAM_MSG_TMPL, "Server Address");
        Preconditions.checkStringNotEmpty(this.mUserIdentity, MISSING_PARAM_MSG_TMPL, "User Identity");
        if (this.mMaxMtu < 1280) {
            throw new IllegalArgumentException("Max MTU must be at least1280");
        }
        switch (this.mType) {
            case 6: {
                Ikev2VpnProfile.checkNotNull(this.mUsername, MISSING_PARAM_MSG_TMPL, "Username");
                Ikev2VpnProfile.checkNotNull(this.mPassword, MISSING_PARAM_MSG_TMPL, "Password");
                if (this.mServerRootCaCert == null) break;
                Ikev2VpnProfile.checkCert(this.mServerRootCaCert);
                break;
            }
            case 7: {
                Ikev2VpnProfile.checkNotNull(this.mPresharedKey, MISSING_PARAM_MSG_TMPL, "Preshared Key");
                break;
            }
            case 8: {
                Ikev2VpnProfile.checkNotNull(this.mUserCert, MISSING_PARAM_MSG_TMPL, "User cert");
                Ikev2VpnProfile.checkNotNull(this.mRsaPrivateKey, MISSING_PARAM_MSG_TMPL, "RSA Private key");
                Ikev2VpnProfile.checkCert(this.mUserCert);
                if (this.mServerRootCaCert == null) break;
                Ikev2VpnProfile.checkCert(this.mServerRootCaCert);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid auth method set");
            }
        }
        Ikev2VpnProfile.validateAllowedAlgorithms(this.mAllowedAlgorithms);
    }

    private static void validateAllowedAlgorithms(List<String> algorithmNames) {
        if (algorithmNames.contains("hmac(md5)") || algorithmNames.contains("hmac(sha1)")) {
            throw new IllegalArgumentException("Algorithm not supported for IKEv2 VPN profiles");
        }
        if (Ikev2VpnProfile.hasAeadAlgorithms(algorithmNames) || Ikev2VpnProfile.hasNormalModeAlgorithms(algorithmNames)) {
            return;
        }
        throw new IllegalArgumentException("Algorithm set missing support for Auth, Crypt or both");
    }

    public static boolean hasAeadAlgorithms(List<String> algorithmNames) {
        return algorithmNames.contains("rfc4106(gcm(aes))");
    }

    public static boolean hasNormalModeAlgorithms(List<String> algorithmNames) {
        boolean hasCrypt = algorithmNames.contains("cbc(aes)");
        boolean hasAuth = algorithmNames.contains("hmac(sha256)") || algorithmNames.contains("hmac(sha384)") || algorithmNames.contains("hmac(sha512)");
        return hasCrypt && hasAuth;
    }

    public String getServerAddr() {
        return this.mServerAddr;
    }

    public String getUserIdentity() {
        return this.mUserIdentity;
    }

    public byte[] getPresharedKey() {
        return this.mPresharedKey == null ? null : Arrays.copyOf(this.mPresharedKey, this.mPresharedKey.length);
    }

    public X509Certificate getServerRootCaCert() {
        return this.mServerRootCaCert;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    public PrivateKey getRsaPrivateKey() {
        return this.mRsaPrivateKey;
    }

    public X509Certificate getUserCert() {
        return this.mUserCert;
    }

    public ProxyInfo getProxyInfo() {
        return this.mProxyInfo;
    }

    public List<String> getAllowedAlgorithms() {
        return this.mAllowedAlgorithms;
    }

    public boolean isBypassable() {
        return this.mIsBypassable;
    }

    public boolean isMetered() {
        return this.mIsMetered;
    }

    public int getMaxMtu() {
        return this.mMaxMtu;
    }

    public boolean isRestrictedToTestNetworks() {
        return this.mIsRestrictedToTestNetworks;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mServerAddr, this.mUserIdentity, Arrays.hashCode(this.mPresharedKey), this.mServerRootCaCert, this.mUsername, this.mPassword, this.mRsaPrivateKey, this.mUserCert, this.mProxyInfo, this.mAllowedAlgorithms, this.mIsBypassable, this.mIsMetered, this.mMaxMtu, this.mIsRestrictedToTestNetworks);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Ikev2VpnProfile)) {
            return false;
        }
        Ikev2VpnProfile other = (Ikev2VpnProfile)obj;
        return this.mType == other.mType && Objects.equals(this.mServerAddr, other.mServerAddr) && Objects.equals(this.mUserIdentity, other.mUserIdentity) && Arrays.equals(this.mPresharedKey, other.mPresharedKey) && Objects.equals(this.mServerRootCaCert, other.mServerRootCaCert) && Objects.equals(this.mUsername, other.mUsername) && Objects.equals(this.mPassword, other.mPassword) && Objects.equals(this.mRsaPrivateKey, other.mRsaPrivateKey) && Objects.equals(this.mUserCert, other.mUserCert) && Objects.equals(this.mProxyInfo, other.mProxyInfo) && Objects.equals(this.mAllowedAlgorithms, other.mAllowedAlgorithms) && this.mIsBypassable == other.mIsBypassable && this.mIsMetered == other.mIsMetered && this.mMaxMtu == other.mMaxMtu && this.mIsRestrictedToTestNetworks == other.mIsRestrictedToTestNetworks;
    }

    @Override
    public VpnProfile toVpnProfile() throws IOException, GeneralSecurityException {
        VpnProfile profile = new VpnProfile(EMPTY_CERT, this.mIsRestrictedToTestNetworks);
        profile.type = this.mType;
        profile.server = this.mServerAddr;
        profile.ipsecIdentifier = this.mUserIdentity;
        profile.proxy = this.mProxyInfo;
        profile.setAllowedAlgorithms(this.mAllowedAlgorithms);
        profile.isBypassable = this.mIsBypassable;
        profile.isMetered = this.mIsMetered;
        profile.maxMtu = this.mMaxMtu;
        profile.areAuthParamsInline = true;
        profile.saveLogin = true;
        switch (this.mType) {
            case 6: {
                profile.username = this.mUsername;
                profile.password = this.mPassword;
                profile.ipsecCaCert = this.mServerRootCaCert == null ? EMPTY_CERT : Ikev2VpnProfile.certificateToPemString(this.mServerRootCaCert);
                break;
            }
            case 7: {
                profile.ipsecSecret = Ikev2VpnProfile.encodeForIpsecSecret(this.mPresharedKey);
                break;
            }
            case 8: {
                profile.ipsecUserCert = Ikev2VpnProfile.certificateToPemString(this.mUserCert);
                profile.ipsecSecret = PREFIX_INLINE + Ikev2VpnProfile.encodeForIpsecSecret(this.mRsaPrivateKey.getEncoded());
                profile.ipsecCaCert = this.mServerRootCaCert == null ? EMPTY_CERT : Ikev2VpnProfile.certificateToPemString(this.mServerRootCaCert);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid auth method set");
            }
        }
        return profile;
    }

    private static PrivateKey getPrivateKeyFromAndroidKeystore(String alias) {
        try {
            KeyStore keystore = KeyStore.getInstance(ANDROID_KEYSTORE_PROVIDER);
            keystore.load(null);
            Key key = keystore.getKey(alias, null);
            if (!(key instanceof PrivateKey)) {
                throw new IllegalStateException("Unexpected key type returned from android keystore.");
            }
            return (PrivateKey)key;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to load key from android keystore.", e);
        }
    }

    public static Ikev2VpnProfile fromVpnProfile(VpnProfile profile) throws GeneralSecurityException {
        Builder builder = new Builder(profile.server, profile.ipsecIdentifier);
        builder.setProxy(profile.proxy);
        builder.setAllowedAlgorithms(profile.getAllowedAlgorithms());
        builder.setBypassable(profile.isBypassable);
        builder.setMetered(profile.isMetered);
        builder.setMaxMtu(profile.maxMtu);
        if (profile.isRestrictedToTestNetworks) {
            builder.restrictToTestNetworks();
        }
        switch (profile.type) {
            case 6: {
                builder.setAuthUsernamePassword(profile.username, profile.password, Ikev2VpnProfile.certificateFromPemString(profile.ipsecCaCert));
                break;
            }
            case 7: {
                builder.setAuthPsk(Ikev2VpnProfile.decodeFromIpsecSecret(profile.ipsecSecret));
                break;
            }
            case 8: {
                PrivateKey key;
                if (profile.ipsecSecret.startsWith(PREFIX_KEYSTORE_ALIAS)) {
                    String alias = profile.ipsecSecret.substring(PREFIX_KEYSTORE_ALIAS.length());
                    key = Ikev2VpnProfile.getPrivateKeyFromAndroidKeystore(alias);
                } else if (profile.ipsecSecret.startsWith(PREFIX_INLINE)) {
                    key = Ikev2VpnProfile.getPrivateKey(profile.ipsecSecret.substring(PREFIX_INLINE.length()));
                } else {
                    throw new IllegalArgumentException("Invalid RSA private key prefix");
                }
                X509Certificate userCert = Ikev2VpnProfile.certificateFromPemString(profile.ipsecUserCert);
                X509Certificate serverRootCa = Ikev2VpnProfile.certificateFromPemString(profile.ipsecCaCert);
                builder.setAuthDigitalSignature(userCert, key, serverRootCa);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid auth method set");
            }
        }
        return builder.build();
    }

    public static boolean isValidVpnProfile(VpnProfile profile) {
        if (profile.server.isEmpty() || profile.ipsecIdentifier.isEmpty()) {
            return false;
        }
        switch (profile.type) {
            case 6: {
                if (!profile.username.isEmpty() && !profile.password.isEmpty()) break;
                return false;
            }
            case 7: {
                if (!profile.ipsecSecret.isEmpty()) break;
                return false;
            }
            case 8: {
                if (!profile.ipsecSecret.isEmpty() && !profile.ipsecUserCert.isEmpty()) break;
                return false;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @VisibleForTesting(visibility=VisibleForTesting.Visibility.PRIVATE)
    public static String certificateToPemString(X509Certificate cert) throws IOException, CertificateEncodingException {
        if (cert == null) {
            return EMPTY_CERT;
        }
        return new String(Credentials.convertToPem(cert), StandardCharsets.US_ASCII);
    }

    private static X509Certificate certificateFromPemString(String certStr) throws CertificateException {
        if (certStr == null || EMPTY_CERT.equals(certStr)) {
            return null;
        }
        try {
            List<X509Certificate> certs = Credentials.convertFromPem(certStr.getBytes(StandardCharsets.US_ASCII));
            return certs.isEmpty() ? null : certs.get(0);
        }
        catch (IOException e) {
            throw new CertificateException(e);
        }
    }

    public static String encodeForIpsecSecret(byte[] secret) {
        Ikev2VpnProfile.checkNotNull(secret, MISSING_PARAM_MSG_TMPL, "secret");
        return Base64.getEncoder().encodeToString(secret);
    }

    private static byte[] decodeFromIpsecSecret(String encoded) {
        Ikev2VpnProfile.checkNotNull(encoded, MISSING_PARAM_MSG_TMPL, "encoded");
        return Base64.getDecoder().decode(encoded);
    }

    private static PrivateKey getPrivateKey(String keyStr) throws InvalidKeySpecException, NoSuchAlgorithmException {
        PKCS8EncodedKeySpec privateKeySpec = new PKCS8EncodedKeySpec(Ikev2VpnProfile.decodeFromIpsecSecret(keyStr));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        return keyFactory.generatePrivate(privateKeySpec);
    }

    private static void checkCert(X509Certificate cert) {
        try {
            Ikev2VpnProfile.certificateToPemString(cert);
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Certificate could not be encoded");
        }
    }

    private static <T> T checkNotNull(T reference, String messageTemplate, Object ... messageArgs) {
        return Objects.requireNonNull(reference, String.format(messageTemplate, messageArgs));
    }

    static {
        ArrayList<String> algorithms = new ArrayList<String>();
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "cbc(aes)");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "rfc3686(ctr(aes))");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "hmac(sha256)");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "hmac(sha384)");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "hmac(sha512)");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "xcbc(aes)");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "cmac(aes)");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "rfc4106(gcm(aes))");
        Ikev2VpnProfile.addAlgorithmIfSupported(algorithms, "rfc7539esp(chacha20,poly1305)");
        DEFAULT_ALGORITHMS = Collections.unmodifiableList(algorithms);
    }

    public static class Builder {
        private int mType = -1;
        private final String mServerAddr;
        private final String mUserIdentity;
        private byte[] mPresharedKey;
        private X509Certificate mServerRootCaCert;
        private String mUsername;
        private String mPassword;
        private PrivateKey mRsaPrivateKey;
        private X509Certificate mUserCert;
        private ProxyInfo mProxyInfo;
        private List<String> mAllowedAlgorithms = DEFAULT_ALGORITHMS;
        private boolean mIsBypassable = false;
        private boolean mIsMetered = true;
        private int mMaxMtu = 1360;
        private boolean mIsRestrictedToTestNetworks = false;

        public Builder(String serverAddr, String identity) {
            Ikev2VpnProfile.checkNotNull(serverAddr, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"serverAddr"});
            Ikev2VpnProfile.checkNotNull(identity, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"identity"});
            this.mServerAddr = serverAddr;
            this.mUserIdentity = identity;
        }

        private void resetAuthParams() {
            this.mPresharedKey = null;
            this.mServerRootCaCert = null;
            this.mUsername = null;
            this.mPassword = null;
            this.mRsaPrivateKey = null;
            this.mUserCert = null;
        }

        public Builder setAuthUsernamePassword(String user, String pass, X509Certificate serverRootCa) {
            Ikev2VpnProfile.checkNotNull(user, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"user"});
            Ikev2VpnProfile.checkNotNull(pass, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"pass"});
            if (serverRootCa != null) {
                Ikev2VpnProfile.checkCert(serverRootCa);
            }
            this.resetAuthParams();
            this.mUsername = user;
            this.mPassword = pass;
            this.mServerRootCaCert = serverRootCa;
            this.mType = 6;
            return this;
        }

        public Builder setAuthDigitalSignature(X509Certificate userCert, PrivateKey key, X509Certificate serverRootCa) {
            Ikev2VpnProfile.checkNotNull(userCert, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"userCert"});
            Ikev2VpnProfile.checkNotNull(key, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"key"});
            Ikev2VpnProfile.checkCert(userCert);
            if (serverRootCa != null) {
                Ikev2VpnProfile.checkCert(serverRootCa);
            }
            this.resetAuthParams();
            this.mUserCert = userCert;
            this.mRsaPrivateKey = key;
            this.mServerRootCaCert = serverRootCa;
            this.mType = 8;
            return this;
        }

        public Builder setAuthPsk(byte[] psk) {
            Ikev2VpnProfile.checkNotNull(psk, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"psk"});
            this.resetAuthParams();
            this.mPresharedKey = psk;
            this.mType = 7;
            return this;
        }

        public Builder setBypassable(boolean isBypassable) {
            this.mIsBypassable = isBypassable;
            return this;
        }

        public Builder setProxy(ProxyInfo proxy) {
            this.mProxyInfo = proxy;
            return this;
        }

        public Builder setMaxMtu(int mtu) {
            if (mtu < 1280) {
                throw new IllegalArgumentException("Max MTU must be at least 1280");
            }
            this.mMaxMtu = mtu;
            return this;
        }

        public Builder setMetered(boolean isMetered) {
            this.mIsMetered = isMetered;
            return this;
        }

        public Builder setAllowedAlgorithms(List<String> algorithmNames) {
            Ikev2VpnProfile.checkNotNull(algorithmNames, Ikev2VpnProfile.MISSING_PARAM_MSG_TMPL, new Object[]{"algorithmNames"});
            Ikev2VpnProfile.validateAllowedAlgorithms(algorithmNames);
            this.mAllowedAlgorithms = algorithmNames;
            return this;
        }

        public Builder restrictToTestNetworks() {
            this.mIsRestrictedToTestNetworks = true;
            return this;
        }

        public Ikev2VpnProfile build() {
            return new Ikev2VpnProfile(this.mType, this.mServerAddr, this.mUserIdentity, this.mPresharedKey, this.mServerRootCaCert, this.mUsername, this.mPassword, this.mRsaPrivateKey, this.mUserCert, this.mProxyInfo, this.mAllowedAlgorithms, this.mIsBypassable, this.mIsMetered, this.mMaxMtu, this.mIsRestrictedToTestNetworks);
        }
    }
}

