/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.content.Context;
import android.net.NetworkCapabilities;
import android.net.NetworkStateSnapshot;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.util.proto.ProtoOutputStream;
import com.android.net.module.util.NetworkIdentityUtils;
import java.util.Objects;

public class NetworkIdentity
implements Comparable<NetworkIdentity> {
    private static final String TAG = "NetworkIdentity";
    public static final int SUBTYPE_COMBINED = -1;
    public static final int OEM_NONE = 0;
    public static final int OEM_PAID = 1;
    public static final int OEM_PRIVATE = 2;
    final int mType;
    final int mSubType;
    final String mSubscriberId;
    final String mNetworkId;
    final boolean mRoaming;
    final boolean mMetered;
    final boolean mDefaultNetwork;
    final int mOemManaged;

    public NetworkIdentity(int type, int subType, String subscriberId, String networkId, boolean roaming, boolean metered, boolean defaultNetwork, int oemManaged) {
        this.mType = type;
        this.mSubType = subType;
        this.mSubscriberId = subscriberId;
        this.mNetworkId = networkId;
        this.mRoaming = roaming;
        this.mMetered = metered;
        this.mDefaultNetwork = defaultNetwork;
        this.mOemManaged = oemManaged;
    }

    public int hashCode() {
        return Objects.hash(this.mType, this.mSubType, this.mSubscriberId, this.mNetworkId, this.mRoaming, this.mMetered, this.mDefaultNetwork, this.mOemManaged);
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkIdentity) {
            NetworkIdentity ident = (NetworkIdentity)obj;
            return this.mType == ident.mType && this.mSubType == ident.mSubType && this.mRoaming == ident.mRoaming && Objects.equals(this.mSubscriberId, ident.mSubscriberId) && Objects.equals(this.mNetworkId, ident.mNetworkId) && this.mMetered == ident.mMetered && this.mDefaultNetwork == ident.mDefaultNetwork && this.mOemManaged == ident.mOemManaged;
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("{");
        builder.append("type=").append(this.mType);
        builder.append(", subType=");
        if (this.mSubType == -1) {
            builder.append("COMBINED");
        } else {
            builder.append(this.mSubType);
        }
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        if (this.mRoaming) {
            builder.append(", ROAMING");
        }
        builder.append(", metered=").append(this.mMetered);
        builder.append(", defaultNetwork=").append(this.mDefaultNetwork);
        builder.append(", oemManaged=").append(this.mOemManaged);
        return builder.append("}").toString();
    }

    public void dumpDebug(ProtoOutputStream proto, long tag) {
        long start = proto.start(tag);
        proto.write(0x10500000001L, this.mType);
        if (this.mSubscriberId != null) {
            proto.write(1138166333442L, NetworkIdentityUtils.scrubSubscriberId(this.mSubscriberId));
        }
        proto.write(1138166333443L, this.mNetworkId);
        proto.write(1133871366148L, this.mRoaming);
        proto.write(1133871366149L, this.mMetered);
        proto.write(1133871366150L, this.mDefaultNetwork);
        proto.write(1120986464263L, this.mOemManaged);
        proto.end(start);
    }

    public int getType() {
        return this.mType;
    }

    public int getSubType() {
        return this.mSubType;
    }

    public String getSubscriberId() {
        return this.mSubscriberId;
    }

    public String getNetworkId() {
        return this.mNetworkId;
    }

    public boolean getRoaming() {
        return this.mRoaming;
    }

    public boolean getMetered() {
        return this.mMetered;
    }

    public boolean getDefaultNetwork() {
        return this.mDefaultNetwork;
    }

    public int getOemManaged() {
        return this.mOemManaged;
    }

    public static NetworkIdentity buildNetworkIdentity(Context context, NetworkStateSnapshot snapshot, boolean defaultNetwork, int subType) {
        int legacyType = snapshot.getLegacyType();
        String subscriberId = snapshot.getSubscriberId();
        String networkId = null;
        boolean roaming = !snapshot.getNetworkCapabilities().hasCapability(18);
        boolean metered = !snapshot.getNetworkCapabilities().hasCapability(11);
        int oemManaged = NetworkIdentity.getOemBitfield(snapshot.getNetworkCapabilities());
        if (legacyType == 1 && (networkId = snapshot.getNetworkCapabilities().getSsid()) == null) {
            WifiManager wifi = context.getSystemService(WifiManager.class);
            WifiInfo info = wifi.getConnectionInfo();
            networkId = info != null ? info.getSSID() : null;
        }
        return new NetworkIdentity(legacyType, subType, subscriberId, networkId, roaming, metered, defaultNetwork, oemManaged);
    }

    public static int getOemBitfield(NetworkCapabilities nc) {
        int oemManaged = 0;
        if (nc.hasCapability(22)) {
            oemManaged |= 1;
        }
        if (nc.hasCapability(26)) {
            oemManaged |= 2;
        }
        return oemManaged;
    }

    @Override
    public int compareTo(NetworkIdentity another) {
        int res = Integer.compare(this.mType, another.mType);
        if (res == 0) {
            res = Integer.compare(this.mSubType, another.mSubType);
        }
        if (res == 0 && this.mSubscriberId != null && another.mSubscriberId != null) {
            res = this.mSubscriberId.compareTo(another.mSubscriberId);
        }
        if (res == 0 && this.mNetworkId != null && another.mNetworkId != null) {
            res = this.mNetworkId.compareTo(another.mNetworkId);
        }
        if (res == 0) {
            res = Boolean.compare(this.mRoaming, another.mRoaming);
        }
        if (res == 0) {
            res = Boolean.compare(this.mMetered, another.mMetered);
        }
        if (res == 0) {
            res = Boolean.compare(this.mDefaultNetwork, another.mDefaultNetwork);
        }
        if (res == 0) {
            res = Integer.compare(this.mOemManaged, another.mOemManaged);
        }
        return res;
    }
}

