/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.compat.annotation.UnsupportedAppUsage;
import android.net.DhcpInfo;
import android.net.Network;
import android.net.wifi.CoexUnsafeChannel;
import android.net.wifi.IActionListener;
import android.net.wifi.ICoexCallback;
import android.net.wifi.IDppCallback;
import android.net.wifi.ILocalOnlyHotspotCallback;
import android.net.wifi.INetworkRequestMatchCallback;
import android.net.wifi.IOnWifiActivityEnergyInfoListener;
import android.net.wifi.IOnWifiUsabilityStatsListener;
import android.net.wifi.IScanResultsCallback;
import android.net.wifi.ISoftApCallback;
import android.net.wifi.ISubsystemRestartCallback;
import android.net.wifi.ISuggestionConnectionStatusListener;
import android.net.wifi.ISuggestionUserApprovalStatusListener;
import android.net.wifi.ITrafficStateCallback;
import android.net.wifi.IWifiConnectedNetworkScorer;
import android.net.wifi.IWifiVerboseLoggingStatusChangedListener;
import android.net.wifi.ScanResult;
import android.net.wifi.SoftApConfiguration;
import android.net.wifi.WifiAvailableChannel;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.WifiNetworkSuggestion;
import android.net.wifi.hotspot2.IProvisioningCallback;
import android.net.wifi.hotspot2.OsuProvider;
import android.net.wifi.hotspot2.PasspointConfiguration;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.WorkSource;
import com.android.wifi.x.com.android.modules.utils.ParceledListSlice;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface IWifiManager
extends IInterface {
    public long getSupportedFeatures() throws RemoteException;

    public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener var1) throws RemoteException;

    public ParceledListSlice getConfiguredNetworks(String var1, String var2, boolean var3) throws RemoteException;

    public ParceledListSlice getPrivilegedConfiguredNetworks(String var1, String var2) throws RemoteException;

    public Map getAllMatchingFqdnsForScanResults(List<ScanResult> var1) throws RemoteException;

    public Map getMatchingOsuProviders(List<ScanResult> var1) throws RemoteException;

    public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> var1) throws RemoteException;

    public int addOrUpdateNetwork(WifiConfiguration var1, String var2) throws RemoteException;

    public WifiManager.AddNetworkResult addOrUpdateNetworkPrivileged(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration var1, String var2) throws RemoteException;

    public boolean removePasspointConfiguration(String var1, String var2) throws RemoteException;

    public List<PasspointConfiguration> getPasspointConfigurations(String var1) throws RemoteException;

    public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> var1) throws RemoteException;

    public void queryPasspointIcon(long var1, String var3) throws RemoteException;

    public int matchProviderWithCurrentNetwork(String var1) throws RemoteException;

    public boolean removeNetwork(int var1, String var2) throws RemoteException;

    public boolean removeNonCallerConfiguredNetworks(String var1) throws RemoteException;

    public boolean enableNetwork(int var1, boolean var2, String var3) throws RemoteException;

    public boolean disableNetwork(int var1, String var2) throws RemoteException;

    public void allowAutojoinGlobal(boolean var1) throws RemoteException;

    public void allowAutojoin(int var1, boolean var2) throws RemoteException;

    public void allowAutojoinPasspoint(String var1, boolean var2) throws RemoteException;

    public void setMacRandomizationSettingPasspointEnabled(String var1, boolean var2) throws RemoteException;

    public void setPasspointMeteredOverride(String var1, int var2) throws RemoteException;

    public boolean startScan(String var1, String var2) throws RemoteException;

    public List<ScanResult> getScanResults(String var1, String var2) throws RemoteException;

    public boolean disconnect(String var1) throws RemoteException;

    public boolean reconnect(String var1) throws RemoteException;

    public boolean reassociate(String var1) throws RemoteException;

    public WifiInfo getConnectionInfo(String var1, String var2) throws RemoteException;

    public boolean setWifiEnabled(String var1, boolean var2) throws RemoteException;

    public int getWifiEnabledState() throws RemoteException;

    public String getCountryCode() throws RemoteException;

    public void setOverrideCountryCode(String var1) throws RemoteException;

    public void clearOverrideCountryCode() throws RemoteException;

    public void setDefaultCountryCode(String var1) throws RemoteException;

    public boolean is24GHzBandSupported() throws RemoteException;

    public boolean is5GHzBandSupported() throws RemoteException;

    public boolean is6GHzBandSupported() throws RemoteException;

    public boolean is60GHzBandSupported() throws RemoteException;

    public boolean isWifiStandardSupported(int var1) throws RemoteException;

    public DhcpInfo getDhcpInfo(String var1) throws RemoteException;

    public void setScanAlwaysAvailable(boolean var1, String var2) throws RemoteException;

    public boolean isScanAlwaysAvailable() throws RemoteException;

    public boolean acquireWifiLock(IBinder var1, int var2, String var3, WorkSource var4) throws RemoteException;

    public void updateWifiLockWorkSource(IBinder var1, WorkSource var2) throws RemoteException;

    public boolean releaseWifiLock(IBinder var1) throws RemoteException;

    public void initializeMulticastFiltering() throws RemoteException;

    public boolean isMulticastEnabled() throws RemoteException;

    public void acquireMulticastLock(IBinder var1, String var2) throws RemoteException;

    public void releaseMulticastLock(String var1) throws RemoteException;

    public void updateInterfaceIpState(String var1, int var2) throws RemoteException;

    public boolean isDefaultCoexAlgorithmEnabled() throws RemoteException;

    public void setCoexUnsafeChannels(List<CoexUnsafeChannel> var1, int var2) throws RemoteException;

    public void registerCoexCallback(ICoexCallback var1) throws RemoteException;

    public void unregisterCoexCallback(ICoexCallback var1) throws RemoteException;

    public boolean startSoftAp(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean startTetheredHotspot(SoftApConfiguration var1, String var2) throws RemoteException;

    public boolean stopSoftAp() throws RemoteException;

    public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback var1, String var2, String var3, SoftApConfiguration var4) throws RemoteException;

    public void stopLocalOnlyHotspot() throws RemoteException;

    public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback var1) throws RemoteException;

    public void stopWatchLocalOnlyHotspot() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Wifi/framework/java/android/net/wifi/IWifiManager.aidl:189:1:189:25")
    public int getWifiApEnabledState() throws RemoteException;

    @UnsupportedAppUsage(overrideSourcePosition="packages/modules/Wifi/framework/java/android/net/wifi/IWifiManager.aidl:192:1:192:25")
    public WifiConfiguration getWifiApConfiguration() throws RemoteException;

    public SoftApConfiguration getSoftApConfiguration() throws RemoteException;

    public boolean setWifiApConfiguration(WifiConfiguration var1, String var2) throws RemoteException;

    public boolean setSoftApConfiguration(SoftApConfiguration var1, String var2) throws RemoteException;

    public void notifyUserOfApBandConversion(String var1) throws RemoteException;

    public void enableTdls(String var1, boolean var2) throws RemoteException;

    public void enableTdlsWithMacAddress(String var1, boolean var2) throws RemoteException;

    public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException;

    public void enableVerboseLogging(int var1) throws RemoteException;

    public int getVerboseLoggingLevel() throws RemoteException;

    public void disableEphemeralNetwork(String var1, String var2) throws RemoteException;

    public void factoryReset(String var1) throws RemoteException;

    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L, overrideSourcePosition="packages/modules/Wifi/framework/java/android/net/wifi/IWifiManager.aidl:217:1:217:69")
    public Network getCurrentNetwork() throws RemoteException;

    public byte[] retrieveBackupData() throws RemoteException;

    public void restoreBackupData(byte[] var1) throws RemoteException;

    public byte[] retrieveSoftApBackupData() throws RemoteException;

    public SoftApConfiguration restoreSoftApBackupData(byte[] var1) throws RemoteException;

    public void restoreSupplicantBackupData(byte[] var1, byte[] var2) throws RemoteException;

    public void startSubscriptionProvisioning(OsuProvider var1, IProvisioningCallback var2) throws RemoteException;

    public void registerSoftApCallback(ISoftApCallback var1) throws RemoteException;

    public void unregisterSoftApCallback(ISoftApCallback var1) throws RemoteException;

    public void addWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener var1) throws RemoteException;

    public void removeWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener var1) throws RemoteException;

    public void addOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener var1) throws RemoteException;

    public void removeOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener var1) throws RemoteException;

    public void registerTrafficStateCallback(ITrafficStateCallback var1) throws RemoteException;

    public void unregisterTrafficStateCallback(ITrafficStateCallback var1) throws RemoteException;

    public void registerNetworkRequestMatchCallback(INetworkRequestMatchCallback var1) throws RemoteException;

    public void unregisterNetworkRequestMatchCallback(INetworkRequestMatchCallback var1) throws RemoteException;

    public int addNetworkSuggestions(List<WifiNetworkSuggestion> var1, String var2, String var3) throws RemoteException;

    public int removeNetworkSuggestions(List<WifiNetworkSuggestion> var1, String var2) throws RemoteException;

    public List<WifiNetworkSuggestion> getNetworkSuggestions(String var1) throws RemoteException;

    public String[] getFactoryMacAddresses() throws RemoteException;

    public void setDeviceMobilityState(int var1) throws RemoteException;

    public void startDppAsConfiguratorInitiator(IBinder var1, String var2, String var3, int var4, int var5, IDppCallback var6) throws RemoteException;

    public void startDppAsEnrolleeInitiator(IBinder var1, String var2, IDppCallback var3) throws RemoteException;

    public void startDppAsEnrolleeResponder(IBinder var1, String var2, int var3, IDppCallback var4) throws RemoteException;

    public void stopDppSession() throws RemoteException;

    public void updateWifiUsabilityScore(int var1, int var2, int var3) throws RemoteException;

    public void connect(WifiConfiguration var1, int var2, IActionListener var3) throws RemoteException;

    public void save(WifiConfiguration var1, IActionListener var2) throws RemoteException;

    public void forget(int var1, IActionListener var2) throws RemoteException;

    public void registerScanResultsCallback(IScanResultsCallback var1) throws RemoteException;

    public void unregisterScanResultsCallback(IScanResultsCallback var1) throws RemoteException;

    public void registerSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener var1, String var2, String var3) throws RemoteException;

    public void unregisterSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener var1, String var2) throws RemoteException;

    public int calculateSignalLevel(int var1) throws RemoteException;

    public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> var1) throws RemoteException;

    public boolean setWifiConnectedNetworkScorer(IBinder var1, IWifiConnectedNetworkScorer var2) throws RemoteException;

    public void clearWifiConnectedNetworkScorer() throws RemoteException;

    public Map getMatchingScanResults(List<WifiNetworkSuggestion> var1, List<ScanResult> var2, String var3, String var4) throws RemoteException;

    public void setScanThrottleEnabled(boolean var1) throws RemoteException;

    public boolean isScanThrottleEnabled() throws RemoteException;

    public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> var1) throws RemoteException;

    public void setAutoWakeupEnabled(boolean var1) throws RemoteException;

    public boolean isAutoWakeupEnabled() throws RemoteException;

    public void startRestrictingAutoJoinToSubscriptionId(int var1) throws RemoteException;

    public void stopRestrictingAutoJoinToSubscriptionId() throws RemoteException;

    public void setCarrierNetworkOffloadEnabled(int var1, boolean var2, boolean var3) throws RemoteException;

    public boolean isCarrierNetworkOffloadEnabled(int var1, boolean var2) throws RemoteException;

    public void registerSubsystemRestartCallback(ISubsystemRestartCallback var1) throws RemoteException;

    public void unregisterSubsystemRestartCallback(ISubsystemRestartCallback var1) throws RemoteException;

    public void restartWifiSubsystem() throws RemoteException;

    public void addSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener var1, String var2) throws RemoteException;

    public void removeSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener var1, String var2) throws RemoteException;

    public void setEmergencyScanRequestInProgress(boolean var1) throws RemoteException;

    public void removeAppState(int var1, String var2) throws RemoteException;

    public boolean setWifiScoringEnabled(boolean var1) throws RemoteException;

    public void flushPasspointAnqpCache(String var1) throws RemoteException;

    public List<WifiAvailableChannel> getUsableChannels(int var1, int var2, int var3) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IWifiManager {
        public static final String DESCRIPTOR = "android.net.wifi.IWifiManager";
        static final int TRANSACTION_getSupportedFeatures = 1;
        static final int TRANSACTION_getWifiActivityEnergyInfoAsync = 2;
        static final int TRANSACTION_getConfiguredNetworks = 3;
        static final int TRANSACTION_getPrivilegedConfiguredNetworks = 4;
        static final int TRANSACTION_getAllMatchingFqdnsForScanResults = 5;
        static final int TRANSACTION_getMatchingOsuProviders = 6;
        static final int TRANSACTION_getMatchingPasspointConfigsForOsuProviders = 7;
        static final int TRANSACTION_addOrUpdateNetwork = 8;
        static final int TRANSACTION_addOrUpdateNetworkPrivileged = 9;
        static final int TRANSACTION_addOrUpdatePasspointConfiguration = 10;
        static final int TRANSACTION_removePasspointConfiguration = 11;
        static final int TRANSACTION_getPasspointConfigurations = 12;
        static final int TRANSACTION_getWifiConfigsForPasspointProfiles = 13;
        static final int TRANSACTION_queryPasspointIcon = 14;
        static final int TRANSACTION_matchProviderWithCurrentNetwork = 15;
        static final int TRANSACTION_removeNetwork = 16;
        static final int TRANSACTION_removeNonCallerConfiguredNetworks = 17;
        static final int TRANSACTION_enableNetwork = 18;
        static final int TRANSACTION_disableNetwork = 19;
        static final int TRANSACTION_allowAutojoinGlobal = 20;
        static final int TRANSACTION_allowAutojoin = 21;
        static final int TRANSACTION_allowAutojoinPasspoint = 22;
        static final int TRANSACTION_setMacRandomizationSettingPasspointEnabled = 23;
        static final int TRANSACTION_setPasspointMeteredOverride = 24;
        static final int TRANSACTION_startScan = 25;
        static final int TRANSACTION_getScanResults = 26;
        static final int TRANSACTION_disconnect = 27;
        static final int TRANSACTION_reconnect = 28;
        static final int TRANSACTION_reassociate = 29;
        static final int TRANSACTION_getConnectionInfo = 30;
        static final int TRANSACTION_setWifiEnabled = 31;
        static final int TRANSACTION_getWifiEnabledState = 32;
        static final int TRANSACTION_getCountryCode = 33;
        static final int TRANSACTION_setOverrideCountryCode = 34;
        static final int TRANSACTION_clearOverrideCountryCode = 35;
        static final int TRANSACTION_setDefaultCountryCode = 36;
        static final int TRANSACTION_is24GHzBandSupported = 37;
        static final int TRANSACTION_is5GHzBandSupported = 38;
        static final int TRANSACTION_is6GHzBandSupported = 39;
        static final int TRANSACTION_is60GHzBandSupported = 40;
        static final int TRANSACTION_isWifiStandardSupported = 41;
        static final int TRANSACTION_getDhcpInfo = 42;
        static final int TRANSACTION_setScanAlwaysAvailable = 43;
        static final int TRANSACTION_isScanAlwaysAvailable = 44;
        static final int TRANSACTION_acquireWifiLock = 45;
        static final int TRANSACTION_updateWifiLockWorkSource = 46;
        static final int TRANSACTION_releaseWifiLock = 47;
        static final int TRANSACTION_initializeMulticastFiltering = 48;
        static final int TRANSACTION_isMulticastEnabled = 49;
        static final int TRANSACTION_acquireMulticastLock = 50;
        static final int TRANSACTION_releaseMulticastLock = 51;
        static final int TRANSACTION_updateInterfaceIpState = 52;
        static final int TRANSACTION_isDefaultCoexAlgorithmEnabled = 53;
        static final int TRANSACTION_setCoexUnsafeChannels = 54;
        static final int TRANSACTION_registerCoexCallback = 55;
        static final int TRANSACTION_unregisterCoexCallback = 56;
        static final int TRANSACTION_startSoftAp = 57;
        static final int TRANSACTION_startTetheredHotspot = 58;
        static final int TRANSACTION_stopSoftAp = 59;
        static final int TRANSACTION_startLocalOnlyHotspot = 60;
        static final int TRANSACTION_stopLocalOnlyHotspot = 61;
        static final int TRANSACTION_startWatchLocalOnlyHotspot = 62;
        static final int TRANSACTION_stopWatchLocalOnlyHotspot = 63;
        static final int TRANSACTION_getWifiApEnabledState = 64;
        static final int TRANSACTION_getWifiApConfiguration = 65;
        static final int TRANSACTION_getSoftApConfiguration = 66;
        static final int TRANSACTION_setWifiApConfiguration = 67;
        static final int TRANSACTION_setSoftApConfiguration = 68;
        static final int TRANSACTION_notifyUserOfApBandConversion = 69;
        static final int TRANSACTION_enableTdls = 70;
        static final int TRANSACTION_enableTdlsWithMacAddress = 71;
        static final int TRANSACTION_getCurrentNetworkWpsNfcConfigurationToken = 72;
        static final int TRANSACTION_enableVerboseLogging = 73;
        static final int TRANSACTION_getVerboseLoggingLevel = 74;
        static final int TRANSACTION_disableEphemeralNetwork = 75;
        static final int TRANSACTION_factoryReset = 76;
        static final int TRANSACTION_getCurrentNetwork = 77;
        static final int TRANSACTION_retrieveBackupData = 78;
        static final int TRANSACTION_restoreBackupData = 79;
        static final int TRANSACTION_retrieveSoftApBackupData = 80;
        static final int TRANSACTION_restoreSoftApBackupData = 81;
        static final int TRANSACTION_restoreSupplicantBackupData = 82;
        static final int TRANSACTION_startSubscriptionProvisioning = 83;
        static final int TRANSACTION_registerSoftApCallback = 84;
        static final int TRANSACTION_unregisterSoftApCallback = 85;
        static final int TRANSACTION_addWifiVerboseLoggingStatusChangedListener = 86;
        static final int TRANSACTION_removeWifiVerboseLoggingStatusChangedListener = 87;
        static final int TRANSACTION_addOnWifiUsabilityStatsListener = 88;
        static final int TRANSACTION_removeOnWifiUsabilityStatsListener = 89;
        static final int TRANSACTION_registerTrafficStateCallback = 90;
        static final int TRANSACTION_unregisterTrafficStateCallback = 91;
        static final int TRANSACTION_registerNetworkRequestMatchCallback = 92;
        static final int TRANSACTION_unregisterNetworkRequestMatchCallback = 93;
        static final int TRANSACTION_addNetworkSuggestions = 94;
        static final int TRANSACTION_removeNetworkSuggestions = 95;
        static final int TRANSACTION_getNetworkSuggestions = 96;
        static final int TRANSACTION_getFactoryMacAddresses = 97;
        static final int TRANSACTION_setDeviceMobilityState = 98;
        static final int TRANSACTION_startDppAsConfiguratorInitiator = 99;
        static final int TRANSACTION_startDppAsEnrolleeInitiator = 100;
        static final int TRANSACTION_startDppAsEnrolleeResponder = 101;
        static final int TRANSACTION_stopDppSession = 102;
        static final int TRANSACTION_updateWifiUsabilityScore = 103;
        static final int TRANSACTION_connect = 104;
        static final int TRANSACTION_save = 105;
        static final int TRANSACTION_forget = 106;
        static final int TRANSACTION_registerScanResultsCallback = 107;
        static final int TRANSACTION_unregisterScanResultsCallback = 108;
        static final int TRANSACTION_registerSuggestionConnectionStatusListener = 109;
        static final int TRANSACTION_unregisterSuggestionConnectionStatusListener = 110;
        static final int TRANSACTION_calculateSignalLevel = 111;
        static final int TRANSACTION_getWifiConfigForMatchedNetworkSuggestionsSharedWithUser = 112;
        static final int TRANSACTION_setWifiConnectedNetworkScorer = 113;
        static final int TRANSACTION_clearWifiConnectedNetworkScorer = 114;
        static final int TRANSACTION_getMatchingScanResults = 115;
        static final int TRANSACTION_setScanThrottleEnabled = 116;
        static final int TRANSACTION_isScanThrottleEnabled = 117;
        static final int TRANSACTION_getAllMatchingPasspointProfilesForScanResults = 118;
        static final int TRANSACTION_setAutoWakeupEnabled = 119;
        static final int TRANSACTION_isAutoWakeupEnabled = 120;
        static final int TRANSACTION_startRestrictingAutoJoinToSubscriptionId = 121;
        static final int TRANSACTION_stopRestrictingAutoJoinToSubscriptionId = 122;
        static final int TRANSACTION_setCarrierNetworkOffloadEnabled = 123;
        static final int TRANSACTION_isCarrierNetworkOffloadEnabled = 124;
        static final int TRANSACTION_registerSubsystemRestartCallback = 125;
        static final int TRANSACTION_unregisterSubsystemRestartCallback = 126;
        static final int TRANSACTION_restartWifiSubsystem = 127;
        static final int TRANSACTION_addSuggestionUserApprovalStatusListener = 128;
        static final int TRANSACTION_removeSuggestionUserApprovalStatusListener = 129;
        static final int TRANSACTION_setEmergencyScanRequestInProgress = 130;
        static final int TRANSACTION_removeAppState = 131;
        static final int TRANSACTION_setWifiScoringEnabled = 132;
        static final int TRANSACTION_flushPasspointAnqpCache = 133;
        static final int TRANSACTION_getUsableChannels = 134;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IWifiManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(DESCRIPTOR);
            if (iin != null && iin instanceof IWifiManager) {
                return (IWifiManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    long _result = this.getSupportedFeatures();
                    reply.writeNoException();
                    reply.writeLong(_result);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IOnWifiActivityEnergyInfoListener _arg0 = IOnWifiActivityEnergyInfoListener.Stub.asInterface(data.readStrongBinder());
                    this.getWifiActivityEnergyInfoAsync(_arg0);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _arg2 = 0 != data.readInt();
                    ParceledListSlice _result = this.getConfiguredNetworks(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    ParceledListSlice _result = this.getPrivilegedConfiguredNetworks(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getAllMatchingFqdnsForScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getMatchingOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    ArrayList<OsuProvider> _arg0 = data.createTypedArrayList(OsuProvider.CREATOR);
                    Map _result = this.getMatchingPasspointConfigsForOsuProviders(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    int _result = this.addOrUpdateNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    WifiManager.AddNetworkResult _result = this.addOrUpdateNetworkPrivileged(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 10: {
                    data.enforceInterface(descriptor);
                    PasspointConfiguration _arg0 = 0 != data.readInt() ? PasspointConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.addOrUpdatePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 11: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.removePasspointConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 12: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<PasspointConfiguration> _result = this.getPasspointConfigurations(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 13: {
                    data.enforceInterface(descriptor);
                    ArrayList<String> _arg0 = data.createStringArrayList();
                    List<WifiConfiguration> _result = this.getWifiConfigsForPasspointProfiles(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 14: {
                    data.enforceInterface(descriptor);
                    long _arg0 = data.readLong();
                    String _arg1 = data.readString();
                    this.queryPasspointIcon(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 15: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _result = this.matchProviderWithCurrentNetwork(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 16: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.removeNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 17: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.removeNonCallerConfiguredNetworks(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 18: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    String _arg2 = data.readString();
                    boolean _result = this.enableNetwork(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 19: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    boolean _result = this.disableNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 20: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.allowAutojoinGlobal(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 21: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    this.allowAutojoin(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 22: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.allowAutojoinPasspoint(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 23: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.setMacRandomizationSettingPasspointEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 24: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.setPasspointMeteredOverride(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 25: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    boolean _result = this.startScan(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 26: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    List<ScanResult> _result = this.getScanResults(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 27: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.disconnect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 28: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.reconnect(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 29: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _result = this.reassociate(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 30: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    WifiInfo _result = this.getConnectionInfo(_arg0, _arg1);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 31: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.setWifiEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 32: {
                    data.enforceInterface(descriptor);
                    int _result = this.getWifiEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 33: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCountryCode();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 34: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.setOverrideCountryCode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 35: {
                    data.enforceInterface(descriptor);
                    this.clearOverrideCountryCode();
                    reply.writeNoException();
                    return true;
                }
                case 36: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.setDefaultCountryCode(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 37: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.is24GHzBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 38: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.is5GHzBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 39: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.is6GHzBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 40: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.is60GHzBandSupported();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 41: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _result = this.isWifiStandardSupported(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 42: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    DhcpInfo _result = this.getDhcpInfo(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 43: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    String _arg1 = data.readString();
                    this.setScanAlwaysAvailable(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 44: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isScanAlwaysAvailable();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 45: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    int _arg1 = data.readInt();
                    String _arg2 = data.readString();
                    WorkSource _arg3 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    boolean _result = this.acquireWifiLock(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 46: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    WorkSource _arg1 = 0 != data.readInt() ? WorkSource.CREATOR.createFromParcel(data) : null;
                    this.updateWifiLockWorkSource(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 47: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    boolean _result = this.releaseWifiLock(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 48: {
                    data.enforceInterface(descriptor);
                    this.initializeMulticastFiltering();
                    reply.writeNoException();
                    return true;
                }
                case 49: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isMulticastEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 50: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    this.acquireMulticastLock(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 51: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.releaseMulticastLock(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 52: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    int _arg1 = data.readInt();
                    this.updateInterfaceIpState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 53: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isDefaultCoexAlgorithmEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 54: {
                    data.enforceInterface(descriptor);
                    ArrayList<CoexUnsafeChannel> _arg0 = data.createTypedArrayList(CoexUnsafeChannel.CREATOR);
                    int _arg1 = data.readInt();
                    this.setCoexUnsafeChannels(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 55: {
                    data.enforceInterface(descriptor);
                    ICoexCallback _arg0 = ICoexCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerCoexCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 56: {
                    data.enforceInterface(descriptor);
                    ICoexCallback _arg0 = ICoexCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterCoexCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 57: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.startSoftAp(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 58: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _arg0 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.startTetheredHotspot(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 59: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.stopSoftAp();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 60: {
                    data.enforceInterface(descriptor);
                    ILocalOnlyHotspotCallback _arg0 = ILocalOnlyHotspotCallback.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    SoftApConfiguration _arg3 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    int _result = this.startLocalOnlyHotspot(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 61: {
                    data.enforceInterface(descriptor);
                    this.stopLocalOnlyHotspot();
                    reply.writeNoException();
                    return true;
                }
                case 62: {
                    data.enforceInterface(descriptor);
                    ILocalOnlyHotspotCallback _arg0 = ILocalOnlyHotspotCallback.Stub.asInterface(data.readStrongBinder());
                    this.startWatchLocalOnlyHotspot(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 63: {
                    data.enforceInterface(descriptor);
                    this.stopWatchLocalOnlyHotspot();
                    reply.writeNoException();
                    return true;
                }
                case 64: {
                    data.enforceInterface(descriptor);
                    int _result = this.getWifiApEnabledState();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 65: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _result = this.getWifiApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 66: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _result = this.getSoftApConfiguration();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 67: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.setWifiApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 68: {
                    data.enforceInterface(descriptor);
                    SoftApConfiguration _arg0 = 0 != data.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(data) : null;
                    String _arg1 = data.readString();
                    boolean _result = this.setSoftApConfiguration(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 69: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.notifyUserOfApBandConversion(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 70: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdls(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 71: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    boolean _arg1 = 0 != data.readInt();
                    this.enableTdlsWithMacAddress(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 72: {
                    data.enforceInterface(descriptor);
                    String _result = this.getCurrentNetworkWpsNfcConfigurationToken();
                    reply.writeNoException();
                    reply.writeString(_result);
                    return true;
                }
                case 73: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.enableVerboseLogging(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 74: {
                    data.enforceInterface(descriptor);
                    int _result = this.getVerboseLoggingLevel();
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 75: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    String _arg1 = data.readString();
                    this.disableEphemeralNetwork(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 76: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.factoryReset(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 77: {
                    data.enforceInterface(descriptor);
                    Network _result = this.getCurrentNetwork();
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 78: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.retrieveBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 79: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    this.restoreBackupData(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 80: {
                    data.enforceInterface(descriptor);
                    byte[] _result = this.retrieveSoftApBackupData();
                    reply.writeNoException();
                    reply.writeByteArray(_result);
                    return true;
                }
                case 81: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    SoftApConfiguration _result = this.restoreSoftApBackupData(_arg0);
                    reply.writeNoException();
                    if (_result != null) {
                        reply.writeInt(1);
                        _result.writeToParcel(reply, 1);
                    } else {
                        reply.writeInt(0);
                    }
                    return true;
                }
                case 82: {
                    data.enforceInterface(descriptor);
                    byte[] _arg0 = data.createByteArray();
                    byte[] _arg1 = data.createByteArray();
                    this.restoreSupplicantBackupData(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 83: {
                    data.enforceInterface(descriptor);
                    OsuProvider _arg0 = 0 != data.readInt() ? OsuProvider.CREATOR.createFromParcel(data) : null;
                    IProvisioningCallback _arg1 = IProvisioningCallback.Stub.asInterface(data.readStrongBinder());
                    this.startSubscriptionProvisioning(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 84: {
                    data.enforceInterface(descriptor);
                    ISoftApCallback _arg0 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSoftApCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 85: {
                    data.enforceInterface(descriptor);
                    ISoftApCallback _arg0 = ISoftApCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSoftApCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 86: {
                    data.enforceInterface(descriptor);
                    IWifiVerboseLoggingStatusChangedListener _arg0 = IWifiVerboseLoggingStatusChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.addWifiVerboseLoggingStatusChangedListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 87: {
                    data.enforceInterface(descriptor);
                    IWifiVerboseLoggingStatusChangedListener _arg0 = IWifiVerboseLoggingStatusChangedListener.Stub.asInterface(data.readStrongBinder());
                    this.removeWifiVerboseLoggingStatusChangedListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 88: {
                    data.enforceInterface(descriptor);
                    IOnWifiUsabilityStatsListener _arg0 = IOnWifiUsabilityStatsListener.Stub.asInterface(data.readStrongBinder());
                    this.addOnWifiUsabilityStatsListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 89: {
                    data.enforceInterface(descriptor);
                    IOnWifiUsabilityStatsListener _arg0 = IOnWifiUsabilityStatsListener.Stub.asInterface(data.readStrongBinder());
                    this.removeOnWifiUsabilityStatsListener(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 90: {
                    data.enforceInterface(descriptor);
                    ITrafficStateCallback _arg0 = ITrafficStateCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerTrafficStateCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 91: {
                    data.enforceInterface(descriptor);
                    ITrafficStateCallback _arg0 = ITrafficStateCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterTrafficStateCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 92: {
                    data.enforceInterface(descriptor);
                    INetworkRequestMatchCallback _arg0 = INetworkRequestMatchCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerNetworkRequestMatchCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 93: {
                    data.enforceInterface(descriptor);
                    INetworkRequestMatchCallback _arg0 = INetworkRequestMatchCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterNetworkRequestMatchCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 94: {
                    data.enforceInterface(descriptor);
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _result = this.addNetworkSuggestions(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 95: {
                    data.enforceInterface(descriptor);
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    String _arg1 = data.readString();
                    int _result = this.removeNetworkSuggestions(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 96: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    List<WifiNetworkSuggestion> _result = this.getNetworkSuggestions(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 97: {
                    data.enforceInterface(descriptor);
                    String[] _result = this.getFactoryMacAddresses();
                    reply.writeNoException();
                    reply.writeStringArray(_result);
                    return true;
                }
                case 98: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.setDeviceMobilityState(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 99: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    int _arg3 = data.readInt();
                    int _arg4 = data.readInt();
                    IDppCallback _arg5 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsConfiguratorInitiator(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5);
                    reply.writeNoException();
                    return true;
                }
                case 100: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    IDppCallback _arg2 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsEnrolleeInitiator(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 101: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    String _arg1 = data.readString();
                    int _arg2 = data.readInt();
                    IDppCallback _arg3 = IDppCallback.Stub.asInterface(data.readStrongBinder());
                    this.startDppAsEnrolleeResponder(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    return true;
                }
                case 102: {
                    data.enforceInterface(descriptor);
                    this.stopDppSession();
                    reply.writeNoException();
                    return true;
                }
                case 103: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    this.updateWifiUsabilityScore(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 104: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    IActionListener _arg2 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    this.connect(_arg0, _arg1, _arg2);
                    return true;
                }
                case 105: {
                    data.enforceInterface(descriptor);
                    WifiConfiguration _arg0 = 0 != data.readInt() ? WifiConfiguration.CREATOR.createFromParcel(data) : null;
                    IActionListener _arg1 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    this.save(_arg0, _arg1);
                    return true;
                }
                case 106: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    IActionListener _arg1 = IActionListener.Stub.asInterface(data.readStrongBinder());
                    this.forget(_arg0, _arg1);
                    return true;
                }
                case 107: {
                    data.enforceInterface(descriptor);
                    IScanResultsCallback _arg0 = IScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerScanResultsCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 108: {
                    data.enforceInterface(descriptor);
                    IScanResultsCallback _arg0 = IScanResultsCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterScanResultsCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 109: {
                    data.enforceInterface(descriptor);
                    ISuggestionConnectionStatusListener _arg0 = ISuggestionConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    String _arg2 = data.readString();
                    this.registerSuggestionConnectionStatusListener(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 110: {
                    data.enforceInterface(descriptor);
                    ISuggestionConnectionStatusListener _arg0 = ISuggestionConnectionStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.unregisterSuggestionConnectionStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 111: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _result = this.calculateSignalLevel(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result);
                    return true;
                }
                case 112: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    List<WifiConfiguration> _result = this.getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(_arg0);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
                case 113: {
                    data.enforceInterface(descriptor);
                    IBinder _arg0 = data.readStrongBinder();
                    IWifiConnectedNetworkScorer _arg1 = IWifiConnectedNetworkScorer.Stub.asInterface(data.readStrongBinder());
                    boolean _result = this.setWifiConnectedNetworkScorer(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 114: {
                    data.enforceInterface(descriptor);
                    this.clearWifiConnectedNetworkScorer();
                    reply.writeNoException();
                    return true;
                }
                case 115: {
                    data.enforceInterface(descriptor);
                    ArrayList<WifiNetworkSuggestion> _arg0 = data.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                    ArrayList<ScanResult> _arg1 = data.createTypedArrayList(ScanResult.CREATOR);
                    String _arg2 = data.readString();
                    String _arg3 = data.readString();
                    Map _result = this.getMatchingScanResults(_arg0, _arg1, _arg2, _arg3);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 116: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setScanThrottleEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 117: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isScanThrottleEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 118: {
                    data.enforceInterface(descriptor);
                    ArrayList<ScanResult> _arg0 = data.createTypedArrayList(ScanResult.CREATOR);
                    Map _result = this.getAllMatchingPasspointProfilesForScanResults(_arg0);
                    reply.writeNoException();
                    reply.writeMap(_result);
                    return true;
                }
                case 119: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setAutoWakeupEnabled(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 120: {
                    data.enforceInterface(descriptor);
                    boolean _result = this.isAutoWakeupEnabled();
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 121: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    this.startRestrictingAutoJoinToSubscriptionId(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 122: {
                    data.enforceInterface(descriptor);
                    this.stopRestrictingAutoJoinToSubscriptionId();
                    reply.writeNoException();
                    return true;
                }
                case 123: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _arg2 = 0 != data.readInt();
                    this.setCarrierNetworkOffloadEnabled(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    return true;
                }
                case 124: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    boolean _arg1 = 0 != data.readInt();
                    boolean _result = this.isCarrierNetworkOffloadEnabled(_arg0, _arg1);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 125: {
                    data.enforceInterface(descriptor);
                    ISubsystemRestartCallback _arg0 = ISubsystemRestartCallback.Stub.asInterface(data.readStrongBinder());
                    this.registerSubsystemRestartCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 126: {
                    data.enforceInterface(descriptor);
                    ISubsystemRestartCallback _arg0 = ISubsystemRestartCallback.Stub.asInterface(data.readStrongBinder());
                    this.unregisterSubsystemRestartCallback(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 127: {
                    data.enforceInterface(descriptor);
                    this.restartWifiSubsystem();
                    reply.writeNoException();
                    return true;
                }
                case 128: {
                    data.enforceInterface(descriptor);
                    ISuggestionUserApprovalStatusListener _arg0 = ISuggestionUserApprovalStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.addSuggestionUserApprovalStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 129: {
                    data.enforceInterface(descriptor);
                    ISuggestionUserApprovalStatusListener _arg0 = ISuggestionUserApprovalStatusListener.Stub.asInterface(data.readStrongBinder());
                    String _arg1 = data.readString();
                    this.removeSuggestionUserApprovalStatusListener(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 130: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    this.setEmergencyScanRequestInProgress(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 131: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    String _arg1 = data.readString();
                    this.removeAppState(_arg0, _arg1);
                    reply.writeNoException();
                    return true;
                }
                case 132: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    boolean _result = this.setWifiScoringEnabled(_arg0);
                    reply.writeNoException();
                    reply.writeInt(_result ? 1 : 0);
                    return true;
                }
                case 133: {
                    data.enforceInterface(descriptor);
                    String _arg0 = data.readString();
                    this.flushPasspointAnqpCache(_arg0);
                    reply.writeNoException();
                    return true;
                }
                case 134: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    int _arg2 = data.readInt();
                    List<WifiAvailableChannel> _result = this.getUsableChannels(_arg0, _arg1, _arg2);
                    reply.writeNoException();
                    reply.writeTypedList(_result);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(IWifiManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static IWifiManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements IWifiManager {
            private IBinder mRemote;
            public static IWifiManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public long getSupportedFeatures() throws RemoteException {
                long _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        long l = Stub.getDefaultImpl().getSupportedFeatures();
                        return l;
                    }
                    _reply.readException();
                    _result = _reply.readLong();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getWifiActivityEnergyInfoAsync(listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getConfiguredNetworks(String packageName, String featureId, boolean callerNetworksOnly) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    _data.writeInt(callerNetworksOnly ? 1 : 0);
                    boolean _status = this.mRemote.transact(3, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getConfiguredNetworks(packageName, featureId, callerNetworksOnly);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ParceledListSlice getPrivilegedConfiguredNetworks(String packageName, String featureId) throws RemoteException {
                ParceledListSlice _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(4, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        ParceledListSlice parceledListSlice = Stub.getDefaultImpl().getPrivilegedConfiguredNetworks(packageName, featureId);
                        return parceledListSlice;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAllMatchingFqdnsForScanResults(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResult);
                    boolean _status = this.mRemote.transact(5, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getAllMatchingFqdnsForScanResults(scanResult);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingOsuProviders(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResult);
                    boolean _status = this.mRemote.transact(6, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getMatchingOsuProviders(scanResult);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> osuProviders) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(osuProviders);
                    boolean _status = this.mRemote.transact(7, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getMatchingPasspointConfigsForOsuProviders(osuProviders);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addOrUpdateNetwork(WifiConfiguration config, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(8, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addOrUpdateNetwork(config, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiManager.AddNetworkResult addOrUpdateNetworkPrivileged(WifiConfiguration config, String packageName) throws RemoteException {
                WifiManager.AddNetworkResult _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(9, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WifiManager.AddNetworkResult addNetworkResult = Stub.getDefaultImpl().addOrUpdateNetworkPrivileged(config, packageName);
                        return addNetworkResult;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiManager.AddNetworkResult.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(10, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().addOrUpdatePasspointConfiguration(config, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(11, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removePasspointConfiguration(fqdn, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<PasspointConfiguration> getPasspointConfigurations(String packageName) throws RemoteException {
                ArrayList<PasspointConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(12, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<PasspointConfiguration> list = Stub.getDefaultImpl().getPasspointConfigurations(packageName);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(PasspointConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> fqdnList) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStringList(fqdnList);
                    boolean _status = this.mRemote.transact(13, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiConfiguration> list = Stub.getDefaultImpl().getWifiConfigsForPasspointProfiles(fqdnList);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void queryPasspointIcon(long bssid, String fileName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeLong(bssid);
                    _data.writeString(fileName);
                    boolean _status = this.mRemote.transact(14, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().queryPasspointIcon(bssid, fileName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    boolean _status = this.mRemote.transact(15, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().matchProviderWithCurrentNetwork(fqdn);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(16, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeNetwork(netId, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean removeNonCallerConfiguredNetworks(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(17, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().removeNonCallerConfiguredNetworks(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeInt(disableOthers ? 1 : 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(18, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().enableNetwork(netId, disableOthers, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disableNetwork(int netId, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(19, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().disableNetwork(netId, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoinGlobal(boolean choice) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(choice ? 1 : 0);
                    boolean _status = this.mRemote.transact(20, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().allowAutojoinGlobal(choice);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoin(int netId, boolean choice) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeInt(choice ? 1 : 0);
                    boolean _status = this.mRemote.transact(21, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().allowAutojoin(netId, choice);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void allowAutojoinPasspoint(String fqdn, boolean enableAutoJoin) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(enableAutoJoin ? 1 : 0);
                    boolean _status = this.mRemote.transact(22, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().allowAutojoinPasspoint(fqdn, enableAutoJoin);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(23, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setMacRandomizationSettingPasspointEnabled(fqdn, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setPasspointMeteredOverride(String fqdn, int meteredOverride) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(fqdn);
                    _data.writeInt(meteredOverride);
                    boolean _status = this.mRemote.transact(24, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setPasspointMeteredOverride(fqdn, meteredOverride);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startScan(String packageName, String featureId) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(25, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startScan(packageName, featureId);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<ScanResult> getScanResults(String callingPackage, String callingFeatureId) throws RemoteException {
                ArrayList<ScanResult> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(26, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<ScanResult> list = Stub.getDefaultImpl().getScanResults(callingPackage, callingFeatureId);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(ScanResult.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean disconnect(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(27, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().disconnect(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reconnect(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(28, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().reconnect(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean reassociate(String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(29, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().reassociate(packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiInfo getConnectionInfo(String callingPackage, String callingFeatureId) throws RemoteException {
                WifiInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(30, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WifiInfo wifiInfo = Stub.getDefaultImpl().getConnectionInfo(callingPackage, callingFeatureId);
                        return wifiInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiEnabled(String packageName, boolean enable) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(31, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiEnabled(packageName, enable);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(32, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getWifiEnabledState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCountryCode() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(33, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCountryCode();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setOverrideCountryCode(String country) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(country);
                    boolean _status = this.mRemote.transact(34, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setOverrideCountryCode(country);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearOverrideCountryCode() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(35, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearOverrideCountryCode();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDefaultCountryCode(String country) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(country);
                    boolean _status = this.mRemote.transact(36, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDefaultCountryCode(country);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is24GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(37, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is24GHzBandSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is5GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(38, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is5GHzBandSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is6GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(39, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is6GHzBandSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean is60GHzBandSupported() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(40, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().is60GHzBandSupported();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isWifiStandardSupported(int standard) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(standard);
                    boolean _status = this.mRemote.transact(41, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isWifiStandardSupported(standard);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public DhcpInfo getDhcpInfo(String packageName) throws RemoteException {
                DhcpInfo _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(42, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        DhcpInfo dhcpInfo = Stub.getDefaultImpl().getDhcpInfo(packageName);
                        return dhcpInfo;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? DhcpInfo.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanAlwaysAvailable(boolean isAvailable, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(isAvailable ? 1 : 0);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(43, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setScanAlwaysAvailable(isAvailable, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanAlwaysAvailable() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(44, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isScanAlwaysAvailable();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    _data.writeInt(lockType);
                    _data.writeString(tag);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(45, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().acquireWifiLock(lock, lockType, tag, ws);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    if (ws != null) {
                        _data.writeInt(1);
                        ws.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(46, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateWifiLockWorkSource(lock, ws);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean releaseWifiLock(IBinder lock) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(lock);
                    boolean _status = this.mRemote.transact(47, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().releaseWifiLock(lock);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void initializeMulticastFiltering() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(48, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().initializeMulticastFiltering();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isMulticastEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(49, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isMulticastEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(50, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().acquireMulticastLock(binder, tag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void releaseMulticastLock(String tag) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(tag);
                    boolean _status = this.mRemote.transact(51, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().releaseMulticastLock(tag);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(ifaceName);
                    _data.writeInt(mode);
                    boolean _status = this.mRemote.transact(52, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateInterfaceIpState(ifaceName, mode);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isDefaultCoexAlgorithmEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(53, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isDefaultCoexAlgorithmEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCoexUnsafeChannels(List<CoexUnsafeChannel> unsafeChannels, int mandatoryRestrictions) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(unsafeChannels);
                    _data.writeInt(mandatoryRestrictions);
                    boolean _status = this.mRemote.transact(54, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCoexUnsafeChannels(unsafeChannels, mandatoryRestrictions);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerCoexCallback(ICoexCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(55, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerCoexCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterCoexCallback(ICoexCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(56, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterCoexCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startSoftAp(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(57, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startSoftAp(wifiConfig, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean startTetheredHotspot(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (softApConfig != null) {
                        _data.writeInt(1);
                        softApConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(58, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().startTetheredHotspot(softApConfig, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean stopSoftAp() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(59, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().stopSoftAp();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback callback, String packageName, String featureId, SoftApConfiguration customConfig) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    if (customConfig != null) {
                        _data.writeInt(1);
                        customConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    boolean _status = this.mRemote.transact(60, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().startLocalOnlyHotspot(callback, packageName, featureId, customConfig);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(61, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopLocalOnlyHotspot();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(62, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startWatchLocalOnlyHotspot(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopWatchLocalOnlyHotspot() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(63, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopWatchLocalOnlyHotspot();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getWifiApEnabledState() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(64, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getWifiApEnabledState();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public WifiConfiguration getWifiApConfiguration() throws RemoteException {
                WifiConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(65, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        WifiConfiguration wifiConfiguration = Stub.getDefaultImpl().getWifiApConfiguration();
                        return wifiConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? WifiConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration getSoftApConfiguration() throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(66, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SoftApConfiguration softApConfiguration = Stub.getDefaultImpl().getSoftApConfiguration();
                        return softApConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (wifiConfig != null) {
                        _data.writeInt(1);
                        wifiConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(67, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiApConfiguration(wifiConfig, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setSoftApConfiguration(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (softApConfig != null) {
                        _data.writeInt(1);
                        softApConfig.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(68, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setSoftApConfiguration(softApConfig, packageName);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void notifyUserOfApBandConversion(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(69, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().notifyUserOfApBandConversion(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteIPAddress);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(70, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableTdls(remoteIPAddress, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(remoteMacAddress);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(71, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableTdlsWithMacAddress(remoteMacAddress, enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
                String _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(72, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String string2 = Stub.getDefaultImpl().getCurrentNetworkWpsNfcConfigurationToken();
                        return string2;
                    }
                    _reply.readException();
                    _result = _reply.readString();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void enableVerboseLogging(int verbose) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(verbose);
                    boolean _status = this.mRemote.transact(73, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().enableVerboseLogging(verbose);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int getVerboseLoggingLevel() throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(74, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().getVerboseLoggingLevel();
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(SSID);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(75, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().disableEphemeralNetwork(SSID, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void factoryReset(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(76, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().factoryReset(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Network getCurrentNetwork() throws RemoteException {
                Network _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(77, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Network network = Stub.getDefaultImpl().getCurrentNetwork();
                        return network;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? Network.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] retrieveBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(78, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().retrieveBackupData();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreBackupData(byte[] data) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(79, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restoreBackupData(data);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] retrieveSoftApBackupData() throws RemoteException {
                byte[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(80, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        byte[] byArray = Stub.getDefaultImpl().retrieveSoftApBackupData();
                        return byArray;
                    }
                    _reply.readException();
                    _result = _reply.createByteArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public SoftApConfiguration restoreSoftApBackupData(byte[] data) throws RemoteException {
                SoftApConfiguration _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(data);
                    boolean _status = this.mRemote.transact(81, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        SoftApConfiguration softApConfiguration = Stub.getDefaultImpl().restoreSoftApBackupData(data);
                        return softApConfiguration;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt() ? SoftApConfiguration.CREATOR.createFromParcel(_reply) : null;
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeByteArray(supplicantData);
                    _data.writeByteArray(ipConfigData);
                    boolean _status = this.mRemote.transact(82, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restoreSupplicantBackupData(supplicantData, ipConfigData);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (provider != null) {
                        _data.writeInt(1);
                        provider.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(83, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startSubscriptionProvisioning(provider, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSoftApCallback(ISoftApCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(84, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSoftApCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSoftApCallback(ISoftApCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(85, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSoftApCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(86, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addWifiVerboseLoggingStatusChangedListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(87, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeWifiVerboseLoggingStatusChangedListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(88, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addOnWifiUsabilityStatsListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(89, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeOnWifiUsabilityStatsListener(listener);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(90, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerTrafficStateCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(91, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterTrafficStateCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(92, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerNetworkRequestMatchCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(93, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterNetworkRequestMatchCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, String featureId) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networkSuggestions);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(94, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().addNetworkSuggestions(networkSuggestions, packageName, featureId);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networkSuggestions);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(95, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().removeNetworkSuggestions(networkSuggestions, packageName);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiNetworkSuggestion> getNetworkSuggestions(String packageName) throws RemoteException {
                ArrayList<WifiNetworkSuggestion> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(96, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiNetworkSuggestion> list = Stub.getDefaultImpl().getNetworkSuggestions(packageName);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiNetworkSuggestion.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public String[] getFactoryMacAddresses() throws RemoteException {
                String[] _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(97, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        String[] stringArray = Stub.getDefaultImpl().getFactoryMacAddresses();
                        return stringArray;
                    }
                    _reply.readException();
                    _result = _reply.createStringArray();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setDeviceMobilityState(int state) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(state);
                    boolean _status = this.mRemote.transact(98, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setDeviceMobilityState(state);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsConfiguratorInitiator(IBinder binder, String packageName, String enrolleeUri, int selectedNetworkId, int netRole, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(packageName);
                    _data.writeString(enrolleeUri);
                    _data.writeInt(selectedNetworkId);
                    _data.writeInt(netRole);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(99, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startDppAsConfiguratorInitiator(binder, packageName, enrolleeUri, selectedNetworkId, netRole, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsEnrolleeInitiator(IBinder binder, String configuratorUri, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(configuratorUri);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(100, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startDppAsEnrolleeInitiator(binder, configuratorUri, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startDppAsEnrolleeResponder(IBinder binder, String deviceInfo, int curve, IDppCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeString(deviceInfo);
                    _data.writeInt(curve);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(101, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startDppAsEnrolleeResponder(binder, deviceInfo, curve, callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopDppSession() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(102, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopDppSession();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(seqNum);
                    _data.writeInt(score);
                    _data.writeInt(predictionHorizonSec);
                    boolean _status = this.mRemote.transact(103, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateWifiUsabilityScore(seqNum, score, predictionHorizonSec);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void connect(WifiConfiguration config, int netId, IActionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(netId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(104, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().connect(config, netId, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void save(WifiConfiguration config, IActionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (config != null) {
                        _data.writeInt(1);
                        config.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(105, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().save(config, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void forget(int netId, IActionListener listener) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(netId);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    boolean _status = this.mRemote.transact(106, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().forget(netId, listener);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(107, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerScanResultsCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(108, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterScanResultsCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName, String featureId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    _data.writeString(featureId);
                    boolean _status = this.mRemote.transact(109, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSuggestionConnectionStatusListener(listener, packageName, featureId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(110, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSuggestionConnectionStatusListener(listener, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int calculateSignalLevel(int rssi) throws RemoteException {
                int _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(rssi);
                    boolean _status = this.mRemote.transact(111, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        int n = Stub.getDefaultImpl().calculateSignalLevel(rssi);
                        return n;
                    }
                    _reply.readException();
                    _result = _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) throws RemoteException {
                ArrayList<WifiConfiguration> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResults);
                    boolean _status = this.mRemote.transact(112, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiConfiguration> list = Stub.getDefaultImpl().getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(scanResults);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiConfiguration.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiConnectedNetworkScorer(IBinder binder, IWifiConnectedNetworkScorer scorer) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(binder);
                    _data.writeStrongBinder(scorer != null ? scorer.asBinder() : null);
                    boolean _status = this.mRemote.transact(113, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiConnectedNetworkScorer(binder, scorer);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clearWifiConnectedNetworkScorer() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(114, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().clearWifiConnectedNetworkScorer();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestions, List<ScanResult> scanResults, String callingPackage, String callingFeatureId) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(networkSuggestions);
                    _data.writeTypedList(scanResults);
                    _data.writeString(callingPackage);
                    _data.writeString(callingFeatureId);
                    boolean _status = this.mRemote.transact(115, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getMatchingScanResults(networkSuggestions, scanResults, callingPackage, callingFeatureId);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setScanThrottleEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(116, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setScanThrottleEnabled(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isScanThrottleEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(117, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isScanThrottleEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> scanResult) throws RemoteException {
                HashMap _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeTypedList(scanResult);
                    boolean _status = this.mRemote.transact(118, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Map map = Stub.getDefaultImpl().getAllMatchingPasspointProfilesForScanResults(scanResult);
                        return map;
                    }
                    _reply.readException();
                    ClassLoader cl = this.getClass().getClassLoader();
                    _result = _reply.readHashMap(cl);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setAutoWakeupEnabled(boolean enable) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enable ? 1 : 0);
                    boolean _status = this.mRemote.transact(119, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setAutoWakeupEnabled(enable);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isAutoWakeupEnabled() throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(120, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isAutoWakeupEnabled();
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void startRestrictingAutoJoinToSubscriptionId(int subId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subId);
                    boolean _status = this.mRemote.transact(121, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().startRestrictingAutoJoinToSubscriptionId(subId);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stopRestrictingAutoJoinToSubscriptionId() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(122, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().stopRestrictingAutoJoinToSubscriptionId();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subscriptionId);
                    _data.writeInt(merged ? 1 : 0);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(123, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setCarrierNetworkOffloadEnabled(subscriptionId, merged, enabled);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(subscriptionId);
                    _data.writeInt(merged ? 1 : 0);
                    boolean _status = this.mRemote.transact(124, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().isCarrierNetworkOffloadEnabled(subscriptionId, merged);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(125, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerSubsystemRestartCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    boolean _status = this.mRemote.transact(126, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterSubsystemRestartCallback(callback);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void restartWifiSubsystem() throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(127, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().restartWifiSubsystem();
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void addSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(128, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().addSuggestionUserApprovalStatusListener(listener, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeStrongBinder(listener != null ? listener.asBinder() : null);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(129, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeSuggestionUserApprovalStatusListener(listener, packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void setEmergencyScanRequestInProgress(boolean inProgress) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(inProgress ? 1 : 0);
                    boolean _status = this.mRemote.transact(130, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().setEmergencyScanRequestInProgress(inProgress);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeAppState(int targetAppUid, String targetApppackageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(targetAppUid);
                    _data.writeString(targetApppackageName);
                    boolean _status = this.mRemote.transact(131, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().removeAppState(targetAppUid, targetApppackageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean setWifiScoringEnabled(boolean enabled) throws RemoteException {
                boolean _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(enabled ? 1 : 0);
                    boolean _status = this.mRemote.transact(132, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        boolean bl = Stub.getDefaultImpl().setWifiScoringEnabled(enabled);
                        return bl;
                    }
                    _reply.readException();
                    _result = 0 != _reply.readInt();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void flushPasspointAnqpCache(String packageName) throws RemoteException {
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeString(packageName);
                    boolean _status = this.mRemote.transact(133, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().flushPasspointAnqpCache(packageName);
                        return;
                    }
                    _reply.readException();
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public List<WifiAvailableChannel> getUsableChannels(int band, int mode, int filter) throws RemoteException {
                ArrayList<WifiAvailableChannel> _result;
                Parcel _data = Parcel.obtain();
                Parcel _reply = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(Stub.DESCRIPTOR);
                    _data.writeInt(band);
                    _data.writeInt(mode);
                    _data.writeInt(filter);
                    boolean _status = this.mRemote.transact(134, _data, _reply, 0);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        List<WifiAvailableChannel> list = Stub.getDefaultImpl().getUsableChannels(band, mode, filter);
                        return list;
                    }
                    _reply.readException();
                    _result = _reply.createTypedArrayList(WifiAvailableChannel.CREATOR);
                }
                finally {
                    _reply.recycle();
                    _data.recycle();
                }
                return _result;
            }
        }
    }

    public static class Default
    implements IWifiManager {
        @Override
        public long getSupportedFeatures() throws RemoteException {
            return 0L;
        }

        @Override
        public void getWifiActivityEnergyInfoAsync(IOnWifiActivityEnergyInfoListener listener) throws RemoteException {
        }

        @Override
        public ParceledListSlice getConfiguredNetworks(String packageName, String featureId, boolean callerNetworksOnly) throws RemoteException {
            return null;
        }

        @Override
        public ParceledListSlice getPrivilegedConfiguredNetworks(String packageName, String featureId) throws RemoteException {
            return null;
        }

        @Override
        public Map getAllMatchingFqdnsForScanResults(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public Map getMatchingOsuProviders(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public Map getMatchingPasspointConfigsForOsuProviders(List<OsuProvider> osuProviders) throws RemoteException {
            return null;
        }

        @Override
        public int addOrUpdateNetwork(WifiConfiguration config, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public WifiManager.AddNetworkResult addOrUpdateNetworkPrivileged(WifiConfiguration config, String packageName) throws RemoteException {
            return null;
        }

        @Override
        public boolean addOrUpdatePasspointConfiguration(PasspointConfiguration config, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removePasspointConfiguration(String fqdn, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public List<PasspointConfiguration> getPasspointConfigurations(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public List<WifiConfiguration> getWifiConfigsForPasspointProfiles(List<String> fqdnList) throws RemoteException {
            return null;
        }

        @Override
        public void queryPasspointIcon(long bssid, String fileName) throws RemoteException {
        }

        @Override
        public int matchProviderWithCurrentNetwork(String fqdn) throws RemoteException {
            return 0;
        }

        @Override
        public boolean removeNetwork(int netId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean removeNonCallerConfiguredNetworks(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean enableNetwork(int netId, boolean disableOthers, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean disableNetwork(int netId, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void allowAutojoinGlobal(boolean choice) throws RemoteException {
        }

        @Override
        public void allowAutojoin(int netId, boolean choice) throws RemoteException {
        }

        @Override
        public void allowAutojoinPasspoint(String fqdn, boolean enableAutoJoin) throws RemoteException {
        }

        @Override
        public void setMacRandomizationSettingPasspointEnabled(String fqdn, boolean enable) throws RemoteException {
        }

        @Override
        public void setPasspointMeteredOverride(String fqdn, int meteredOverride) throws RemoteException {
        }

        @Override
        public boolean startScan(String packageName, String featureId) throws RemoteException {
            return false;
        }

        @Override
        public List<ScanResult> getScanResults(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean disconnect(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean reconnect(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean reassociate(String packageName) throws RemoteException {
            return false;
        }

        @Override
        public WifiInfo getConnectionInfo(String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiEnabled(String packageName, boolean enable) throws RemoteException {
            return false;
        }

        @Override
        public int getWifiEnabledState() throws RemoteException {
            return 0;
        }

        @Override
        public String getCountryCode() throws RemoteException {
            return null;
        }

        @Override
        public void setOverrideCountryCode(String country) throws RemoteException {
        }

        @Override
        public void clearOverrideCountryCode() throws RemoteException {
        }

        @Override
        public void setDefaultCountryCode(String country) throws RemoteException {
        }

        @Override
        public boolean is24GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is5GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is6GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean is60GHzBandSupported() throws RemoteException {
            return false;
        }

        @Override
        public boolean isWifiStandardSupported(int standard) throws RemoteException {
            return false;
        }

        @Override
        public DhcpInfo getDhcpInfo(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public void setScanAlwaysAvailable(boolean isAvailable, String packageName) throws RemoteException {
        }

        @Override
        public boolean isScanAlwaysAvailable() throws RemoteException {
            return false;
        }

        @Override
        public boolean acquireWifiLock(IBinder lock, int lockType, String tag, WorkSource ws) throws RemoteException {
            return false;
        }

        @Override
        public void updateWifiLockWorkSource(IBinder lock, WorkSource ws) throws RemoteException {
        }

        @Override
        public boolean releaseWifiLock(IBinder lock) throws RemoteException {
            return false;
        }

        @Override
        public void initializeMulticastFiltering() throws RemoteException {
        }

        @Override
        public boolean isMulticastEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void acquireMulticastLock(IBinder binder, String tag) throws RemoteException {
        }

        @Override
        public void releaseMulticastLock(String tag) throws RemoteException {
        }

        @Override
        public void updateInterfaceIpState(String ifaceName, int mode) throws RemoteException {
        }

        @Override
        public boolean isDefaultCoexAlgorithmEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void setCoexUnsafeChannels(List<CoexUnsafeChannel> unsafeChannels, int mandatoryRestrictions) throws RemoteException {
        }

        @Override
        public void registerCoexCallback(ICoexCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterCoexCallback(ICoexCallback callback) throws RemoteException {
        }

        @Override
        public boolean startSoftAp(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean startTetheredHotspot(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean stopSoftAp() throws RemoteException {
            return false;
        }

        @Override
        public int startLocalOnlyHotspot(ILocalOnlyHotspotCallback callback, String packageName, String featureId, SoftApConfiguration customConfig) throws RemoteException {
            return 0;
        }

        @Override
        public void stopLocalOnlyHotspot() throws RemoteException {
        }

        @Override
        public void startWatchLocalOnlyHotspot(ILocalOnlyHotspotCallback callback) throws RemoteException {
        }

        @Override
        public void stopWatchLocalOnlyHotspot() throws RemoteException {
        }

        @Override
        public int getWifiApEnabledState() throws RemoteException {
            return 0;
        }

        @Override
        public WifiConfiguration getWifiApConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public SoftApConfiguration getSoftApConfiguration() throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiApConfiguration(WifiConfiguration wifiConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public boolean setSoftApConfiguration(SoftApConfiguration softApConfig, String packageName) throws RemoteException {
            return false;
        }

        @Override
        public void notifyUserOfApBandConversion(String packageName) throws RemoteException {
        }

        @Override
        public void enableTdls(String remoteIPAddress, boolean enable) throws RemoteException {
        }

        @Override
        public void enableTdlsWithMacAddress(String remoteMacAddress, boolean enable) throws RemoteException {
        }

        @Override
        public String getCurrentNetworkWpsNfcConfigurationToken() throws RemoteException {
            return null;
        }

        @Override
        public void enableVerboseLogging(int verbose) throws RemoteException {
        }

        @Override
        public int getVerboseLoggingLevel() throws RemoteException {
            return 0;
        }

        @Override
        public void disableEphemeralNetwork(String SSID, String packageName) throws RemoteException {
        }

        @Override
        public void factoryReset(String packageName) throws RemoteException {
        }

        @Override
        public Network getCurrentNetwork() throws RemoteException {
            return null;
        }

        @Override
        public byte[] retrieveBackupData() throws RemoteException {
            return null;
        }

        @Override
        public void restoreBackupData(byte[] data) throws RemoteException {
        }

        @Override
        public byte[] retrieveSoftApBackupData() throws RemoteException {
            return null;
        }

        @Override
        public SoftApConfiguration restoreSoftApBackupData(byte[] data) throws RemoteException {
            return null;
        }

        @Override
        public void restoreSupplicantBackupData(byte[] supplicantData, byte[] ipConfigData) throws RemoteException {
        }

        @Override
        public void startSubscriptionProvisioning(OsuProvider provider, IProvisioningCallback callback) throws RemoteException {
        }

        @Override
        public void registerSoftApCallback(ISoftApCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSoftApCallback(ISoftApCallback callback) throws RemoteException {
        }

        @Override
        public void addWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
        }

        @Override
        public void removeWifiVerboseLoggingStatusChangedListener(IWifiVerboseLoggingStatusChangedListener listener) throws RemoteException {
        }

        @Override
        public void addOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
        }

        @Override
        public void removeOnWifiUsabilityStatsListener(IOnWifiUsabilityStatsListener listener) throws RemoteException {
        }

        @Override
        public void registerTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterTrafficStateCallback(ITrafficStateCallback callback) throws RemoteException {
        }

        @Override
        public void registerNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterNetworkRequestMatchCallback(INetworkRequestMatchCallback callback) throws RemoteException {
        }

        @Override
        public int addNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName, String featureId) throws RemoteException {
            return 0;
        }

        @Override
        public int removeNetworkSuggestions(List<WifiNetworkSuggestion> networkSuggestions, String packageName) throws RemoteException {
            return 0;
        }

        @Override
        public List<WifiNetworkSuggestion> getNetworkSuggestions(String packageName) throws RemoteException {
            return null;
        }

        @Override
        public String[] getFactoryMacAddresses() throws RemoteException {
            return null;
        }

        @Override
        public void setDeviceMobilityState(int state) throws RemoteException {
        }

        @Override
        public void startDppAsConfiguratorInitiator(IBinder binder, String packageName, String enrolleeUri, int selectedNetworkId, int netRole, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void startDppAsEnrolleeInitiator(IBinder binder, String configuratorUri, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void startDppAsEnrolleeResponder(IBinder binder, String deviceInfo, int curve, IDppCallback callback) throws RemoteException {
        }

        @Override
        public void stopDppSession() throws RemoteException {
        }

        @Override
        public void updateWifiUsabilityScore(int seqNum, int score, int predictionHorizonSec) throws RemoteException {
        }

        @Override
        public void connect(WifiConfiguration config, int netId, IActionListener listener) throws RemoteException {
        }

        @Override
        public void save(WifiConfiguration config, IActionListener listener) throws RemoteException {
        }

        @Override
        public void forget(int netId, IActionListener listener) throws RemoteException {
        }

        @Override
        public void registerScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterScanResultsCallback(IScanResultsCallback callback) throws RemoteException {
        }

        @Override
        public void registerSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName, String featureId) throws RemoteException {
        }

        @Override
        public void unregisterSuggestionConnectionStatusListener(ISuggestionConnectionStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public int calculateSignalLevel(int rssi) throws RemoteException {
            return 0;
        }

        @Override
        public List<WifiConfiguration> getWifiConfigForMatchedNetworkSuggestionsSharedWithUser(List<ScanResult> scanResults) throws RemoteException {
            return null;
        }

        @Override
        public boolean setWifiConnectedNetworkScorer(IBinder binder, IWifiConnectedNetworkScorer scorer) throws RemoteException {
            return false;
        }

        @Override
        public void clearWifiConnectedNetworkScorer() throws RemoteException {
        }

        @Override
        public Map getMatchingScanResults(List<WifiNetworkSuggestion> networkSuggestions, List<ScanResult> scanResults, String callingPackage, String callingFeatureId) throws RemoteException {
            return null;
        }

        @Override
        public void setScanThrottleEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isScanThrottleEnabled() throws RemoteException {
            return false;
        }

        @Override
        public Map getAllMatchingPasspointProfilesForScanResults(List<ScanResult> scanResult) throws RemoteException {
            return null;
        }

        @Override
        public void setAutoWakeupEnabled(boolean enable) throws RemoteException {
        }

        @Override
        public boolean isAutoWakeupEnabled() throws RemoteException {
            return false;
        }

        @Override
        public void startRestrictingAutoJoinToSubscriptionId(int subId) throws RemoteException {
        }

        @Override
        public void stopRestrictingAutoJoinToSubscriptionId() throws RemoteException {
        }

        @Override
        public void setCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged, boolean enabled) throws RemoteException {
        }

        @Override
        public boolean isCarrierNetworkOffloadEnabled(int subscriptionId, boolean merged) throws RemoteException {
            return false;
        }

        @Override
        public void registerSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
        }

        @Override
        public void unregisterSubsystemRestartCallback(ISubsystemRestartCallback callback) throws RemoteException {
        }

        @Override
        public void restartWifiSubsystem() throws RemoteException {
        }

        @Override
        public void addSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void removeSuggestionUserApprovalStatusListener(ISuggestionUserApprovalStatusListener listener, String packageName) throws RemoteException {
        }

        @Override
        public void setEmergencyScanRequestInProgress(boolean inProgress) throws RemoteException {
        }

        @Override
        public void removeAppState(int targetAppUid, String targetApppackageName) throws RemoteException {
        }

        @Override
        public boolean setWifiScoringEnabled(boolean enabled) throws RemoteException {
            return false;
        }

        @Override
        public void flushPasspointAnqpCache(String packageName) throws RemoteException {
        }

        @Override
        public List<WifiAvailableChannel> getUsableChannels(int band, int mode, int filter) throws RemoteException {
            return null;
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

