/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.BatteryConsumer;
import android.os.BatteryUsageStats;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.PowerComponents;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import java.io.IOException;
import java.io.PrintWriter;
import org.xmlpull.v1.XmlPullParserException;

public class AggregateBatteryConsumer
extends BatteryConsumer
implements Parcelable {
    private final double mConsumedPowerMah;
    public static final Parcelable.Creator<AggregateBatteryConsumer> CREATOR = new Parcelable.Creator<AggregateBatteryConsumer>(){

        @Override
        public AggregateBatteryConsumer createFromParcel(Parcel source) {
            return new AggregateBatteryConsumer(source);
        }

        public AggregateBatteryConsumer[] newArray(int size) {
            return new AggregateBatteryConsumer[size];
        }
    };

    public AggregateBatteryConsumer(Builder builder) {
        super(builder.mPowerComponentsBuilder.build());
        this.mConsumedPowerMah = builder.mConsumedPowerMah;
    }

    private AggregateBatteryConsumer(Parcel source) {
        super(new PowerComponents(source));
        this.mConsumedPowerMah = source.readDouble();
    }

    @Override
    public void dump(PrintWriter pw, boolean skipEmptyComponents) {
        this.mPowerComponents.dump(pw, skipEmptyComponents);
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        super.writeToParcel(dest, flags);
        dest.writeDouble(this.mConsumedPowerMah);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public double getConsumedPower() {
        return this.mConsumedPowerMah;
    }

    void writeToXml(TypedXmlSerializer serializer, int scope) throws IOException {
        serializer.startTag(null, "aggregate");
        serializer.attributeInt(null, "scope", scope);
        serializer.attributeDouble(null, "power", this.mConsumedPowerMah);
        this.mPowerComponents.writeToXml(serializer);
        serializer.endTag(null, "aggregate");
    }

    static void parseXml(TypedXmlPullParser parser, BatteryUsageStats.Builder builder) throws XmlPullParserException, IOException {
        int scope = parser.getAttributeInt(null, "scope");
        Builder consumerBuilder = builder.getAggregateBatteryConsumerBuilder(scope);
        int eventType = parser.getEventType();
        if (eventType != 2 || !parser.getName().equals("aggregate")) {
            throw new XmlPullParserException("Invalid XML parser state");
        }
        consumerBuilder.setConsumedPower(parser.getAttributeDouble(null, "power"));
        while (!(eventType == 3 && parser.getName().equals("aggregate") || eventType == 1)) {
            if (eventType == 2 && parser.getName().equals("power_components")) {
                PowerComponents.parseXml(parser, consumerBuilder.mPowerComponentsBuilder);
            }
            eventType = parser.next();
        }
    }

    public static class Builder
    extends BatteryConsumer.BaseBuilder<Builder> {
        private double mConsumedPowerMah;

        public Builder(String[] customPowerComponentNames, boolean includePowerModels) {
            super(customPowerComponentNames, includePowerModels);
        }

        public Builder setConsumedPower(double consumedPowerMah) {
            this.mConsumedPowerMah = consumedPowerMah;
            return this;
        }

        public void add(AggregateBatteryConsumer aggregateBatteryConsumer) {
            this.mConsumedPowerMah += aggregateBatteryConsumer.mConsumedPowerMah;
            this.mPowerComponentsBuilder.addPowerAndDuration(aggregateBatteryConsumer.mPowerComponents);
        }

        public AggregateBatteryConsumer build() {
            return new AggregateBatteryConsumer(this);
        }
    }
}

