/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.RequiresPermission;
import android.annotation.SystemApi;
import android.app.ActivityThread;
import android.app.Application;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.IDeviceIdentifiersPolicyService;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.os.VintfObject;
import android.sysprop.DeviceProperties;
import android.sysprop.SocProperties;
import android.sysprop.TelephonyProperties;
import android.text.TextUtils;
import android.util.Slog;
import dalvik.system.VMRuntime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class _Original_Build {
    private static final String TAG = "Build";
    public static final String UNKNOWN = "unknown";
    public static final String ID = _Original_Build.getString("ro.build.id");
    public static final String DISPLAY = _Original_Build.getString("ro.build.display.id");
    public static final String PRODUCT = _Original_Build.getString("ro.product.name");
    public static final String DEVICE = _Original_Build.getString("ro.product.device");
    public static final String BOARD = _Original_Build.getString("ro.product.board");
    @Deprecated
    public static final String CPU_ABI;
    @Deprecated
    public static final String CPU_ABI2;
    public static final String MANUFACTURER;
    public static final String BRAND;
    public static final String MODEL;
    public static final String SOC_MANUFACTURER;
    public static final String SOC_MODEL;
    public static final String BOOTLOADER;
    @Deprecated
    public static final String RADIO;
    public static final String HARDWARE;
    public static final String SKU;
    public static final String ODM_SKU;
    @UnsupportedAppUsage
    public static final boolean IS_EMULATOR;
    @Deprecated
    public static final String SERIAL;
    public static final String[] SUPPORTED_ABIS;
    public static final String[] SUPPORTED_32_BIT_ABIS;
    public static final String[] SUPPORTED_64_BIT_ABIS;
    public static final String TYPE;
    public static final String TAGS;
    public static final String FINGERPRINT;
    public static final int HW_TIMEOUT_MULTIPLIER;
    public static final boolean IS_TREBLE_ENABLED;
    public static final long TIME;
    public static final String USER;
    public static final String HOST;
    @UnsupportedAppUsage
    public static final boolean IS_DEBUGGABLE;
    public static final boolean IS_ENG;
    public static final boolean IS_USERDEBUG;
    public static final boolean IS_USER;
    public static final boolean IS_CONTAINER;
    @SystemApi
    public static final boolean PERMISSIONS_REVIEW_REQUIRED = true;

    @RequiresPermission(value="android.permission.READ_PRIVILEGED_PHONE_STATE")
    public static String getSerial() {
        IDeviceIdentifiersPolicyService service = IDeviceIdentifiersPolicyService.Stub.asInterface(ServiceManager.getService("device_identifiers"));
        try {
            Application application = ActivityThread.currentApplication();
            String callingPackage = application != null ? application.getPackageName() : null;
            return service.getSerialForPackage(callingPackage, null);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return UNKNOWN;
        }
    }

    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitAbi(abi);
    }

    private static String deriveFingerprint() {
        String finger = SystemProperties.get("ro.build.fingerprint");
        if (TextUtils.isEmpty(finger)) {
            finger = _Original_Build.getString("ro.product.brand") + '/' + _Original_Build.getString("ro.product.name") + '/' + _Original_Build.getString("ro.product.device") + ':' + _Original_Build.getString("ro.build.version.release") + '/' + _Original_Build.getString("ro.build.id") + '/' + _Original_Build.getString("ro.build.version.incremental") + ':' + _Original_Build.getString("ro.build.type") + '/' + _Original_Build.getString("ro.build.tags");
        }
        return finger;
    }

    public static void ensureFingerprintProperty() {
        if (TextUtils.isEmpty(SystemProperties.get("ro.build.fingerprint"))) {
            try {
                SystemProperties.set("ro.build.fingerprint", FINGERPRINT);
            }
            catch (IllegalArgumentException e) {
                Slog.e(TAG, "Failed to set fingerprint property", e);
            }
        }
    }

    public static boolean isBuildConsistent() {
        if (IS_ENG) {
            return true;
        }
        if (IS_TREBLE_ENABLED) {
            int result = VintfObject.verifyWithoutAvb();
            if (result != 0) {
                Slog.e(TAG, "Vendor interface is incompatible, error=" + String.valueOf(result));
            }
            return result == 0;
        }
        String system = SystemProperties.get("ro.system.build.fingerprint");
        String vendor = SystemProperties.get("ro.vendor.build.fingerprint");
        String bootimage = SystemProperties.get("ro.bootimage.build.fingerprint");
        String requiredBootloader = SystemProperties.get("ro.build.expect.bootloader");
        String currentBootloader = SystemProperties.get("ro.bootloader");
        String requiredRadio = SystemProperties.get("ro.build.expect.baseband");
        String currentRadio = _Original_Build.joinListOrElse(TelephonyProperties.baseband_version(), "");
        if (TextUtils.isEmpty(system)) {
            Slog.e(TAG, "Required ro.system.build.fingerprint is empty!");
            return false;
        }
        if (!TextUtils.isEmpty(vendor) && !Objects.equals(system, vendor)) {
            Slog.e(TAG, "Mismatched fingerprints; system reported " + system + " but vendor reported " + vendor);
            return false;
        }
        return true;
    }

    public static List<Partition> getFingerprintedPartitions() {
        String[] names;
        ArrayList<Partition> partitions = new ArrayList<Partition>();
        for (String name : names = new String[]{"bootimage", "odm", "product", "system_ext", "system", "vendor"}) {
            String fingerprint = SystemProperties.get("ro." + name + ".build.fingerprint");
            if (TextUtils.isEmpty(fingerprint)) continue;
            long time = _Original_Build.getLong("ro." + name + ".build.date.utc") * 1000L;
            partitions.add(new Partition(name, fingerprint, time));
        }
        return partitions;
    }

    @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
    public static boolean isDebuggable() {
        return IS_DEBUGGABLE;
    }

    public static String getRadioVersion() {
        return _Original_Build.joinListOrElse(TelephonyProperties.baseband_version(), null);
    }

    @UnsupportedAppUsage
    private static String getString(String property) {
        return SystemProperties.get(property, UNKNOWN);
    }

    private static String[] getStringList(String property, String separator) {
        String value = SystemProperties.get(property);
        if (value.isEmpty()) {
            return new String[0];
        }
        return value.split(separator);
    }

    @UnsupportedAppUsage
    private static long getLong(String property) {
        try {
            return Long.parseLong(SystemProperties.get(property));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static <T> String joinListOrElse(List<T> list, String defaultValue) {
        String ret = list.stream().map(elem -> elem == null ? "" : elem.toString()).collect(Collectors.joining(","));
        return ret.isEmpty() ? defaultValue : ret;
    }

    static /* synthetic */ String access$000(String x0) {
        return _Original_Build.getString(x0);
    }

    static /* synthetic */ String[] access$100(String x0, String x1) {
        return _Original_Build.getStringList(x0, x1);
    }

    static {
        MANUFACTURER = _Original_Build.getString("ro.product.manufacturer");
        BRAND = _Original_Build.getString("ro.product.brand");
        MODEL = _Original_Build.getString("ro.product.model");
        SOC_MANUFACTURER = SocProperties.soc_manufacturer().orElse(UNKNOWN);
        SOC_MODEL = SocProperties.soc_model().orElse(UNKNOWN);
        BOOTLOADER = _Original_Build.getString("ro.bootloader");
        RADIO = _Original_Build.joinListOrElse(TelephonyProperties.baseband_version(), UNKNOWN);
        HARDWARE = _Original_Build.getString("ro.hardware");
        SKU = _Original_Build.getString("ro.boot.hardware.sku");
        ODM_SKU = _Original_Build.getString("ro.boot.product.hardware.sku");
        IS_EMULATOR = _Original_Build.getString("ro.boot.qemu").equals("1");
        SERIAL = _Original_Build.getString("no.such.thing");
        SUPPORTED_ABIS = _Original_Build.getStringList("ro.product.cpu.abilist", ",");
        SUPPORTED_32_BIT_ABIS = _Original_Build.getStringList("ro.product.cpu.abilist32", ",");
        SUPPORTED_64_BIT_ABIS = _Original_Build.getStringList("ro.product.cpu.abilist64", ",");
        String[] abiList = VMRuntime.getRuntime().is64Bit() ? SUPPORTED_64_BIT_ABIS : SUPPORTED_32_BIT_ABIS;
        CPU_ABI = abiList[0];
        CPU_ABI2 = abiList.length > 1 ? abiList[1] : "";
        TYPE = _Original_Build.getString("ro.build.type");
        TAGS = _Original_Build.getString("ro.build.tags");
        FINGERPRINT = _Original_Build.deriveFingerprint();
        HW_TIMEOUT_MULTIPLIER = SystemProperties.getInt("ro.hw_timeout_multiplier", 1);
        IS_TREBLE_ENABLED = SystemProperties.getBoolean("ro.treble.enabled", false);
        TIME = _Original_Build.getLong("ro.build.date.utc") * 1000L;
        USER = _Original_Build.getString("ro.build.user");
        HOST = _Original_Build.getString("ro.build.host");
        IS_DEBUGGABLE = SystemProperties.getInt("ro.debuggable", 0) == 1;
        IS_ENG = "eng".equals(TYPE);
        IS_USERDEBUG = "userdebug".equals(TYPE);
        IS_USER = "user".equals(TYPE);
        IS_CONTAINER = SystemProperties.getBoolean("ro.boot.container", false);
    }

    public static class Partition {
        public static final String PARTITION_NAME_SYSTEM = "system";
        private final String mName;
        private final String mFingerprint;
        private final long mTimeMs;

        private Partition(String name, String fingerprint, long timeMs) {
            this.mName = name;
            this.mFingerprint = fingerprint;
            this.mTimeMs = timeMs;
        }

        public String getName() {
            return this.mName;
        }

        public String getFingerprint() {
            return this.mFingerprint;
        }

        public long getBuildTimeMillis() {
            return this.mTimeMs;
        }

        public boolean equals(Object o) {
            if (!(o instanceof Partition)) {
                return false;
            }
            Partition op = (Partition)o;
            return this.mName.equals(op.mName) && this.mFingerprint.equals(op.mFingerprint) && this.mTimeMs == op.mTimeMs;
        }

        public int hashCode() {
            return Objects.hash(this.mName, this.mFingerprint, this.mTimeMs);
        }
    }

    public static class VERSION_CODES {
        public static final int CUR_DEVELOPMENT = 10000;
        public static final int BASE = 1;
        public static final int BASE_1_1 = 2;
        public static final int CUPCAKE = 3;
        public static final int DONUT = 4;
        public static final int ECLAIR = 5;
        public static final int ECLAIR_0_1 = 6;
        public static final int ECLAIR_MR1 = 7;
        public static final int FROYO = 8;
        public static final int GINGERBREAD = 9;
        public static final int GINGERBREAD_MR1 = 10;
        public static final int HONEYCOMB = 11;
        public static final int HONEYCOMB_MR1 = 12;
        public static final int HONEYCOMB_MR2 = 13;
        public static final int ICE_CREAM_SANDWICH = 14;
        public static final int ICE_CREAM_SANDWICH_MR1 = 15;
        public static final int JELLY_BEAN = 16;
        public static final int JELLY_BEAN_MR1 = 17;
        public static final int JELLY_BEAN_MR2 = 18;
        public static final int KITKAT = 19;
        public static final int KITKAT_WATCH = 20;
        public static final int L = 21;
        public static final int LOLLIPOP = 21;
        public static final int LOLLIPOP_MR1 = 22;
        public static final int M = 23;
        public static final int N = 24;
        public static final int N_MR1 = 25;
        public static final int O = 26;
        public static final int O_MR1 = 27;
        public static final int P = 28;
        public static final int Q = 29;
        public static final int R = 30;
        public static final int S = 31;
    }

    public static class VERSION {
        public static final String INCREMENTAL = _Original_Build.access$000("ro.build.version.incremental");
        public static final String RELEASE = _Original_Build.access$000("ro.build.version.release");
        public static final String RELEASE_OR_CODENAME = _Original_Build.access$000("ro.build.version.release_or_codename");
        public static final String BASE_OS = SystemProperties.get("ro.build.version.base_os", "");
        public static final String SECURITY_PATCH = SystemProperties.get("ro.build.version.security_patch", "");
        public static final int MEDIA_PERFORMANCE_CLASS = DeviceProperties.media_performance_class().orElse(0);
        @Deprecated
        public static final String SDK = _Original_Build.access$000("ro.build.version.sdk");
        public static final int SDK_INT = SystemProperties.getInt("ro.build.version.sdk", 0);
        @SystemApi(client=SystemApi.Client.MODULE_LIBRARIES)
        public static final int DEVICE_INITIAL_SDK_INT = SystemProperties.getInt("ro.product.first_api_level", 0);
        public static final int PREVIEW_SDK_INT = SystemProperties.getInt("ro.build.version.preview_sdk", 0);
        @SystemApi
        public static final String PREVIEW_SDK_FINGERPRINT = SystemProperties.get("ro.build.version.preview_sdk_fingerprint", "REL");
        public static final String CODENAME = _Original_Build.access$000("ro.build.version.codename");
        private static final String[] ALL_CODENAMES = _Original_Build.access$100("ro.build.version.all_codenames", ",");
        @UnsupportedAppUsage
        public static final String[] ACTIVE_CODENAMES = "REL".equals(ALL_CODENAMES[0]) ? new String[]{} : ALL_CODENAMES;
        public static final int RESOURCES_SDK_INT = SDK_INT + ACTIVE_CODENAMES.length;
        public static final int MIN_SUPPORTED_TARGET_SDK_INT = SystemProperties.getInt("ro.build.version.min_supported_target_sdk", 0);
    }
}

