/*
 * Decompiled with CFR 0.152.
 */
package android.os.image;

import android.annotation.RequiresPermission;
import android.gsi.AvbPublicKey;
import android.gsi.GsiProgress;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.image.IDynamicSystemService;

public class DynamicSystemManager {
    private static final String TAG = "DynamicSystemManager";
    private final IDynamicSystemService mService;

    public DynamicSystemManager(IDynamicSystemService service) {
        this.mService = service;
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean startInstallation(String dsuSlot) {
        try {
            return this.mService.startInstallation(dsuSlot);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public Session createPartition(String name, long size, boolean readOnly) {
        try {
            if (this.mService.createPartition(name, size, readOnly)) {
                return new Session();
            }
            return null;
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean closePartition() {
        try {
            return this.mService.closePartition();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean finishInstallation() {
        try {
            return this.mService.finishInstallation();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public GsiProgress getInstallationProgress() {
        try {
            return this.mService.getInstallationProgress();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean abort() {
        try {
            return this.mService.abort();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean isInUse() {
        try {
            return this.mService.isInUse();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean isInstalled() {
        try {
            return this.mService.isInstalled();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean isEnabled() {
        try {
            return this.mService.isEnabled();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean remove() {
        try {
            return this.mService.remove();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public boolean setEnable(boolean enable, boolean oneShot) {
        try {
            return this.mService.setEnable(enable, oneShot);
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
    public long suggestScratchSize() {
        try {
            return this.mService.suggestScratchSize();
        }
        catch (RemoteException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public class Session {
        private Session() {
        }

        @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
        public boolean setAshmem(ParcelFileDescriptor ashmem, long size) {
            try {
                return DynamicSystemManager.this.mService.setAshmem(ashmem, size);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e.toString());
            }
        }

        @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
        public boolean submitFromAshmem(int size) {
            try {
                return DynamicSystemManager.this.mService.submitFromAshmem(size);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e.toString());
            }
        }

        @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
        public boolean getAvbPublicKey(AvbPublicKey dst) {
            try {
                return DynamicSystemManager.this.mService.getAvbPublicKey(dst);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e.toString());
            }
        }

        @RequiresPermission(value="android.permission.MANAGE_DYNAMIC_SYSTEM")
        public boolean commit() {
            try {
                return DynamicSystemManager.this.mService.setEnable(true, true);
            }
            catch (RemoteException e) {
                throw new RuntimeException(e.toString());
            }
        }
    }
}

