/*
 * Decompiled with CFR 0.152.
 */
package android.service.autofill;

import android.app.ActivityThread;
import android.content.ContentResolver;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.provider.Settings;
import android.service.autofill.FieldClassificationUserData;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.ArraySet;
import android.util.Log;
import android.view.autofill.Helper;
import com.android.internal.util.Preconditions;
import java.io.PrintWriter;
import java.util.ArrayList;

public class UserData
implements FieldClassificationUserData,
Parcelable {
    private static final String TAG = "UserData";
    private static final int DEFAULT_MAX_USER_DATA_SIZE = 50;
    private static final int DEFAULT_MAX_CATEGORY_COUNT = 10;
    private static final int DEFAULT_MAX_FIELD_CLASSIFICATION_IDS_SIZE = 10;
    private static final int DEFAULT_MIN_VALUE_LENGTH = 3;
    private static final int DEFAULT_MAX_VALUE_LENGTH = 100;
    private final String mId;
    private final String[] mCategoryIds;
    private final String[] mValues;
    private final String mDefaultAlgorithm;
    private final Bundle mDefaultArgs;
    private final ArrayMap<String, String> mCategoryAlgorithms;
    private final ArrayMap<String, Bundle> mCategoryArgs;
    public static final Parcelable.Creator<UserData> CREATOR = new Parcelable.Creator<UserData>(){

        @Override
        public UserData createFromParcel(Parcel parcel) {
            String id2 = parcel.readString();
            String[] categoryIds = parcel.readStringArray();
            String[] values = parcel.readStringArray();
            String defaultAlgorithm = parcel.readString();
            Bundle defaultArgs = parcel.readBundle();
            ArrayMap categoryAlgorithms = new ArrayMap();
            parcel.readMap(categoryAlgorithms, String.class.getClassLoader());
            ArrayMap categoryArgs = new ArrayMap();
            parcel.readMap(categoryArgs, Bundle.class.getClassLoader());
            Builder builder = new Builder(id2, values[0], categoryIds[0]).setFieldClassificationAlgorithm(defaultAlgorithm, defaultArgs);
            for (int i = 1; i < categoryIds.length; ++i) {
                String categoryId = categoryIds[i];
                builder.add(values[i], categoryId);
            }
            int size = categoryAlgorithms.size();
            if (size > 0) {
                for (int i = 0; i < size; ++i) {
                    String categoryId = (String)categoryAlgorithms.keyAt(i);
                    builder.setFieldClassificationAlgorithmForCategory(categoryId, (String)categoryAlgorithms.valueAt(i), (Bundle)categoryArgs.get(categoryId));
                }
            }
            return builder.build();
        }

        public UserData[] newArray(int size) {
            return new UserData[size];
        }
    };

    private UserData(Builder builder) {
        this.mId = builder.mId;
        this.mCategoryIds = new String[builder.mCategoryIds.size()];
        builder.mCategoryIds.toArray(this.mCategoryIds);
        this.mValues = new String[builder.mValues.size()];
        builder.mValues.toArray(this.mValues);
        builder.mValues.toArray(this.mValues);
        this.mDefaultAlgorithm = builder.mDefaultAlgorithm;
        this.mDefaultArgs = builder.mDefaultArgs;
        this.mCategoryAlgorithms = builder.mCategoryAlgorithms;
        this.mCategoryArgs = builder.mCategoryArgs;
    }

    @Override
    public String getFieldClassificationAlgorithm() {
        return this.mDefaultAlgorithm;
    }

    @Override
    public Bundle getDefaultFieldClassificationArgs() {
        return this.mDefaultArgs;
    }

    @Override
    public String getFieldClassificationAlgorithmForCategory(String categoryId) {
        Preconditions.checkNotNull(categoryId);
        if (this.mCategoryAlgorithms == null || !this.mCategoryAlgorithms.containsKey(categoryId)) {
            return null;
        }
        return this.mCategoryAlgorithms.get(categoryId);
    }

    public String getId() {
        return this.mId;
    }

    @Override
    public String[] getCategoryIds() {
        return this.mCategoryIds;
    }

    @Override
    public String[] getValues() {
        return this.mValues;
    }

    @Override
    public ArrayMap<String, String> getFieldClassificationAlgorithms() {
        return this.mCategoryAlgorithms;
    }

    @Override
    public ArrayMap<String, Bundle> getFieldClassificationArgs() {
        return this.mCategoryArgs;
    }

    public void dump(String prefix, PrintWriter pw) {
        int i;
        pw.print(prefix);
        pw.print("id: ");
        pw.print(this.mId);
        pw.print(prefix);
        pw.print("Default Algorithm: ");
        pw.print(this.mDefaultAlgorithm);
        pw.print(prefix);
        pw.print("Default Args");
        pw.print(this.mDefaultArgs);
        if (this.mCategoryAlgorithms != null && this.mCategoryAlgorithms.size() > 0) {
            pw.print(prefix);
            pw.print("Algorithms per category: ");
            for (i = 0; i < this.mCategoryAlgorithms.size(); ++i) {
                pw.print(prefix);
                pw.print(prefix);
                pw.print(this.mCategoryAlgorithms.keyAt(i));
                pw.print(": ");
                pw.println(Helper.getRedacted(this.mCategoryAlgorithms.valueAt(i)));
                pw.print("args=");
                pw.print(this.mCategoryArgs.get(this.mCategoryAlgorithms.keyAt(i)));
            }
        }
        pw.print(prefix);
        pw.print("Field ids size: ");
        pw.println(this.mCategoryIds.length);
        for (i = 0; i < this.mCategoryIds.length; ++i) {
            pw.print(prefix);
            pw.print(prefix);
            pw.print(i);
            pw.print(": ");
            pw.println(Helper.getRedacted(this.mCategoryIds[i]));
        }
        pw.print(prefix);
        pw.print("Values size: ");
        pw.println(this.mValues.length);
        for (i = 0; i < this.mValues.length; ++i) {
            pw.print(prefix);
            pw.print(prefix);
            pw.print(i);
            pw.print(": ");
            pw.println(Helper.getRedacted(this.mValues[i]));
        }
    }

    public static void dumpConstraints(String prefix, PrintWriter pw) {
        pw.print(prefix);
        pw.print("maxUserDataSize: ");
        pw.println(UserData.getMaxUserDataSize());
        pw.print(prefix);
        pw.print("maxFieldClassificationIdsSize: ");
        pw.println(UserData.getMaxFieldClassificationIdsSize());
        pw.print(prefix);
        pw.print("maxCategoryCount: ");
        pw.println(UserData.getMaxCategoryCount());
        pw.print(prefix);
        pw.print("minValueLength: ");
        pw.println(UserData.getMinValueLength());
        pw.print(prefix);
        pw.print("maxValueLength: ");
        pw.println(UserData.getMaxValueLength());
    }

    public String toString() {
        if (!Helper.sDebug) {
            return super.toString();
        }
        StringBuilder builder = new StringBuilder("UserData: [id=").append(this.mId);
        builder.append(", categoryIds=");
        Helper.appendRedacted(builder, this.mCategoryIds);
        builder.append(", values=");
        Helper.appendRedacted(builder, this.mValues);
        return builder.append("]").toString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel parcel, int flags) {
        parcel.writeString(this.mId);
        parcel.writeStringArray(this.mCategoryIds);
        parcel.writeStringArray(this.mValues);
        parcel.writeString(this.mDefaultAlgorithm);
        parcel.writeBundle(this.mDefaultArgs);
        parcel.writeMap(this.mCategoryAlgorithms);
        parcel.writeMap(this.mCategoryArgs);
    }

    public static int getMaxUserDataSize() {
        return UserData.getInt("autofill_user_data_max_user_data_size", 50);
    }

    public static int getMaxFieldClassificationIdsSize() {
        return UserData.getInt("autofill_user_data_max_field_classification_size", 10);
    }

    public static int getMaxCategoryCount() {
        return UserData.getInt("autofill_user_data_max_category_count", 10);
    }

    public static int getMinValueLength() {
        return UserData.getInt("autofill_user_data_min_value_length", 3);
    }

    public static int getMaxValueLength() {
        return UserData.getInt("autofill_user_data_max_value_length", 100);
    }

    private static int getInt(String settings, int defaultValue) {
        ContentResolver cr = null;
        ActivityThread at = ActivityThread.currentActivityThread();
        if (at != null) {
            cr = at.getApplication().getContentResolver();
        }
        if (cr == null) {
            Log.w(TAG, "Could not read from " + settings + "; hardcoding " + defaultValue);
            return defaultValue;
        }
        return Settings.Secure.getInt(cr, settings, defaultValue);
    }

    public static class Builder {
        private final String mId;
        private final ArrayList<String> mCategoryIds;
        private final ArrayList<String> mValues;
        private String mDefaultAlgorithm;
        private Bundle mDefaultArgs;
        private ArrayMap<String, String> mCategoryAlgorithms;
        private ArrayMap<String, Bundle> mCategoryArgs;
        private boolean mDestroyed;
        private final ArraySet<String> mUniqueCategoryIds;
        private final ArraySet<String> mUniqueValueCategoryPairs;

        public Builder(String id2, String value, String categoryId) {
            this.mId = this.checkNotEmpty("id", id2);
            this.checkNotEmpty("categoryId", categoryId);
            this.checkValidValue(value);
            int maxUserDataSize = UserData.getMaxUserDataSize();
            this.mCategoryIds = new ArrayList(maxUserDataSize);
            this.mValues = new ArrayList(maxUserDataSize);
            this.mUniqueValueCategoryPairs = new ArraySet(maxUserDataSize);
            this.mUniqueCategoryIds = new ArraySet(UserData.getMaxCategoryCount());
            this.addMapping(value, categoryId);
        }

        public Builder setFieldClassificationAlgorithm(String name, Bundle args) {
            this.throwIfDestroyed();
            this.mDefaultAlgorithm = name;
            this.mDefaultArgs = args;
            return this;
        }

        public Builder setFieldClassificationAlgorithmForCategory(String categoryId, String name, Bundle args) {
            this.throwIfDestroyed();
            Preconditions.checkNotNull(categoryId);
            if (this.mCategoryAlgorithms == null) {
                this.mCategoryAlgorithms = new ArrayMap(UserData.getMaxCategoryCount());
            }
            if (this.mCategoryArgs == null) {
                this.mCategoryArgs = new ArrayMap(UserData.getMaxCategoryCount());
            }
            this.mCategoryAlgorithms.put(categoryId, name);
            this.mCategoryArgs.put(categoryId, args);
            return this;
        }

        public Builder add(String value, String categoryId) {
            this.throwIfDestroyed();
            this.checkNotEmpty("categoryId", categoryId);
            this.checkValidValue(value);
            if (!this.mUniqueCategoryIds.contains(categoryId)) {
                Preconditions.checkState(this.mUniqueCategoryIds.size() < UserData.getMaxCategoryCount(), "already added %d unique category ids", this.mUniqueCategoryIds.size());
            }
            Preconditions.checkState(this.mValues.size() < UserData.getMaxUserDataSize(), "already added %d elements", this.mValues.size());
            this.addMapping(value, categoryId);
            return this;
        }

        private void addMapping(String value, String categoryId) {
            String pair = value + ":" + categoryId;
            if (this.mUniqueValueCategoryPairs.contains(pair)) {
                Log.w(UserData.TAG, "Ignoring entry with same value / category");
                return;
            }
            this.mCategoryIds.add(categoryId);
            this.mValues.add(value);
            this.mUniqueCategoryIds.add(categoryId);
            this.mUniqueValueCategoryPairs.add(pair);
        }

        private String checkNotEmpty(String name, String value) {
            Preconditions.checkNotNull(value);
            Preconditions.checkArgument(!TextUtils.isEmpty(value), "%s cannot be empty", name);
            return value;
        }

        private void checkValidValue(String value) {
            Preconditions.checkNotNull(value);
            int length = value.length();
            Preconditions.checkArgumentInRange(length, UserData.getMinValueLength(), UserData.getMaxValueLength(), "value length (" + length + ")");
        }

        public UserData build() {
            this.throwIfDestroyed();
            this.mDestroyed = true;
            return new UserData(this);
        }

        private void throwIfDestroyed() {
            if (this.mDestroyed) {
                throw new IllegalStateException("Already called #build()");
            }
        }
    }
}

