/*
 * Decompiled with CFR 0.152.
 */
package android.text.format;

import android.compat.annotation.UnsupportedAppUsage;
import android.content.Context;
import android.content.res.Resources;
import android.icu.text.MeasureFormat;
import android.icu.util.Measure;
import android.icu.util.MeasureUnit;
import android.text.BidiFormatter;
import android.text.TextUtils;
import com.android.net.module.util.Inet4AddressUtils;
import java.util.Locale;

public class Formatter {
    public static final int FLAG_SHORTER = 1;
    public static final int FLAG_CALCULATE_ROUNDED = 2;
    public static final int FLAG_SI_UNITS = 4;
    public static final int FLAG_IEC_UNITS = 8;
    private static final int SECONDS_PER_MINUTE = 60;
    private static final int SECONDS_PER_HOUR = 3600;
    private static final int SECONDS_PER_DAY = 86400;
    private static final int MILLIS_PER_MINUTE = 60000;

    private static Locale localeFromContext(Context context) {
        return context.getResources().getConfiguration().getLocales().get(0);
    }

    private static String bidiWrap(Context context, String source) {
        Locale locale = Formatter.localeFromContext(context);
        if (TextUtils.getLayoutDirectionFromLocale(locale) == 1) {
            return BidiFormatter.getInstance(true).unicodeWrap(source);
        }
        return source;
    }

    public static String formatFileSize(Context context, long sizeBytes) {
        return Formatter.formatFileSize(context, sizeBytes, 4);
    }

    public static String formatFileSize(Context context, long sizeBytes, int flags) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, flags);
        return Formatter.bidiWrap(context, context.getString(17040252, res.value, res.units));
    }

    public static String formatShortFileSize(Context context, long sizeBytes) {
        if (context == null) {
            return "";
        }
        BytesResult res = Formatter.formatBytes(context.getResources(), sizeBytes, 5);
        return Formatter.bidiWrap(context, context.getString(17040252, res.value, res.units));
    }

    @UnsupportedAppUsage
    public static BytesResult formatBytes(Resources res, long sizeBytes, int flags) {
        String roundFormat;
        int roundFactor;
        int unit = (flags & 8) != 0 ? 1024 : 1000;
        boolean isNegative = sizeBytes < 0L;
        float result = isNegative ? (float)(-sizeBytes) : (float)sizeBytes;
        int suffix = 17039801;
        long mult = 1L;
        if (result > 900.0f) {
            suffix = 17040495;
            mult = unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17040686;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17040317;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17041503;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (result > 900.0f) {
            suffix = 17041169;
            mult *= (long)unit;
            result /= (float)unit;
        }
        if (mult == 1L || result >= 100.0f) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else if (result < 1.0f) {
            roundFactor = 100;
            roundFormat = "%.2f";
        } else if (result < 10.0f) {
            if ((flags & 1) != 0) {
                roundFactor = 10;
                roundFormat = "%.1f";
            } else {
                roundFactor = 100;
                roundFormat = "%.2f";
            }
        } else if ((flags & 1) != 0) {
            roundFactor = 1;
            roundFormat = "%.0f";
        } else {
            roundFactor = 100;
            roundFormat = "%.2f";
        }
        if (isNegative) {
            result = -result;
        }
        String roundedString = String.format(roundFormat, Float.valueOf(result));
        long roundedBytes = (flags & 2) == 0 ? 0L : (long)Math.round(result * (float)roundFactor) * mult / (long)roundFactor;
        String units = res.getString(suffix);
        return new BytesResult(roundedString, units, roundedBytes);
    }

    @Deprecated
    public static String formatIpAddress(int ipv4Address) {
        return Inet4AddressUtils.intToInet4AddressHTL(ipv4Address).getHostAddress();
    }

    @UnsupportedAppUsage
    public static String formatShortElapsedTime(Context context, long millis) {
        long secondsLong = millis / 1000L;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        if (secondsLong >= 86400L) {
            days = (int)(secondsLong / 86400L);
            secondsLong -= (long)(days * 86400);
        }
        if (secondsLong >= 3600L) {
            hours = (int)(secondsLong / 3600L);
            secondsLong -= (long)(hours * 3600);
        }
        if (secondsLong >= 60L) {
            minutes = (int)(secondsLong / 60L);
            secondsLong -= (long)(minutes * 60);
        }
        int seconds = (int)secondsLong;
        Locale locale = Formatter.localeFromContext(context);
        MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
        if (days >= 2 || days > 0 && hours == 0) {
            return measureFormat.format(new Measure(days += (hours + 12) / 24, MeasureUnit.DAY));
        }
        if (days > 0) {
            return measureFormat.formatMeasures(new Measure(days, MeasureUnit.DAY), new Measure(hours, MeasureUnit.HOUR));
        }
        if (hours >= 2 || hours > 0 && minutes == 0) {
            return measureFormat.format(new Measure(hours += (minutes + 30) / 60, MeasureUnit.HOUR));
        }
        if (hours > 0) {
            return measureFormat.formatMeasures(new Measure(hours, MeasureUnit.HOUR), new Measure(minutes, MeasureUnit.MINUTE));
        }
        if (minutes >= 2 || minutes > 0 && seconds == 0) {
            return measureFormat.format(new Measure(minutes += (seconds + 30) / 60, MeasureUnit.MINUTE));
        }
        if (minutes > 0) {
            return measureFormat.formatMeasures(new Measure(minutes, MeasureUnit.MINUTE), new Measure(seconds, MeasureUnit.SECOND));
        }
        return measureFormat.format(new Measure(seconds, MeasureUnit.SECOND));
    }

    @UnsupportedAppUsage
    public static String formatShortElapsedTimeRoundingUpToMinutes(Context context, long millis) {
        long minutesRoundedUp = (millis + 60000L - 1L) / 60000L;
        if (minutesRoundedUp == 0L || minutesRoundedUp == 1L) {
            Locale locale = Formatter.localeFromContext(context);
            MeasureFormat measureFormat = MeasureFormat.getInstance(locale, MeasureFormat.FormatWidth.SHORT);
            return measureFormat.format(new Measure(minutesRoundedUp, MeasureUnit.MINUTE));
        }
        return Formatter.formatShortElapsedTime(context, minutesRoundedUp * 60000L);
    }

    public static class BytesResult {
        public final String value;
        public final String units;
        public final long roundedBytes;

        public BytesResult(String value, String units, long roundedBytes) {
            this.value = value;
            this.units = units;
            this.roundedBytes = roundedBytes;
        }
    }
}

