/*
 * Decompiled with CFR 0.152.
 */
package android.uwb;

import android.annotation.SuppressLint;
import android.annotation.SystemApi;
import android.os.Parcel;
import android.os.Parcelable;
import android.uwb.AngleOfArrivalMeasurement;
import android.uwb.DistanceMeasurement;
import android.uwb.UwbAddress;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

@SystemApi
public class RangingMeasurement
implements Parcelable {
    private final UwbAddress mRemoteDeviceAddress;
    private final int mStatus;
    private final long mElapsedRealtimeNanos;
    private final DistanceMeasurement mDistanceMeasurement;
    private final AngleOfArrivalMeasurement mAngleOfArrivalMeasurement;
    public static final int RANGING_STATUS_SUCCESS = 0;
    public static final int RANGING_STATUS_FAILURE_OUT_OF_RANGE = 1;
    public static final int RANGING_STATUS_FAILURE_UNKNOWN_ERROR = -1;
    public static final Parcelable.Creator<RangingMeasurement> CREATOR = new Parcelable.Creator<RangingMeasurement>(){

        @Override
        public RangingMeasurement createFromParcel(Parcel in) {
            Builder builder = new Builder();
            builder.setRemoteDeviceAddress((UwbAddress)in.readParcelable(UwbAddress.class.getClassLoader()));
            builder.setStatus(in.readInt());
            builder.setElapsedRealtimeNanos(in.readLong());
            builder.setDistanceMeasurement((DistanceMeasurement)in.readParcelable(DistanceMeasurement.class.getClassLoader()));
            builder.setAngleOfArrivalMeasurement((AngleOfArrivalMeasurement)in.readParcelable(AngleOfArrivalMeasurement.class.getClassLoader()));
            return builder.build();
        }

        public RangingMeasurement[] newArray(int size) {
            return new RangingMeasurement[size];
        }
    };

    private RangingMeasurement(UwbAddress remoteDeviceAddress, int status, long elapsedRealtimeNanos, DistanceMeasurement distanceMeasurement, AngleOfArrivalMeasurement angleOfArrivalMeasurement) {
        this.mRemoteDeviceAddress = remoteDeviceAddress;
        this.mStatus = status;
        this.mElapsedRealtimeNanos = elapsedRealtimeNanos;
        this.mDistanceMeasurement = distanceMeasurement;
        this.mAngleOfArrivalMeasurement = angleOfArrivalMeasurement;
    }

    public UwbAddress getRemoteDeviceAddress() {
        return this.mRemoteDeviceAddress;
    }

    public int getStatus() {
        return this.mStatus;
    }

    @SuppressLint(value={"MethodNameUnits"})
    public long getElapsedRealtimeNanos() {
        return this.mElapsedRealtimeNanos;
    }

    public DistanceMeasurement getDistanceMeasurement() {
        return this.mDistanceMeasurement;
    }

    public AngleOfArrivalMeasurement getAngleOfArrivalMeasurement() {
        return this.mAngleOfArrivalMeasurement;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof RangingMeasurement) {
            RangingMeasurement other = (RangingMeasurement)obj;
            return this.mRemoteDeviceAddress.equals(other.getRemoteDeviceAddress()) && this.mStatus == other.getStatus() && this.mElapsedRealtimeNanos == other.getElapsedRealtimeNanos() && this.mDistanceMeasurement.equals(other.getDistanceMeasurement()) && this.mAngleOfArrivalMeasurement.equals(other.getAngleOfArrivalMeasurement());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.mRemoteDeviceAddress, this.mStatus, this.mElapsedRealtimeNanos, this.mDistanceMeasurement, this.mAngleOfArrivalMeasurement);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeParcelable(this.mRemoteDeviceAddress, flags);
        dest.writeInt(this.mStatus);
        dest.writeLong(this.mElapsedRealtimeNanos);
        dest.writeParcelable(this.mDistanceMeasurement, flags);
        dest.writeParcelable(this.mAngleOfArrivalMeasurement, flags);
    }

    public static class Builder {
        private UwbAddress mRemoteDeviceAddress = null;
        private int mStatus = -1;
        private long mElapsedRealtimeNanos = -1L;
        private DistanceMeasurement mDistanceMeasurement = null;
        private AngleOfArrivalMeasurement mAngleOfArrivalMeasurement = null;

        public Builder setRemoteDeviceAddress(UwbAddress remoteDeviceAddress) {
            this.mRemoteDeviceAddress = remoteDeviceAddress;
            return this;
        }

        public Builder setStatus(int status) {
            this.mStatus = status;
            return this;
        }

        public Builder setElapsedRealtimeNanos(long elapsedRealtimeNanos) {
            if (elapsedRealtimeNanos < 0L) {
                throw new IllegalArgumentException("elapsedRealtimeNanos must be >= 0");
            }
            this.mElapsedRealtimeNanos = elapsedRealtimeNanos;
            return this;
        }

        public Builder setDistanceMeasurement(DistanceMeasurement distanceMeasurement) {
            this.mDistanceMeasurement = distanceMeasurement;
            return this;
        }

        public Builder setAngleOfArrivalMeasurement(AngleOfArrivalMeasurement angleOfArrivalMeasurement) {
            this.mAngleOfArrivalMeasurement = angleOfArrivalMeasurement;
            return this;
        }

        public RangingMeasurement build() {
            if (this.mStatus != 0) {
                if (this.mDistanceMeasurement != null) {
                    throw new IllegalStateException("Distance Measurement must be null if ranging is not successful");
                }
                if (this.mAngleOfArrivalMeasurement != null) {
                    throw new IllegalStateException("Angle of Arrival must be null if ranging is not successful");
                }
            }
            if (this.mRemoteDeviceAddress == null) {
                throw new IllegalStateException("No remote device address was set");
            }
            if (this.mElapsedRealtimeNanos < 0L) {
                throw new IllegalStateException("elapsedRealtimeNanos must be >=0: " + this.mElapsedRealtimeNanos);
            }
            return new RangingMeasurement(this.mRemoteDeviceAddress, this.mStatus, this.mElapsedRealtimeNanos, this.mDistanceMeasurement, this.mAngleOfArrivalMeasurement);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface Status {
    }
}

