/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.compat.annotation.UnsupportedAppUsage;
import android.os.Looper;
import android.view.Choreographer;
import android.view.InputChannel;
import android.view.InputEventReceiver;

public class BatchedInputEventReceiver
extends InputEventReceiver {
    private Choreographer mChoreographer;
    private boolean mBatchingEnabled;
    private boolean mBatchedInputScheduled;
    private final BatchedInputRunnable mBatchedInputRunnable = new BatchedInputRunnable();

    @UnsupportedAppUsage
    public BatchedInputEventReceiver(InputChannel inputChannel, Looper looper, Choreographer choreographer) {
        super(inputChannel, looper);
        this.mChoreographer = choreographer;
        this.mBatchingEnabled = true;
    }

    @Override
    public void onBatchedInputEventPending(int source) {
        if (this.mBatchingEnabled) {
            this.scheduleBatchedInput();
        } else {
            this.consumeBatchedInputEvents(-1L);
        }
    }

    @Override
    public void dispose() {
        this.unscheduleBatchedInput();
        this.consumeBatchedInputEvents(-1L);
        super.dispose();
    }

    public void setBatchingEnabled(boolean batchingEnabled) {
        this.mBatchingEnabled = batchingEnabled;
        if (!batchingEnabled) {
            this.unscheduleBatchedInput();
            this.consumeBatchedInputEvents(-1L);
        }
    }

    void doConsumeBatchedInput(long frameTimeNanos) {
        if (this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = false;
            if (this.consumeBatchedInputEvents(frameTimeNanos) && frameTimeNanos != -1L) {
                this.scheduleBatchedInput();
            }
        }
    }

    private void scheduleBatchedInput() {
        if (!this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = true;
            this.mChoreographer.postCallback(0, this.mBatchedInputRunnable, null);
        }
    }

    private void unscheduleBatchedInput() {
        if (this.mBatchedInputScheduled) {
            this.mBatchedInputScheduled = false;
            this.mChoreographer.removeCallbacks(0, this.mBatchedInputRunnable, null);
        }
    }

    private class BatchedInputRunnable
    implements Runnable {
        private BatchedInputRunnable() {
        }

        @Override
        public void run() {
            BatchedInputEventReceiver.this.doConsumeBatchedInput(BatchedInputEventReceiver.this.mChoreographer.getFrameTimeNanos());
        }
    }
}

