/*
 * Decompiled with CFR 0.152.
 */
package android.view.textservice;

import android.annotation.SuppressLint;
import android.compat.annotation.UnsupportedAppUsage;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import android.view.inputmethod.InputMethodManager;
import android.view.textservice.SentenceSuggestionsInfo;
import android.view.textservice.SpellCheckerInfo;
import android.view.textservice.SuggestionsInfo;
import android.view.textservice.TextInfo;
import android.view.textservice.TextServicesManager;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.textservice.ISpellCheckerSession;
import com.android.internal.textservice.ISpellCheckerSessionListener;
import com.android.internal.textservice.ITextServicesSessionListener;
import dalvik.system.CloseGuard;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Queue;
import java.util.concurrent.Executor;

public class SpellCheckerSession {
    private static final String TAG = SpellCheckerSession.class.getSimpleName();
    private static final boolean DBG = false;
    public static final String SERVICE_META_DATA = "android.view.textservice.scs";
    private static final int MSG_ON_GET_SUGGESTION_MULTIPLE = 1;
    private static final int MSG_ON_GET_SUGGESTION_MULTIPLE_FOR_SENTENCE = 2;
    private final InternalListener mInternalListener;
    private final TextServicesManager mTextServicesManager;
    private final SpellCheckerInfo mSpellCheckerInfo;
    @UnsupportedAppUsage(maxTargetSdk=30, trackingBug=170729553L)
    private final SpellCheckerSessionListener mSpellCheckerSessionListener;
    private final SpellCheckerSessionListenerImpl mSpellCheckerSessionListenerImpl;
    private final Executor mExecutor;
    private final CloseGuard mGuard = CloseGuard.get();

    public SpellCheckerSession(SpellCheckerInfo info, TextServicesManager tsm, SpellCheckerSessionListener listener, Executor executor) {
        if (info == null || listener == null || tsm == null) {
            throw new NullPointerException();
        }
        this.mSpellCheckerInfo = info;
        this.mSpellCheckerSessionListenerImpl = new SpellCheckerSessionListenerImpl(this);
        this.mInternalListener = new InternalListener(this.mSpellCheckerSessionListenerImpl);
        this.mTextServicesManager = tsm;
        this.mSpellCheckerSessionListener = listener;
        this.mExecutor = executor;
        this.mGuard.open("finishSession");
    }

    public boolean isSessionDisconnected() {
        return this.mSpellCheckerSessionListenerImpl.isDisconnected();
    }

    public SpellCheckerInfo getSpellChecker() {
        return this.mSpellCheckerInfo;
    }

    public void cancel() {
        this.mSpellCheckerSessionListenerImpl.cancel();
    }

    public void close() {
        this.mGuard.close();
        this.mSpellCheckerSessionListenerImpl.close();
        this.mTextServicesManager.finishSpellCheckerService(this.mSpellCheckerSessionListenerImpl);
    }

    public void getSentenceSuggestions(TextInfo[] textInfos, int suggestionsLimit) {
        InputMethodManager imm = this.mTextServicesManager.getInputMethodManager();
        if (imm != null && imm.isInputMethodSuppressingSpellChecker()) {
            this.handleOnGetSentenceSuggestionsMultiple(new SentenceSuggestionsInfo[0]);
            return;
        }
        this.mSpellCheckerSessionListenerImpl.getSentenceSuggestionsMultiple(textInfos, suggestionsLimit);
    }

    @Deprecated
    public void getSuggestions(TextInfo textInfo, int suggestionsLimit) {
        this.getSuggestions(new TextInfo[]{textInfo}, suggestionsLimit, false);
    }

    @Deprecated
    public void getSuggestions(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
        InputMethodManager imm = this.mTextServicesManager.getInputMethodManager();
        if (imm != null && imm.isInputMethodSuppressingSpellChecker()) {
            this.handleOnGetSuggestionsMultiple(new SuggestionsInfo[0]);
            return;
        }
        this.mSpellCheckerSessionListenerImpl.getSuggestionsMultiple(textInfos, suggestionsLimit, sequentialWords);
    }

    void handleOnGetSuggestionsMultiple(SuggestionsInfo[] suggestionsInfos) {
        this.mExecutor.execute(() -> this.mSpellCheckerSessionListener.onGetSuggestions(suggestionsInfos));
    }

    void handleOnGetSentenceSuggestionsMultiple(SentenceSuggestionsInfo[] suggestionsInfos) {
        this.mExecutor.execute(() -> this.mSpellCheckerSessionListener.onGetSentenceSuggestions(suggestionsInfos));
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mGuard != null) {
                this.mGuard.warnIfOpen();
                this.close();
            }
        }
        finally {
            super.finalize();
        }
    }

    public ITextServicesSessionListener getTextServicesSessionListener() {
        return this.mInternalListener;
    }

    public ISpellCheckerSessionListener getSpellCheckerSessionListener() {
        return this.mSpellCheckerSessionListenerImpl;
    }

    private static class InternalListener
    extends ITextServicesSessionListener.Stub {
        private final SpellCheckerSessionListenerImpl mParentSpellCheckerSessionListenerImpl;

        public InternalListener(SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl) {
            this.mParentSpellCheckerSessionListenerImpl = spellCheckerSessionListenerImpl;
        }

        @Override
        public void onServiceConnected(ISpellCheckerSession session) {
            this.mParentSpellCheckerSessionListenerImpl.onServiceConnected(session);
        }
    }

    public static interface SpellCheckerSessionListener {
        public void onGetSuggestions(SuggestionsInfo[] var1);

        public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] var1);
    }

    public static class SpellCheckerSessionParams {
        private final Locale mLocale;
        private final boolean mShouldReferToSpellCheckerLanguageSettings;
        private final int mSupportedAttributes;
        private final Bundle mExtras;

        private SpellCheckerSessionParams(Locale locale, boolean referToSpellCheckerLanguageSettings, int supportedAttributes, Bundle extras) {
            this.mLocale = locale;
            this.mShouldReferToSpellCheckerLanguageSettings = referToSpellCheckerLanguageSettings;
            this.mSupportedAttributes = supportedAttributes;
            this.mExtras = extras;
        }

        @SuppressLint(value={"UseIcu"})
        public Locale getLocale() {
            return this.mLocale;
        }

        public boolean shouldReferToSpellCheckerLanguageSettings() {
            return this.mShouldReferToSpellCheckerLanguageSettings;
        }

        public int getSupportedAttributes() {
            return this.mSupportedAttributes;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public static class Builder {
            private Locale mLocale;
            private boolean mShouldReferToSpellCheckerLanguageSettings = false;
            private int mSupportedAttributes = 0;
            private Bundle mExtras = Bundle.EMPTY;

            public SpellCheckerSessionParams build() {
                if (this.mLocale == null && !this.mShouldReferToSpellCheckerLanguageSettings) {
                    throw new IllegalArgumentException("mLocale should not be null if  mShouldReferToSpellCheckerLanguageSettings is false.");
                }
                return new SpellCheckerSessionParams(this.mLocale, this.mShouldReferToSpellCheckerLanguageSettings, this.mSupportedAttributes, this.mExtras);
            }

            public Builder setLocale(@SuppressLint(value={"UseIcu"}) Locale locale) {
                this.mLocale = locale;
                return this;
            }

            public Builder setShouldReferToSpellCheckerLanguageSettings(boolean shouldReferToSpellCheckerLanguageSettings) {
                this.mShouldReferToSpellCheckerLanguageSettings = shouldReferToSpellCheckerLanguageSettings;
                return this;
            }

            public Builder setSupportedAttributes(int supportedAttributes) {
                this.mSupportedAttributes = supportedAttributes;
                return this;
            }

            public Builder setExtras(Bundle extras) {
                this.mExtras = extras;
                return this;
            }
        }
    }

    private static class SpellCheckerSessionListenerImpl
    extends ISpellCheckerSessionListener.Stub {
        private static final int TASK_CANCEL = 1;
        private static final int TASK_GET_SUGGESTIONS_MULTIPLE = 2;
        private static final int TASK_CLOSE = 3;
        private static final int TASK_GET_SUGGESTIONS_MULTIPLE_FOR_SENTENCE = 4;
        private final Queue<SpellCheckerParams> mPendingTasks = new LinkedList<SpellCheckerParams>();
        @GuardedBy(value={"SpellCheckerSessionListenerImpl.this"})
        private SpellCheckerSession mSpellCheckerSession;
        private static final int STATE_WAIT_CONNECTION = 0;
        private static final int STATE_CONNECTED = 1;
        private static final int STATE_CLOSED_AFTER_CONNECTION = 2;
        private static final int STATE_CLOSED_BEFORE_CONNECTION = 3;
        private int mState = 0;
        private ISpellCheckerSession mISpellCheckerSession;
        private HandlerThread mThread;
        private Handler mAsyncHandler;

        private static String taskToString(int task) {
            switch (task) {
                case 1: {
                    return "TASK_CANCEL";
                }
                case 2: {
                    return "TASK_GET_SUGGESTIONS_MULTIPLE";
                }
                case 3: {
                    return "TASK_CLOSE";
                }
                case 4: {
                    return "TASK_GET_SUGGESTIONS_MULTIPLE_FOR_SENTENCE";
                }
            }
            return "Unexpected task=" + task;
        }

        private static String stateToString(int state) {
            switch (state) {
                case 0: {
                    return "STATE_WAIT_CONNECTION";
                }
                case 1: {
                    return "STATE_CONNECTED";
                }
                case 2: {
                    return "STATE_CLOSED_AFTER_CONNECTION";
                }
                case 3: {
                    return "STATE_CLOSED_BEFORE_CONNECTION";
                }
            }
            return "Unexpected state=" + state;
        }

        SpellCheckerSessionListenerImpl(SpellCheckerSession spellCheckerSession) {
            this.mSpellCheckerSession = spellCheckerSession;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processTask(ISpellCheckerSession session, SpellCheckerParams scp, boolean async) {
            if (async || this.mAsyncHandler == null) {
                switch (scp.mWhat) {
                    case 1: {
                        try {
                            session.onCancel();
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to cancel " + e);
                        }
                        break;
                    }
                    case 2: {
                        try {
                            session.onGetSuggestionsMultiple(scp.mTextInfos, scp.mSuggestionsLimit, scp.mSequentialWords);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to get suggestions " + e);
                        }
                        break;
                    }
                    case 4: {
                        try {
                            session.onGetSentenceSuggestionsMultiple(scp.mTextInfos, scp.mSuggestionsLimit);
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to get suggestions " + e);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            session.onClose();
                            break;
                        }
                        catch (RemoteException e) {
                            Log.e(TAG, "Failed to close " + e);
                        }
                    }
                }
            } else {
                scp.mSession = session;
                this.mAsyncHandler.sendMessage(Message.obtain(this.mAsyncHandler, 1, scp));
            }
            if (scp.mWhat == 3) {
                SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
                synchronized (spellCheckerSessionListenerImpl) {
                    this.processCloseLocked();
                }
            }
        }

        @GuardedBy(value={"SpellCheckerSessionListenerImpl.this"})
        private void processCloseLocked() {
            this.mISpellCheckerSession = null;
            if (this.mThread != null) {
                this.mThread.quit();
            }
            this.mSpellCheckerSession = null;
            this.mPendingTasks.clear();
            this.mThread = null;
            this.mAsyncHandler = null;
            switch (this.mState) {
                case 0: {
                    this.mState = 3;
                    break;
                }
                case 1: {
                    this.mState = 2;
                    break;
                }
                default: {
                    Log.e(TAG, "processCloseLocked is called unexpectedly. mState=" + SpellCheckerSessionListenerImpl.stateToString(this.mState));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onServiceConnected(ISpellCheckerSession session) {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                switch (this.mState) {
                    case 0: {
                        break;
                    }
                    case 3: {
                        return;
                    }
                    default: {
                        Log.e(TAG, "ignoring onServiceConnected due to unexpected mState=" + SpellCheckerSessionListenerImpl.stateToString(this.mState));
                        return;
                    }
                }
                if (session == null) {
                    Log.e(TAG, "ignoring onServiceConnected due to session=null");
                    return;
                }
                this.mISpellCheckerSession = session;
                if (session.asBinder() instanceof Binder && this.mThread == null) {
                    this.mThread = new HandlerThread("SpellCheckerSession", 10);
                    this.mThread.start();
                    this.mAsyncHandler = new Handler(this.mThread.getLooper()){

                        @Override
                        public void handleMessage(Message msg) {
                            SpellCheckerParams scp = (SpellCheckerParams)msg.obj;
                            this.processTask(scp.mSession, scp, true);
                        }
                    };
                }
                this.mState = 1;
                while (!this.mPendingTasks.isEmpty()) {
                    this.processTask(session, this.mPendingTasks.poll(), false);
                }
            }
        }

        public void cancel() {
            this.processOrEnqueueTask(new SpellCheckerParams(1, null, 0, false));
        }

        public void getSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
            this.processOrEnqueueTask(new SpellCheckerParams(2, textInfos, suggestionsLimit, sequentialWords));
        }

        public void getSentenceSuggestionsMultiple(TextInfo[] textInfos, int suggestionsLimit) {
            this.processOrEnqueueTask(new SpellCheckerParams(4, textInfos, suggestionsLimit, false));
        }

        public void close() {
            this.processOrEnqueueTask(new SpellCheckerParams(3, null, 0, false));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isDisconnected() {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                return this.mState != 1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processOrEnqueueTask(SpellCheckerParams scp) {
            ISpellCheckerSession session;
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                if (scp.mWhat == 3 && (this.mState == 2 || this.mState == 3)) {
                    return;
                }
                if (this.mState != 0 && this.mState != 1) {
                    Log.e(TAG, "ignoring processOrEnqueueTask due to unexpected mState=" + SpellCheckerSessionListenerImpl.stateToString(this.mState) + " scp.mWhat=" + SpellCheckerSessionListenerImpl.taskToString(scp.mWhat));
                    return;
                }
                if (this.mState == 0) {
                    if (scp.mWhat == 3) {
                        this.processCloseLocked();
                        return;
                    }
                    SpellCheckerParams closeTask = null;
                    if (scp.mWhat == 1) {
                        while (!this.mPendingTasks.isEmpty()) {
                            SpellCheckerParams tmp = this.mPendingTasks.poll();
                            if (tmp.mWhat != 3) continue;
                            closeTask = tmp;
                        }
                    }
                    this.mPendingTasks.offer(scp);
                    if (closeTask != null) {
                        this.mPendingTasks.offer(closeTask);
                    }
                    return;
                }
                session = this.mISpellCheckerSession;
            }
            this.processTask(session, scp, false);
        }

        @Override
        public void onGetSuggestions(SuggestionsInfo[] results) {
            SpellCheckerSession session = this.getSpellCheckerSession();
            if (session != null) {
                session.handleOnGetSuggestionsMultiple(results);
            }
        }

        @Override
        public void onGetSentenceSuggestions(SentenceSuggestionsInfo[] results) {
            SpellCheckerSession session = this.getSpellCheckerSession();
            if (session != null) {
                session.handleOnGetSentenceSuggestionsMultiple(results);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private SpellCheckerSession getSpellCheckerSession() {
            SpellCheckerSessionListenerImpl spellCheckerSessionListenerImpl = this;
            synchronized (spellCheckerSessionListenerImpl) {
                return this.mSpellCheckerSession;
            }
        }

        private static class SpellCheckerParams {
            public final int mWhat;
            public final TextInfo[] mTextInfos;
            public final int mSuggestionsLimit;
            public final boolean mSequentialWords;
            public ISpellCheckerSession mSession;

            public SpellCheckerParams(int what, TextInfo[] textInfos, int suggestionsLimit, boolean sequentialWords) {
                this.mWhat = what;
                this.mTextInfos = textInfos;
                this.mSuggestionsLimit = suggestionsLimit;
                this.mSequentialWords = sequentialWords;
            }
        }
    }
}

