/*
 * Decompiled with CFR 0.152.
 */
package android.view.translation;

import android.content.ComponentName;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.IRemoteCallback;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.view.autofill.AutofillId;
import android.view.translation.TranslationContext;
import android.view.translation.TranslationSpec;
import android.view.translation.UiTranslationSpec;
import com.android.internal.os.IResultReceiver;
import java.util.ArrayList;
import java.util.List;

public interface ITranslationManager
extends IInterface {
    public static final String DESCRIPTOR = "android.view.translation.ITranslationManager";

    public void onTranslationCapabilitiesRequest(int var1, int var2, ResultReceiver var3, int var4) throws RemoteException;

    public void registerTranslationCapabilityCallback(IRemoteCallback var1, int var2) throws RemoteException;

    public void unregisterTranslationCapabilityCallback(IRemoteCallback var1, int var2) throws RemoteException;

    public void onSessionCreated(TranslationContext var1, int var2, IResultReceiver var3, int var4) throws RemoteException;

    public void updateUiTranslationState(int var1, TranslationSpec var2, TranslationSpec var3, List<AutofillId> var4, IBinder var5, int var6, UiTranslationSpec var7, int var8) throws RemoteException;

    public void registerUiTranslationStateCallback(IRemoteCallback var1, int var2) throws RemoteException;

    public void unregisterUiTranslationStateCallback(IRemoteCallback var1, int var2) throws RemoteException;

    public void getServiceSettingsActivity(IResultReceiver var1, int var2) throws RemoteException;

    public void onTranslationFinished(boolean var1, IBinder var2, ComponentName var3, int var4) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITranslationManager {
        static final int TRANSACTION_onTranslationCapabilitiesRequest = 1;
        static final int TRANSACTION_registerTranslationCapabilityCallback = 2;
        static final int TRANSACTION_unregisterTranslationCapabilityCallback = 3;
        static final int TRANSACTION_onSessionCreated = 4;
        static final int TRANSACTION_updateUiTranslationState = 5;
        static final int TRANSACTION_registerUiTranslationStateCallback = 6;
        static final int TRANSACTION_unregisterUiTranslationStateCallback = 7;
        static final int TRANSACTION_getServiceSettingsActivity = 8;
        static final int TRANSACTION_onTranslationFinished = 9;

        public Stub() {
            this.attachInterface(this, ITranslationManager.DESCRIPTOR);
        }

        public static ITranslationManager asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITranslationManager.DESCRIPTOR);
            if (iin != null && iin instanceof ITranslationManager) {
                return (ITranslationManager)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onTranslationCapabilitiesRequest";
                }
                case 2: {
                    return "registerTranslationCapabilityCallback";
                }
                case 3: {
                    return "unregisterTranslationCapabilityCallback";
                }
                case 4: {
                    return "onSessionCreated";
                }
                case 5: {
                    return "updateUiTranslationState";
                }
                case 6: {
                    return "registerUiTranslationStateCallback";
                }
                case 7: {
                    return "unregisterUiTranslationStateCallback";
                }
                case 8: {
                    return "getServiceSettingsActivity";
                }
                case 9: {
                    return "onTranslationFinished";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITranslationManager.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    int _arg1 = data.readInt();
                    ResultReceiver _arg2 = 0 != data.readInt() ? ResultReceiver.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onTranslationCapabilitiesRequest(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    IRemoteCallback _arg0 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.registerTranslationCapabilityCallback(_arg0, _arg1);
                    return true;
                }
                case 3: {
                    data.enforceInterface(descriptor);
                    IRemoteCallback _arg0 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.unregisterTranslationCapabilityCallback(_arg0, _arg1);
                    return true;
                }
                case 4: {
                    data.enforceInterface(descriptor);
                    TranslationContext _arg0 = 0 != data.readInt() ? TranslationContext.CREATOR.createFromParcel(data) : null;
                    int _arg1 = data.readInt();
                    IResultReceiver _arg2 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg3 = data.readInt();
                    this.onSessionCreated(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
                case 5: {
                    data.enforceInterface(descriptor);
                    int _arg0 = data.readInt();
                    TranslationSpec _arg1 = 0 != data.readInt() ? TranslationSpec.CREATOR.createFromParcel(data) : null;
                    TranslationSpec _arg2 = 0 != data.readInt() ? TranslationSpec.CREATOR.createFromParcel(data) : null;
                    ArrayList<AutofillId> _arg3 = data.createTypedArrayList(AutofillId.CREATOR);
                    IBinder _arg4 = data.readStrongBinder();
                    int _arg5 = data.readInt();
                    UiTranslationSpec _arg6 = 0 != data.readInt() ? UiTranslationSpec.CREATOR.createFromParcel(data) : null;
                    int _arg7 = data.readInt();
                    this.updateUiTranslationState(_arg0, _arg1, _arg2, _arg3, _arg4, _arg5, _arg6, _arg7);
                    return true;
                }
                case 6: {
                    data.enforceInterface(descriptor);
                    IRemoteCallback _arg0 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.registerUiTranslationStateCallback(_arg0, _arg1);
                    return true;
                }
                case 7: {
                    data.enforceInterface(descriptor);
                    IRemoteCallback _arg0 = IRemoteCallback.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.unregisterUiTranslationStateCallback(_arg0, _arg1);
                    return true;
                }
                case 8: {
                    data.enforceInterface(descriptor);
                    IResultReceiver _arg0 = IResultReceiver.Stub.asInterface(data.readStrongBinder());
                    int _arg1 = data.readInt();
                    this.getServiceSettingsActivity(_arg0, _arg1);
                    return true;
                }
                case 9: {
                    data.enforceInterface(descriptor);
                    boolean _arg0 = 0 != data.readInt();
                    IBinder _arg1 = data.readStrongBinder();
                    ComponentName _arg2 = 0 != data.readInt() ? ComponentName.CREATOR.createFromParcel(data) : null;
                    int _arg3 = data.readInt();
                    this.onTranslationFinished(_arg0, _arg1, _arg2, _arg3);
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITranslationManager impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITranslationManager getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITranslationManager {
            private IBinder mRemote;
            public static ITranslationManager sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITranslationManager.DESCRIPTOR;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranslationCapabilitiesRequest(int sourceFormat, int destFormat, ResultReceiver receiver, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeInt(sourceFormat);
                    _data.writeInt(destFormat);
                    if (receiver != null) {
                        _data.writeInt(1);
                        receiver.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranslationCapabilitiesRequest(sourceFormat, destFormat, receiver, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerTranslationCapabilityCallback(IRemoteCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerTranslationCapabilityCallback(callback, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterTranslationCapabilityCallback(IRemoteCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(3, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterTranslationCapabilityCallback(callback, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onSessionCreated(TranslationContext translationContext, int sessionId, IResultReceiver receiver, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    if (translationContext != null) {
                        _data.writeInt(1);
                        translationContext.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(sessionId);
                    _data.writeStrongBinder(receiver != null ? receiver.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(4, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onSessionCreated(translationContext, sessionId, receiver, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void updateUiTranslationState(int state, TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> viewIds, IBinder token, int taskId, UiTranslationSpec uiTranslationSpec, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeInt(state);
                    if (sourceSpec != null) {
                        _data.writeInt(1);
                        sourceSpec.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    if (targetSpec != null) {
                        _data.writeInt(1);
                        targetSpec.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeTypedList(viewIds);
                    _data.writeStrongBinder(token);
                    _data.writeInt(taskId);
                    if (uiTranslationSpec != null) {
                        _data.writeInt(1);
                        uiTranslationSpec.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(5, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().updateUiTranslationState(state, sourceSpec, targetSpec, viewIds, token, taskId, uiTranslationSpec, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void registerUiTranslationStateCallback(IRemoteCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(6, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().registerUiTranslationStateCallback(callback, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unregisterUiTranslationStateCallback(IRemoteCallback callback, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeStrongBinder(callback != null ? callback.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(7, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().unregisterUiTranslationStateCallback(callback, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void getServiceSettingsActivity(IResultReceiver result, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeStrongBinder(result != null ? result.asBinder() : null);
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(8, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().getServiceSettingsActivity(result, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onTranslationFinished(boolean activityDestroyed, IBinder token, ComponentName componentName, int userId) throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITranslationManager.DESCRIPTOR);
                    _data.writeInt(activityDestroyed ? 1 : 0);
                    _data.writeStrongBinder(token);
                    if (componentName != null) {
                        _data.writeInt(1);
                        componentName.writeToParcel(_data, 0);
                    } else {
                        _data.writeInt(0);
                    }
                    _data.writeInt(userId);
                    boolean _status = this.mRemote.transact(9, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onTranslationFinished(activityDestroyed, token, componentName, userId);
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITranslationManager {
        @Override
        public void onTranslationCapabilitiesRequest(int sourceFormat, int destFormat, ResultReceiver receiver, int userId) throws RemoteException {
        }

        @Override
        public void registerTranslationCapabilityCallback(IRemoteCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void unregisterTranslationCapabilityCallback(IRemoteCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void onSessionCreated(TranslationContext translationContext, int sessionId, IResultReceiver receiver, int userId) throws RemoteException {
        }

        @Override
        public void updateUiTranslationState(int state, TranslationSpec sourceSpec, TranslationSpec targetSpec, List<AutofillId> viewIds, IBinder token, int taskId, UiTranslationSpec uiTranslationSpec, int userId) throws RemoteException {
        }

        @Override
        public void registerUiTranslationStateCallback(IRemoteCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void unregisterUiTranslationStateCallback(IRemoteCallback callback, int userId) throws RemoteException {
        }

        @Override
        public void getServiceSettingsActivity(IResultReceiver result, int userId) throws RemoteException {
        }

        @Override
        public void onTranslationFinished(boolean activityDestroyed, IBinder token, ComponentName componentName, int userId) throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

