/*
 * Decompiled with CFR 0.152.
 */
package android.window;

import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.view.IWindowManager;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.VisibleForTesting;

public class WindowContextController {
    private final IWindowManager mWms;
    @VisibleForTesting
    public boolean mAttachedToDisplayArea;
    private final IBinder mToken;

    public WindowContextController(IBinder token) {
        this.mToken = token;
        this.mWms = WindowManagerGlobal.getWindowManagerService();
    }

    @VisibleForTesting
    public WindowContextController(IBinder token, IWindowManager mockWms) {
        this.mToken = token;
        this.mWms = mockWms;
    }

    public void attachToDisplayArea(int type, int displayId, Bundle options) {
        if (this.mAttachedToDisplayArea) {
            throw new IllegalStateException("A Window Context can be only attached to a DisplayArea once.");
        }
        try {
            this.mAttachedToDisplayArea = this.mWms.attachWindowContextToDisplayArea(this.mToken, type, displayId, options);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void attachToWindowToken(IBinder windowToken) {
        if (!this.mAttachedToDisplayArea) {
            throw new IllegalStateException("The Window Context should have been attached to a DisplayArea.");
        }
        try {
            this.mWms.attachWindowContextToWindowToken(this.mToken, windowToken);
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    public void detachIfNeeded() {
        if (this.mAttachedToDisplayArea) {
            try {
                this.mWms.detachWindowContextFromWindowContainer(this.mToken);
                this.mAttachedToDisplayArea = false;
            }
            catch (RemoteException e) {
                throw e.rethrowFromSystemServer();
            }
        }
    }
}

