/*
 * Decompiled with CFR 0.152.
 */
package com.android.i18n.timezone.internal;

import android.system.ErrnoException;
import android.system.Os;
import com.android.i18n.timezone.internal.BufferIterator;
import com.android.i18n.timezone.internal.NioBufferIterator;
import java.io.FileDescriptor;
import java.nio.ByteOrder;

public class MemoryMappedFile
implements AutoCloseable {
    private boolean closed;
    private final long address;
    private final int size;

    public MemoryMappedFile(long address, long size) {
        this.address = address;
        if (size < 0L || size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Unsupported file size=" + size);
        }
        this.size = (int)size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MemoryMappedFile mmapRO(String path) throws ErrnoException {
        FileDescriptor fd = Os.open(path, 0, 0);
        try {
            long size = Os.fstat((FileDescriptor)fd).st_size;
            long address = Os.mmap(0L, size, 1, 1, fd, 0L);
            MemoryMappedFile memoryMappedFile = new MemoryMappedFile(address, size);
            return memoryMappedFile;
        }
        finally {
            Os.close(fd);
        }
    }

    @Override
    public void close() throws ErrnoException {
        if (!this.closed) {
            this.closed = true;
            Os.munmap(this.address, this.size);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public BufferIterator bigEndianIterator() {
        return new NioBufferIterator(this, this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN);
    }

    public BufferIterator littleEndianIterator() {
        return new NioBufferIterator(this, this.address, this.size, ByteOrder.nativeOrder() != ByteOrder.LITTLE_ENDIAN);
    }

    void checkNotClosed() {
        if (this.closed) {
            throw new IllegalStateException("MemoryMappedFile is closed");
        }
    }

    public int size() {
        this.checkNotClosed();
        return this.size;
    }
}

