/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.app;

import android.app.ActivityManager;
import android.app.AppGlobals;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.app.AbstractResolverComparator;
import com.android.internal.app.ResolverActivity;
import com.android.internal.app.ResolverRankerServiceResolverComparator;
import com.android.internal.app.chooser.DisplayResolveInfo;
import com.android.internal.lang.System_Delegate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.CountDownLatch;

public class ResolverListController {
    private final Context mContext;
    private final PackageManager mpm;
    private final int mLaunchedFromUid;
    private final Intent mTargetIntent;
    private final String mReferrerPackage;
    private static final String TAG = "ResolverListController";
    private static final boolean DEBUG = false;
    private final UserHandle mUserHandle;
    private AbstractResolverComparator mResolverComparator;
    private boolean isComputed = false;

    public ResolverListController(Context context, PackageManager pm, Intent targetIntent, String referrerPackage, int launchedFromUid, UserHandle userHandle) {
        this(context, pm, targetIntent, referrerPackage, launchedFromUid, userHandle, new ResolverRankerServiceResolverComparator(context, targetIntent, referrerPackage, null, null));
    }

    public ResolverListController(Context context, PackageManager pm, Intent targetIntent, String referrerPackage, int launchedFromUid, UserHandle userHandle, AbstractResolverComparator resolverComparator) {
        this.mContext = context;
        this.mpm = pm;
        this.mLaunchedFromUid = launchedFromUid;
        this.mTargetIntent = targetIntent;
        this.mReferrerPackage = referrerPackage;
        this.mUserHandle = userHandle;
        this.mResolverComparator = resolverComparator;
    }

    @VisibleForTesting
    public ResolveInfo getLastChosen() throws RemoteException {
        return AppGlobals.getPackageManager().getLastChosenActivity(this.mTargetIntent, this.mTargetIntent.resolveTypeIfNeeded(this.mContext.getContentResolver()), 65536);
    }

    @VisibleForTesting
    public void setLastChosen(Intent intent, IntentFilter filter, int match) throws RemoteException {
        AppGlobals.getPackageManager().setLastChosenActivity(intent, intent.resolveType(this.mContext.getContentResolver()), 65536, filter, match, intent.getComponent());
    }

    @VisibleForTesting
    public List<ResolverActivity.ResolvedComponentInfo> getResolversForIntent(boolean shouldGetResolvedFilter, boolean shouldGetActivityMetadata, List<Intent> intents) {
        return this.getResolversForIntentAsUser(shouldGetResolvedFilter, shouldGetActivityMetadata, intents, this.mUserHandle);
    }

    public List<ResolverActivity.ResolvedComponentInfo> getResolversForIntentAsUser(boolean shouldGetResolvedFilter, boolean shouldGetActivityMetadata, List<Intent> intents, UserHandle userHandle) {
        int baseFlags = 0xD0000 | (shouldGetResolvedFilter ? 64 : 0) | (shouldGetActivityMetadata ? 128 : 0);
        return this.getResolversForIntentAsUserInternal(intents, userHandle, baseFlags);
    }

    private List<ResolverActivity.ResolvedComponentInfo> getResolversForIntentAsUserInternal(List<Intent> intents, UserHandle userHandle, int baseFlags) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> resolvedComponents = null;
        int N = intents.size();
        for (int i = 0; i < N; ++i) {
            List<ResolveInfo> infos;
            Intent intent = intents.get(i);
            int flags = baseFlags;
            if (intent.isWebIntent() || (intent.getFlags() & 0x800) != 0) {
                flags |= 0x800000;
            }
            if ((infos = this.mpm.queryIntentActivitiesAsUser(intent, flags, userHandle)) == null) continue;
            if (resolvedComponents == null) {
                resolvedComponents = new ArrayList<ResolverActivity.ResolvedComponentInfo>();
            }
            this.addResolveListDedupe(resolvedComponents, intent, infos);
        }
        return resolvedComponents;
    }

    @VisibleForTesting
    public UserHandle getUserHandle() {
        return this.mUserHandle;
    }

    @VisibleForTesting
    public void addResolveListDedupe(List<ResolverActivity.ResolvedComponentInfo> into, Intent intent, List<ResolveInfo> from) {
        int fromCount = from.size();
        int intoCount = into.size();
        for (int i = 0; i < fromCount; ++i) {
            ResolverActivity.ResolvedComponentInfo rci;
            ResolveInfo newInfo = from.get(i);
            boolean found = false;
            for (int j = 0; j < intoCount; ++j) {
                rci = into.get(j);
                if (!ResolverListController.isSameResolvedComponent(newInfo, rci)) continue;
                found = true;
                rci.add(intent, newInfo);
                break;
            }
            if (found) continue;
            ComponentName name = new ComponentName(newInfo.activityInfo.packageName, newInfo.activityInfo.name);
            rci = new ResolverActivity.ResolvedComponentInfo(name, intent, newInfo);
            rci.setPinned(this.isComponentPinned(name));
            into.add(rci);
        }
    }

    public boolean isComponentPinned(ComponentName name) {
        return false;
    }

    @VisibleForTesting
    public ArrayList<ResolverActivity.ResolvedComponentInfo> filterIneligibleActivities(List<ResolverActivity.ResolvedComponentInfo> inputList, boolean returnCopyOfOriginalListIfModified) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> listToReturn = null;
        for (int i = inputList.size() - 1; i >= 0; --i) {
            ActivityInfo ai = inputList.get((int)i).getResolveInfoAt((int)0).activityInfo;
            int granted = ActivityManager.checkComponentPermission(ai.permission, this.mLaunchedFromUid, ai.applicationInfo.uid, ai.exported);
            if (granted == 0 && !this.isComponentFiltered(ai.getComponentName())) continue;
            if (returnCopyOfOriginalListIfModified && listToReturn == null) {
                listToReturn = new ArrayList<ResolverActivity.ResolvedComponentInfo>(inputList);
            }
            inputList.remove(i);
        }
        return listToReturn;
    }

    @VisibleForTesting
    public ArrayList<ResolverActivity.ResolvedComponentInfo> filterLowPriority(List<ResolverActivity.ResolvedComponentInfo> inputList, boolean returnCopyOfOriginalListIfModified) {
        ArrayList<ResolverActivity.ResolvedComponentInfo> listToReturn = null;
        ResolverActivity.ResolvedComponentInfo rci0 = inputList.get(0);
        ResolveInfo r0 = rci0.getResolveInfoAt(0);
        int N = inputList.size();
        for (int i = 1; i < N; ++i) {
            ResolveInfo ri = inputList.get(i).getResolveInfoAt(0);
            if (r0.priority == ri.priority && r0.isDefault == ri.isDefault) continue;
            while (i < N) {
                if (returnCopyOfOriginalListIfModified && listToReturn == null) {
                    listToReturn = new ArrayList<ResolverActivity.ResolvedComponentInfo>(inputList);
                }
                inputList.remove(i);
                --N;
            }
        }
        return listToReturn;
    }

    private void compute(List<ResolverActivity.ResolvedComponentInfo> inputList) throws InterruptedException {
        if (this.mResolverComparator == null) {
            Log.d(TAG, "Comparator has already been destroyed; skipped.");
            return;
        }
        CountDownLatch finishComputeSignal = new CountDownLatch(1);
        ComputeCallback callback = new ComputeCallback(finishComputeSignal);
        this.mResolverComparator.setCallBack(callback);
        this.mResolverComparator.compute(inputList);
        finishComputeSignal.await();
        this.isComputed = true;
    }

    @VisibleForTesting
    public void sort(List<ResolverActivity.ResolvedComponentInfo> inputList) {
        try {
            long beforeRank = System_Delegate.currentTimeMillis();
            if (!this.isComputed) {
                this.compute(inputList);
            }
            Collections.sort(inputList, this.mResolverComparator);
            long l = System_Delegate.currentTimeMillis();
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Compute & Sort was interrupted: " + e);
        }
    }

    @VisibleForTesting
    public void topK(List<ResolverActivity.ResolvedComponentInfo> inputList, int k) {
        if (inputList == null || inputList.isEmpty() || k <= 0) {
            return;
        }
        if (inputList.size() <= k) {
            this.sort(inputList);
            return;
        }
        try {
            long beforeRank = System_Delegate.currentTimeMillis();
            if (!this.isComputed) {
                this.compute(inputList);
            }
            PriorityQueue<ResolverActivity.ResolvedComponentInfo> minHeap = new PriorityQueue<ResolverActivity.ResolvedComponentInfo>(k, (o1, o2) -> -this.mResolverComparator.compare((ResolverActivity.ResolvedComponentInfo)o1, (ResolverActivity.ResolvedComponentInfo)o2));
            int size = inputList.size();
            int pointer = size - 1;
            minHeap.addAll(inputList.subList(size - k, size));
            for (int i = size - k - 1; i >= 0; --i) {
                ResolverActivity.ResolvedComponentInfo ci = inputList.get(i);
                if (-this.mResolverComparator.compare(ci, (ResolverActivity.ResolvedComponentInfo)minHeap.peek()) > 0) {
                    inputList.set(pointer--, (ResolverActivity.ResolvedComponentInfo)minHeap.poll());
                    minHeap.add(ci);
                    continue;
                }
                inputList.set(pointer--, ci);
            }
            while (!minHeap.isEmpty()) {
                inputList.set(pointer--, (ResolverActivity.ResolvedComponentInfo)minHeap.poll());
            }
            long l = System_Delegate.currentTimeMillis();
        }
        catch (InterruptedException e) {
            Log.e(TAG, "Compute & greatestOf was interrupted: " + e);
        }
    }

    private static boolean isSameResolvedComponent(ResolveInfo a, ResolverActivity.ResolvedComponentInfo b) {
        ActivityInfo ai = a.activityInfo;
        return ai.packageName.equals(b.name.getPackageName()) && ai.name.equals(b.name.getClassName());
    }

    boolean isComponentFiltered(ComponentName componentName) {
        return false;
    }

    @VisibleForTesting
    public float getScore(DisplayResolveInfo target) {
        return this.mResolverComparator.getScore(target.getResolvedComponentName());
    }

    public float getScore(ComponentName componentName) {
        return this.mResolverComparator.getScore(componentName);
    }

    public List<ComponentName> getTopComponentNames(int topK) {
        return this.mResolverComparator.getTopComponentNames(topK);
    }

    public void updateModel(ComponentName componentName) {
        this.mResolverComparator.updateModel(componentName);
    }

    public void updateChooserCounts(String packageName, int userId, String action) {
        this.mResolverComparator.updateChooserCounts(packageName, userId, action);
    }

    public void destroy() {
        this.mResolverComparator.destroy();
    }

    private class ComputeCallback
    implements AbstractResolverComparator.AfterCompute {
        private CountDownLatch mFinishComputeSignal;

        public ComputeCallback(CountDownLatch finishComputeSignal) {
            this.mFinishComputeSignal = finishComputeSignal;
        }

        @Override
        public void afterCompute() {
            this.mFinishComputeSignal.countDown();
        }
    }
}

