/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.UserHandle;
import android.os._Original_Build;
import android.provider.Settings;

public class EmergencyAffordanceManager {
    public static final boolean ENABLED = true;
    private static final String EMERGENCY_CALL_NUMBER_SETTING = "emergency_affordance_number";
    private static final String FORCE_EMERGENCY_AFFORDANCE_SETTING = "force_emergency_affordance";
    private final Context mContext;

    public EmergencyAffordanceManager(Context context) {
        this.mContext = context;
    }

    public void performEmergencyCall() {
        EmergencyAffordanceManager.performEmergencyCall(this.mContext);
    }

    private static Uri getPhoneUri(Context context) {
        String override;
        String number = context.getResources().getString(17039933);
        if (_Original_Build.IS_DEBUGGABLE && (override = Settings.Global.getString(context.getContentResolver(), EMERGENCY_CALL_NUMBER_SETTING)) != null) {
            number = override;
        }
        return Uri.fromParts("tel", number, null);
    }

    private static void performEmergencyCall(Context context) {
        Intent intent = new Intent("android.intent.action.CALL_EMERGENCY");
        intent.setData(EmergencyAffordanceManager.getPhoneUri(context));
        intent.setFlags(0x10000000);
        context.startActivityAsUser(intent, UserHandle.CURRENT);
    }

    public boolean needsEmergencyAffordance() {
        if (this.forceShowing()) {
            return true;
        }
        return this.isEmergencyAffordanceNeeded();
    }

    private boolean isEmergencyAffordanceNeeded() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), "emergency_affordance_needed", 0) != 0;
    }

    private boolean forceShowing() {
        return Settings.Global.getInt(this.mContext.getContentResolver(), FORCE_EMERGENCY_AFFORDANCE_SETTING, 0) != 0;
    }
}

