/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.util;

import android.os.SystemClock_Delegate;
import android.util.Pair;
import android.view.Choreographer;
import com.android.ide.common.rendering.api.ILayoutLog;
import java.util.ArrayList;

public class ChoreographerCallbacks {
    private final RangeList<Pair<Object, Long>> mCallbacks = new RangeList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object action, long delayMillis) {
        RangeList<Pair<Object, Long>> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            int idx;
            long now = SystemClock_Delegate.uptimeMillis();
            long dueTime = now + delayMillis;
            for (idx = 0; idx < this.mCallbacks.size() && (Long)((Pair)this.mCallbacks.get((int)idx)).second <= dueTime; ++idx) {
            }
            this.mCallbacks.add(idx, Pair.create(action, dueTime));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object action) {
        RangeList<Pair<Object, Long>> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            this.mCallbacks.removeIf(el -> el.first == action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(long currentTimeMs, ILayoutLog logger) {
        ArrayList toExecute;
        long currentTimeNanos = currentTimeMs * 1000000L;
        RangeList<Pair<Object, Long>> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            int idx;
            for (idx = 0; idx < this.mCallbacks.size() && (Long)((Pair)this.mCallbacks.get((int)idx)).second <= currentTimeMs; ++idx) {
            }
            toExecute = new ArrayList(this.mCallbacks.subList(0, idx));
            ((RangeList)this.mCallbacks).removeFrontElements(idx);
        }
        toExecute.forEach(p -> ChoreographerCallbacks.executeSafely(p.first, currentTimeNanos, logger));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        RangeList<Pair<Object, Long>> rangeList = this.mCallbacks;
        synchronized (rangeList) {
            this.mCallbacks.clear();
        }
    }

    private static void executeSafely(Object action, long frameTimeNanos, ILayoutLog logger) {
        try {
            if (action instanceof Choreographer.FrameCallback) {
                Choreographer.FrameCallback callback = (Choreographer.FrameCallback)action;
                callback.doFrame(frameTimeNanos);
            } else if (action instanceof Runnable) {
                Runnable runnable = (Runnable)action;
                runnable.run();
            } else {
                logger.error("broken", "Unexpected action as Choreographer callback", null, null);
            }
        }
        catch (Throwable t) {
            logger.error("broken", "Failed executing Choreographer callback", t, null, null);
        }
    }

    private static class RangeList<T>
    extends ArrayList<T> {
        private RangeList() {
        }

        private void removeFrontElements(int n) {
            this.removeRange(0, n);
        }
    }
}

