/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.apps.common.testing.accessibility.framework.integrations.espresso;

import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResult;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityCheckResultDescriptor;
import com.google.android.apps.common.testing.accessibility.framework.AccessibilityViewCheckResult;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AccessibilityViewCheckException
extends com.google.android.apps.common.testing.accessibility.framework.integrations.AccessibilityViewCheckException {
    private final @Nullable AccessibilityCheckResultDescriptor resultDescriptor;
    private final @Nullable AccessibilityCheckResult.AccessibilityCheckResultDescriptor deprecatedResultDescriptor;

    public AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results) {
        this(results, new AccessibilityCheckResultDescriptor());
    }

    public AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results, AccessibilityCheckResultDescriptor resultDescriptor) {
        this(results, (AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)resultDescriptor), null);
    }

    @Deprecated
    public AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results, AccessibilityCheckResult.AccessibilityCheckResultDescriptor deprecatedResultDescriptor) {
        this(results, null, (AccessibilityCheckResult.AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)deprecatedResultDescriptor));
    }

    private AccessibilityViewCheckException(List<AccessibilityViewCheckResult> results, @Nullable AccessibilityCheckResultDescriptor resultDescriptor, @Nullable AccessibilityCheckResult.AccessibilityCheckResultDescriptor deprecatedResultDescriptor) {
        super(results);
        Preconditions.checkArgument((results != null && !results.isEmpty() ? 1 : 0) != 0, (Object)"AccessibilityViewCheckException requires at least 1 AccessibilityViewCheckResult");
        Preconditions.checkArgument((resultDescriptor != null || deprecatedResultDescriptor != null ? 1 : 0) != 0);
        this.resultDescriptor = resultDescriptor;
        this.deprecatedResultDescriptor = deprecatedResultDescriptor;
    }

    @Override
    public String getMessage() {
        List<AccessibilityViewCheckResult> results = this.getResults();
        StringBuilder exceptionMessage = new StringBuilder();
        String resultCountMessage = results.size() == 1 ? "There was 1 accessibility result:\n" : String.format(Locale.US, "There were %d accessibility results:\n", results.size());
        exceptionMessage.append(resultCountMessage);
        for (int i = 0; i < results.size(); ++i) {
            if (i > 0) {
                exceptionMessage.append(",\n");
            }
            AccessibilityViewCheckResult result = results.get(i);
            exceptionMessage.append(this.resultDescriptor != null ? this.resultDescriptor.describeResult(result) : ((AccessibilityCheckResult.AccessibilityCheckResultDescriptor)Preconditions.checkNotNull((Object)this.deprecatedResultDescriptor)).describeResult(result));
        }
        return exceptionMessage.toString();
    }
}

