/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityThreadInternal;
import android.app.Application;
import android.app.ResourcesManager;
import android.content.ComponentCallbacks2;
import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.HardwareRenderer;
import android.inputmethodservice.InputMethodService;
import android.os.LocaleList;
import android.os.Trace;
import android.os._Original_Build;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.ContextThemeWrapper;
import android.view.WindowManagerGlobal;
import com.android.internal.annotations.GuardedBy;
import java.util.ArrayList;
import java.util.Locale;

class ConfigurationController {
    private static final String TAG = "ConfigurationController";
    private final ActivityThreadInternal mActivityThread;
    private final ResourcesManager mResourcesManager = ResourcesManager.getInstance();
    @GuardedBy(value={"mResourcesManager"})
    private Configuration mPendingConfiguration;
    private Configuration mCompatConfiguration;
    private Configuration mConfiguration;

    ConfigurationController(ActivityThreadInternal activityThread) {
        this.mActivityThread = activityThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration updatePendingConfiguration(Configuration config) {
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mPendingConfiguration == null || this.mPendingConfiguration.isOtherSeqNewer(config)) {
                this.mPendingConfiguration = config;
                return this.mPendingConfiguration;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Configuration getPendingConfiguration(boolean clearPending) {
        Configuration outConfig = null;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            if (this.mPendingConfiguration != null) {
                outConfig = this.mPendingConfiguration;
                if (clearPending) {
                    this.mPendingConfiguration = null;
                }
            }
        }
        return outConfig;
    }

    void setCompatConfiguration(Configuration config) {
        this.mCompatConfiguration = new Configuration(config);
    }

    Configuration getCompatConfiguration() {
        return this.mCompatConfiguration;
    }

    Configuration applyCompatConfiguration() {
        Configuration config = this.mConfiguration;
        int displayDensity = config.densityDpi;
        if (this.mCompatConfiguration == null) {
            this.mCompatConfiguration = new Configuration();
        }
        this.mCompatConfiguration.setTo(this.mConfiguration);
        if (this.mResourcesManager.applyCompatConfiguration(displayDensity, this.mCompatConfiguration)) {
            config = this.mCompatConfiguration;
        }
        return config;
    }

    void setConfiguration(Configuration config) {
        this.mConfiguration = new Configuration(config);
    }

    Configuration getConfiguration() {
        return this.mConfiguration;
    }

    void handleConfigurationChanged(Configuration config) {
        if (this.mActivityThread.isCachedProcessState()) {
            this.updatePendingConfiguration(config);
            return;
        }
        Trace.traceBegin(64L, "configChanged");
        this.handleConfigurationChanged(config, null);
        Trace.traceEnd(64L);
    }

    void handleConfigurationChanged(CompatibilityInfo compat) {
        this.handleConfigurationChanged(this.mConfiguration, compat);
        WindowManagerGlobal.getInstance().reportNewConfiguration(this.mConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleConfigurationChanged(Configuration config, CompatibilityInfo compat) {
        int configDiff;
        boolean equivalent;
        ResourcesManager resourcesManager = this.mResourcesManager;
        synchronized (resourcesManager) {
            Resources.Theme systemTheme = this.mActivityThread.getSystemContext().getTheme();
            Resources.Theme systemUiTheme = this.mActivityThread.getSystemUiContext().getTheme();
            if (this.mPendingConfiguration != null) {
                if (!this.mPendingConfiguration.isOtherSeqNewer(config)) {
                    config = this.mPendingConfiguration;
                    this.updateDefaultDensity(config.densityDpi);
                }
                this.mPendingConfiguration = null;
            }
            boolean hasIme = this.mActivityThread.hasImeComponent();
            if (config == null) {
                if (_Original_Build.IS_DEBUGGABLE && hasIme) {
                    Log.w(TAG, "handleConfigurationChanged for IME app but config is null");
                }
                return;
            }
            equivalent = this.mConfiguration != null && 0 == this.mConfiguration.diffPublicOnly(config);
            Application app = this.mActivityThread.getApplication();
            Resources appResources = app.getResources();
            if (appResources.hasOverrideDisplayAdjustments()) {
                appResources.getDisplayAdjustments().getConfiguration().updateFrom(config);
            }
            this.mResourcesManager.applyConfigurationToResources(config, compat, appResources.getDisplayAdjustments());
            this.updateLocaleListFromAppContext(app.getApplicationContext());
            if (this.mConfiguration == null) {
                this.mConfiguration = new Configuration();
            }
            if (!this.mConfiguration.isOtherSeqNewer(config) && compat == null) {
                if (_Original_Build.IS_DEBUGGABLE && hasIme) {
                    Log.w(TAG, "handleConfigurationChanged for IME app but config seq is obsolete , config=" + config + ", mConfiguration=" + this.mConfiguration);
                }
                return;
            }
            configDiff = this.mConfiguration.updateFrom(config);
            config = this.applyCompatConfiguration();
            HardwareRenderer.sendDeviceConfigurationForDebugging(config);
            if ((systemTheme.getChangingConfigurations() & configDiff) != 0) {
                systemTheme.rebase();
            }
            if ((systemUiTheme.getChangingConfigurations() & configDiff) != 0) {
                systemUiTheme.rebase();
            }
        }
        ArrayList<ComponentCallbacks2> callbacks = this.mActivityThread.collectComponentCallbacks(false);
        ConfigurationController.freeTextLayoutCachesIfNeeded(configDiff);
        if (callbacks != null) {
            int size = callbacks.size();
            for (int i = 0; i < size; ++i) {
                ComponentCallbacks2 cb = callbacks.get(i);
                if (!equivalent) {
                    this.performConfigurationChanged(cb, config);
                    continue;
                }
                if (!_Original_Build.IS_DEBUGGABLE || !(cb instanceof InputMethodService)) continue;
                Log.w(TAG, "performConfigurationChanged didn't callback to IME , configDiff=" + configDiff + ", mConfiguration=" + this.mConfiguration);
            }
        }
    }

    void performConfigurationChanged(ComponentCallbacks2 cb, Configuration newConfig) {
        Configuration contextThemeWrapperOverrideConfig = null;
        if (cb instanceof ContextThemeWrapper) {
            ContextThemeWrapper contextThemeWrapper = (ContextThemeWrapper)((Object)cb);
            contextThemeWrapperOverrideConfig = contextThemeWrapper.getOverrideConfiguration();
        }
        Configuration configToReport = ConfigurationController.createNewConfigAndUpdateIfNotNull(newConfig, contextThemeWrapperOverrideConfig);
        cb.onConfigurationChanged(configToReport);
    }

    void updateDefaultDensity(int densityDpi) {
        if (!this.mActivityThread.isInDensityCompatMode() && densityDpi != 0 && densityDpi != DisplayMetrics.DENSITY_DEVICE) {
            DisplayMetrics.DENSITY_DEVICE = densityDpi;
            Bitmap.setDefaultDensity(densityDpi);
        }
    }

    int getCurDefaultDisplayDpi() {
        return this.mConfiguration.densityDpi;
    }

    void updateLocaleListFromAppContext(Context context) {
        Locale bestLocale = context.getResources().getConfiguration().getLocales().get(0);
        LocaleList newLocaleList = this.mResourcesManager.getConfiguration().getLocales();
        int newLocaleListSize = newLocaleList.size();
        for (int i = 0; i < newLocaleListSize; ++i) {
            if (!bestLocale.equals(newLocaleList.get(i))) continue;
            LocaleList.setDefault(newLocaleList, i);
            return;
        }
        LocaleList.setDefault(new LocaleList(bestLocale, newLocaleList));
    }

    static Configuration createNewConfigAndUpdateIfNotNull(Configuration base, Configuration override) {
        if (override == null) {
            return base;
        }
        Configuration newConfig = new Configuration(base);
        newConfig.updateFrom(override);
        return newConfig;
    }

    static void freeTextLayoutCachesIfNeeded(int configDiff) {
        if (configDiff != 0) {
            boolean hasLocaleConfigChange;
            boolean bl = hasLocaleConfigChange = (configDiff & 4) != 0;
            if (hasLocaleConfigChange) {
                Canvas.freeTextLayoutCaches();
            }
        }
    }
}

