/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.annotation.RequiresPermission;
import android.content.ComponentName;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.service.dreams.IDreamManager;

public class DreamManager {
    private final IDreamManager mService = IDreamManager.Stub.asInterface(ServiceManager.getServiceOrThrow("dreams"));
    private final Context mContext;

    public DreamManager(Context context) throws ServiceManager.ServiceNotFoundException {
        this.mContext = context;
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void startDream(ComponentName name) {
        try {
            this.mService.dream();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void stopDream() {
        try {
            this.mService.awaken();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.WRITE_DREAM_STATE")
    public void setActiveDream(ComponentName dreamComponent) {
        ComponentName[] dreams = new ComponentName[]{dreamComponent};
        try {
            this.mService.setDreamComponentsForUser(this.mContext.getUserId(), dreams);
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
        }
    }

    @RequiresPermission(value="android.permission.READ_DREAM_STATE")
    public boolean isDreaming() {
        try {
            return this.mService.isDreaming();
        }
        catch (RemoteException e) {
            e.rethrowFromSystemServer();
            return false;
        }
    }
}

