/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.RemoteException;

public interface ITransientNotificationCallback
extends IInterface {
    public static final String DESCRIPTOR = "android.app.ITransientNotificationCallback";

    public void onToastShown() throws RemoteException;

    public void onToastHidden() throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements ITransientNotificationCallback {
        static final int TRANSACTION_onToastShown = 1;
        static final int TRANSACTION_onToastHidden = 2;

        public Stub() {
            this.attachInterface(this, ITransientNotificationCallback.DESCRIPTOR);
        }

        public static ITransientNotificationCallback asInterface(IBinder obj) {
            if (obj == null) {
                return null;
            }
            IInterface iin = obj.queryLocalInterface(ITransientNotificationCallback.DESCRIPTOR);
            if (iin != null && iin instanceof ITransientNotificationCallback) {
                return (ITransientNotificationCallback)iin;
            }
            return new Proxy(obj);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        public static String getDefaultTransactionName(int transactionCode) {
            switch (transactionCode) {
                case 1: {
                    return "onToastShown";
                }
                case 2: {
                    return "onToastHidden";
                }
            }
            return null;
        }

        @Override
        public String getTransactionName(int transactionCode) {
            return Stub.getDefaultTransactionName(transactionCode);
        }

        @Override
        public boolean onTransact(int code, Parcel data, Parcel reply, int flags) throws RemoteException {
            String descriptor = ITransientNotificationCallback.DESCRIPTOR;
            switch (code) {
                case 1598968902: {
                    reply.writeString(descriptor);
                    return true;
                }
            }
            switch (code) {
                case 1: {
                    data.enforceInterface(descriptor);
                    this.onToastShown();
                    return true;
                }
                case 2: {
                    data.enforceInterface(descriptor);
                    this.onToastHidden();
                    return true;
                }
            }
            return super.onTransact(code, data, reply, flags);
        }

        public static boolean setDefaultImpl(ITransientNotificationCallback impl) {
            if (Proxy.sDefaultImpl != null) {
                throw new IllegalStateException("setDefaultImpl() called twice");
            }
            if (impl != null) {
                Proxy.sDefaultImpl = impl;
                return true;
            }
            return false;
        }

        public static ITransientNotificationCallback getDefaultImpl() {
            return Proxy.sDefaultImpl;
        }

        private static class Proxy
        implements ITransientNotificationCallback {
            private IBinder mRemote;
            public static ITransientNotificationCallback sDefaultImpl;

            Proxy(IBinder remote) {
                this.mRemote = remote;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            public String getInterfaceDescriptor() {
                return ITransientNotificationCallback.DESCRIPTOR;
            }

            @Override
            public void onToastShown() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITransientNotificationCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(1, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onToastShown();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }

            @Override
            public void onToastHidden() throws RemoteException {
                Parcel _data = Parcel.obtain();
                try {
                    _data.writeInterfaceToken(ITransientNotificationCallback.DESCRIPTOR);
                    boolean _status = this.mRemote.transact(2, _data, null, 1);
                    if (!_status && Stub.getDefaultImpl() != null) {
                        Stub.getDefaultImpl().onToastHidden();
                        return;
                    }
                }
                finally {
                    _data.recycle();
                }
            }
        }
    }

    public static class Default
    implements ITransientNotificationCallback {
        @Override
        public void onToastShown() throws RemoteException {
        }

        @Override
        public void onToastHidden() throws RemoteException {
        }

        @Override
        public IBinder asBinder() {
            return null;
        }
    }
}

