/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.graphics.drawable.Icon;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class NotificationHistory
implements Parcelable {
    private List<HistoricalNotification> mNotificationsToWrite = new ArrayList<HistoricalNotification>();
    private Set<String> mStringsToWrite = new HashSet<String>();
    private Parcel mParcel = null;
    private int mHistoryCount;
    private int mIndex = 0;
    private String[] mStringPool;
    public static final Parcelable.Creator<NotificationHistory> CREATOR = new Parcelable.Creator<NotificationHistory>(){

        @Override
        public NotificationHistory createFromParcel(Parcel source) {
            return new NotificationHistory(source);
        }

        public NotificationHistory[] newArray(int size) {
            return new NotificationHistory[size];
        }
    };

    private NotificationHistory(Parcel in) {
        byte[] bytes = in.readBlob();
        Parcel data = Parcel.obtain();
        data.unmarshall(bytes, 0, bytes.length);
        data.setDataPosition(0);
        this.mHistoryCount = data.readInt();
        this.mIndex = data.readInt();
        if (this.mHistoryCount > 0) {
            this.mStringPool = data.createStringArray();
            int listByteLength = data.readInt();
            int positionInParcel = data.readInt();
            this.mParcel = Parcel.obtain();
            this.mParcel.setDataPosition(0);
            this.mParcel.appendFrom(data, data.dataPosition(), listByteLength);
            this.mParcel.setDataSize(this.mParcel.dataPosition());
            this.mParcel.setDataPosition(positionInParcel);
        }
    }

    public NotificationHistory() {
        this.mHistoryCount = 0;
    }

    public boolean hasNextNotification() {
        return this.mIndex < this.mHistoryCount;
    }

    public HistoricalNotification getNextNotification() {
        if (!this.hasNextNotification()) {
            return null;
        }
        HistoricalNotification n = this.readNotificationFromParcel(this.mParcel);
        ++this.mIndex;
        if (!this.hasNextNotification()) {
            this.mParcel.recycle();
            this.mParcel = null;
        }
        return n;
    }

    public void addPooledStrings(List<String> strings) {
        this.mStringsToWrite.addAll(strings);
    }

    public void poolStringsFromNotifications() {
        this.mStringsToWrite.clear();
        for (int i = 0; i < this.mNotificationsToWrite.size(); ++i) {
            HistoricalNotification notification = this.mNotificationsToWrite.get(i);
            this.mStringsToWrite.add(notification.getPackage());
            this.mStringsToWrite.add(notification.getChannelName());
            this.mStringsToWrite.add(notification.getChannelId());
            if (TextUtils.isEmpty(notification.getConversationId())) continue;
            this.mStringsToWrite.add(notification.getConversationId());
        }
    }

    public void addNotificationToWrite(HistoricalNotification notification) {
        if (notification == null) {
            return;
        }
        this.mNotificationsToWrite.add(notification);
        ++this.mHistoryCount;
    }

    public void addNewNotificationToWrite(HistoricalNotification notification) {
        if (notification == null) {
            return;
        }
        this.mNotificationsToWrite.add(0, notification);
        ++this.mHistoryCount;
    }

    public void addNotificationsToWrite(NotificationHistory notificationHistory) {
        for (HistoricalNotification hn : notificationHistory.getNotificationsToWrite()) {
            this.addNotificationToWrite(hn);
        }
        Collections.sort(this.mNotificationsToWrite, (o1, o2) -> -1 * Long.compare(o1.getPostedTimeMs(), o2.getPostedTimeMs()));
        this.poolStringsFromNotifications();
    }

    public void removeNotificationsFromWrite(String packageName) {
        for (int i = this.mNotificationsToWrite.size() - 1; i >= 0; --i) {
            if (!packageName.equals(this.mNotificationsToWrite.get(i).getPackage())) continue;
            this.mNotificationsToWrite.remove(i);
        }
        this.poolStringsFromNotifications();
    }

    public boolean removeNotificationFromWrite(String packageName, long postedTime) {
        boolean removed = false;
        for (int i = this.mNotificationsToWrite.size() - 1; i >= 0; --i) {
            HistoricalNotification hn = this.mNotificationsToWrite.get(i);
            if (!packageName.equals(hn.getPackage()) || postedTime != hn.getPostedTimeMs()) continue;
            removed = true;
            this.mNotificationsToWrite.remove(i);
        }
        if (removed) {
            this.poolStringsFromNotifications();
        }
        return removed;
    }

    public boolean removeConversationsFromWrite(String packageName, Set<String> conversationIds) {
        boolean removed = false;
        for (int i = this.mNotificationsToWrite.size() - 1; i >= 0; --i) {
            HistoricalNotification hn = this.mNotificationsToWrite.get(i);
            if (!packageName.equals(hn.getPackage()) || hn.getConversationId() == null || !conversationIds.contains(hn.getConversationId())) continue;
            removed = true;
            this.mNotificationsToWrite.remove(i);
        }
        if (removed) {
            this.poolStringsFromNotifications();
        }
        return removed;
    }

    public boolean removeChannelFromWrite(String packageName, String channelId) {
        boolean removed = false;
        for (int i = this.mNotificationsToWrite.size() - 1; i >= 0; --i) {
            HistoricalNotification hn = this.mNotificationsToWrite.get(i);
            if (!packageName.equals(hn.getPackage()) || !Objects.equals(channelId, hn.getChannelId())) continue;
            removed = true;
            this.mNotificationsToWrite.remove(i);
        }
        if (removed) {
            this.poolStringsFromNotifications();
        }
        return removed;
    }

    public String[] getPooledStringsToWrite() {
        Object[] stringsToWrite = this.mStringsToWrite.toArray(new String[0]);
        Arrays.sort(stringsToWrite);
        return stringsToWrite;
    }

    public List<HistoricalNotification> getNotificationsToWrite() {
        return this.mNotificationsToWrite;
    }

    public int getHistoryCount() {
        return this.mHistoryCount;
    }

    private int findStringIndex(String str) {
        int index = Arrays.binarySearch(this.mStringPool, str);
        if (index < 0) {
            throw new IllegalStateException("String '" + str + "' is not in the string pool");
        }
        return index;
    }

    private void writeNotificationToParcel(HistoricalNotification notification, Parcel p, int flags) {
        int packageIndex = notification.mPackage != null ? this.findStringIndex(notification.mPackage) : -1;
        int channelNameIndex = notification.getChannelName() != null ? this.findStringIndex(notification.getChannelName()) : -1;
        int channelIdIndex = notification.getChannelId() != null ? this.findStringIndex(notification.getChannelId()) : -1;
        int conversationIdIndex = !TextUtils.isEmpty(notification.getConversationId()) ? this.findStringIndex(notification.getConversationId()) : -1;
        p.writeInt(packageIndex);
        p.writeInt(channelNameIndex);
        p.writeInt(channelIdIndex);
        p.writeInt(conversationIdIndex);
        p.writeInt(notification.getUid());
        p.writeInt(notification.getUserId());
        p.writeLong(notification.getPostedTimeMs());
        p.writeString(notification.getTitle());
        p.writeString(notification.getText());
        notification.getIcon().writeToParcel(p, flags);
    }

    private HistoricalNotification readNotificationFromParcel(Parcel p) {
        HistoricalNotification.Builder notificationOut = new HistoricalNotification.Builder();
        int packageIndex = p.readInt();
        if (packageIndex >= 0) {
            notificationOut.mPackage = this.mStringPool[packageIndex];
        } else {
            notificationOut.mPackage = null;
        }
        int channelNameIndex = p.readInt();
        if (channelNameIndex >= 0) {
            notificationOut.setChannelName(this.mStringPool[channelNameIndex]);
        } else {
            notificationOut.setChannelName(null);
        }
        int channelIdIndex = p.readInt();
        if (channelIdIndex >= 0) {
            notificationOut.setChannelId(this.mStringPool[channelIdIndex]);
        } else {
            notificationOut.setChannelId(null);
        }
        int conversationIdIndex = p.readInt();
        if (conversationIdIndex >= 0) {
            notificationOut.setConversationId(this.mStringPool[conversationIdIndex]);
        } else {
            notificationOut.setConversationId(null);
        }
        notificationOut.setUid(p.readInt());
        notificationOut.setUserId(p.readInt());
        notificationOut.setPostedTimeMs(p.readLong());
        notificationOut.setTitle(p.readString());
        notificationOut.setText(p.readString());
        notificationOut.setIcon(Icon.CREATOR.createFromParcel(p));
        return notificationOut.build();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeToParcel(Parcel dest, int flags) {
        Parcel data = Parcel.obtain();
        data.writeInt(this.mHistoryCount);
        data.writeInt(this.mIndex);
        if (this.mHistoryCount > 0) {
            this.mStringPool = this.getPooledStringsToWrite();
            data.writeStringArray(this.mStringPool);
            if (!this.mNotificationsToWrite.isEmpty()) {
                Parcel p = Parcel.obtain();
                try {
                    p.setDataPosition(0);
                    for (int i = 0; i < this.mHistoryCount; ++i) {
                        HistoricalNotification notification = this.mNotificationsToWrite.get(i);
                        this.writeNotificationToParcel(notification, p, flags);
                    }
                    int listByteLength = p.dataPosition();
                    data.writeInt(listByteLength);
                    data.writeInt(0);
                    data.appendFrom(p, 0, listByteLength);
                }
                finally {
                    p.recycle();
                }
            } else if (this.mParcel != null) {
                data.writeInt(this.mParcel.dataSize());
                data.writeInt(this.mParcel.dataPosition());
                data.appendFrom(this.mParcel, 0, this.mParcel.dataSize());
            } else {
                throw new IllegalStateException("Either mParcel or mNotificationsToWrite must not be null");
            }
        }
        dest.writeBlob(data.marshall());
    }

    public static class HistoricalNotification {
        private String mPackage;
        private String mChannelName;
        private String mChannelId;
        private int mUid;
        private int mUserId;
        private long mPostedTimeMs;
        private String mTitle;
        private String mText;
        private Icon mIcon;
        private String mConversationId;

        private HistoricalNotification() {
        }

        public String getPackage() {
            return this.mPackage;
        }

        public String getChannelName() {
            return this.mChannelName;
        }

        public String getChannelId() {
            return this.mChannelId;
        }

        public int getUid() {
            return this.mUid;
        }

        public int getUserId() {
            return this.mUserId;
        }

        public long getPostedTimeMs() {
            return this.mPostedTimeMs;
        }

        public String getTitle() {
            return this.mTitle;
        }

        public String getText() {
            return this.mText;
        }

        public Icon getIcon() {
            return this.mIcon;
        }

        public String getKey() {
            return this.mPackage + "|" + this.mUid + "|" + this.mPostedTimeMs;
        }

        public String getConversationId() {
            return this.mConversationId;
        }

        public String toString() {
            return "HistoricalNotification{key='" + this.getKey() + '\'' + ", mChannelName='" + this.mChannelName + '\'' + ", mChannelId='" + this.mChannelId + '\'' + ", mUserId=" + this.mUserId + ", mUid=" + this.mUid + ", mTitle='" + this.mTitle + '\'' + ", mText='" + this.mText + '\'' + ", mIcon=" + this.mIcon + ", mPostedTimeMs=" + this.mPostedTimeMs + ", mConversationId=" + this.mConversationId + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HistoricalNotification that = (HistoricalNotification)o;
            boolean iconsAreSame = this.getIcon() == null && that.getIcon() == null || this.getIcon() != null && that.getIcon() != null && this.getIcon().sameAs(that.getIcon());
            return this.getUid() == that.getUid() && this.getUserId() == that.getUserId() && this.getPostedTimeMs() == that.getPostedTimeMs() && Objects.equals(this.getPackage(), that.getPackage()) && Objects.equals(this.getChannelName(), that.getChannelName()) && Objects.equals(this.getChannelId(), that.getChannelId()) && Objects.equals(this.getTitle(), that.getTitle()) && Objects.equals(this.getText(), that.getText()) && Objects.equals(this.getConversationId(), that.getConversationId()) && iconsAreSame;
        }

        public int hashCode() {
            return Objects.hash(this.getPackage(), this.getChannelName(), this.getChannelId(), this.getUid(), this.getUserId(), this.getPostedTimeMs(), this.getTitle(), this.getText(), this.getIcon(), this.getConversationId());
        }

        public static class Builder {
            private String mPackage;
            private String mChannelName;
            private String mChannelId;
            private int mUid;
            private int mUserId;
            private long mPostedTimeMs;
            private String mTitle;
            private String mText;
            private Icon mIcon;
            private String mConversationId;

            public Builder setPackage(String aPackage) {
                this.mPackage = aPackage;
                return this;
            }

            public Builder setChannelName(String channelName) {
                this.mChannelName = channelName;
                return this;
            }

            public Builder setChannelId(String channelId) {
                this.mChannelId = channelId;
                return this;
            }

            public Builder setUid(int uid) {
                this.mUid = uid;
                return this;
            }

            public Builder setUserId(int userId) {
                this.mUserId = userId;
                return this;
            }

            public Builder setPostedTimeMs(long postedTimeMs) {
                this.mPostedTimeMs = postedTimeMs;
                return this;
            }

            public Builder setTitle(String title) {
                this.mTitle = title;
                return this;
            }

            public Builder setText(String text) {
                this.mText = text;
                return this;
            }

            public Builder setIcon(Icon icon) {
                this.mIcon = icon;
                return this;
            }

            public Builder setConversationId(String conversationId) {
                this.mConversationId = conversationId;
                return this;
            }

            public HistoricalNotification build() {
                HistoricalNotification n = new HistoricalNotification();
                n.mPackage = this.mPackage;
                n.mChannelName = this.mChannelName;
                n.mChannelId = this.mChannelId;
                n.mUid = this.mUid;
                n.mUserId = this.mUserId;
                n.mPostedTimeMs = this.mPostedTimeMs;
                n.mTitle = this.mTitle;
                n.mText = this.mText;
                n.mIcon = this.mIcon;
                n.mConversationId = this.mConversationId;
                return n;
            }
        }
    }
}

