/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManager;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Size;
import com.android.internal.graphics.ColorUtils;
import com.android.internal.graphics.cam.Cam;
import com.android.internal.graphics.palette.CelebiQuantizer;
import com.android.internal.graphics.palette.Palette;
import com.android.internal.graphics.palette.VariationalKMeansQuantizer;
import com.android.internal.util.ContrastColorUtil;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WallpaperColors
implements Parcelable {
    private static final boolean DEBUG_DARK_PIXELS = false;
    public static final int HINT_SUPPORTS_DARK_TEXT = 1;
    public static final int HINT_SUPPORTS_DARK_THEME = 2;
    public static final int HINT_FROM_BITMAP = 4;
    private static final int MAX_BITMAP_SIZE = 112;
    private static final int MAX_WALLPAPER_EXTRACTION_AREA = 12544;
    private static final float MIN_COLOR_OCCURRENCE = 0.05f;
    private static final float DARK_THEME_MEAN_LUMINANCE = 0.3f;
    private static final float BRIGHT_IMAGE_MEAN_LUMINANCE = 0.7f;
    private static final float DARK_PIXEL_CONTRAST = 5.5f;
    private static final float MAX_DARK_AREA = 0.05f;
    private final List<Color> mMainColors;
    private final Map<Integer, Integer> mAllColors;
    private int mColorHints;
    public static final Parcelable.Creator<WallpaperColors> CREATOR = new Parcelable.Creator<WallpaperColors>(){

        @Override
        public WallpaperColors createFromParcel(Parcel in) {
            return new WallpaperColors(in);
        }

        public WallpaperColors[] newArray(int size) {
            return new WallpaperColors[size];
        }
    };

    public WallpaperColors(Parcel parcel) {
        int colorInt;
        int i;
        this.mMainColors = new ArrayList<Color>();
        this.mAllColors = new HashMap<Integer, Integer>();
        int count = parcel.readInt();
        for (i = 0; i < count; ++i) {
            colorInt = parcel.readInt();
            Color color2 = Color.valueOf(colorInt);
            this.mMainColors.add(color2);
        }
        count = parcel.readInt();
        for (i = 0; i < count; ++i) {
            colorInt = parcel.readInt();
            int population = parcel.readInt();
            this.mAllColors.put(colorInt, population);
        }
        this.mColorHints = parcel.readInt();
    }

    public static WallpaperColors fromDrawable(Drawable drawable2) {
        if (drawable2 == null) {
            throw new IllegalArgumentException("Drawable cannot be null");
        }
        Rect initialBounds = drawable2.copyBounds();
        int width = drawable2.getIntrinsicWidth();
        int height = drawable2.getIntrinsicHeight();
        if (width <= 0 || height <= 0) {
            width = 112;
            height = 112;
        }
        Size optimalSize = WallpaperColors.calculateOptimalSize(width, height);
        Bitmap bitmap = Bitmap.createBitmap(optimalSize.getWidth(), optimalSize.getHeight(), Bitmap.Config.ARGB_8888);
        Canvas bmpCanvas = new Canvas(bitmap);
        drawable2.setBounds(0, 0, bitmap.getWidth(), bitmap.getHeight());
        drawable2.draw(bmpCanvas);
        WallpaperColors colors = WallpaperColors.fromBitmap(bitmap);
        bitmap.recycle();
        drawable2.setBounds(initialBounds);
        return colors;
    }

    public static WallpaperColors fromBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            throw new IllegalArgumentException("Bitmap can't be null");
        }
        int bitmapArea = bitmap.getWidth() * bitmap.getHeight();
        boolean shouldRecycle = false;
        if (bitmapArea > 12544) {
            shouldRecycle = true;
            Size optimalSize = WallpaperColors.calculateOptimalSize(bitmap.getWidth(), bitmap.getHeight());
            bitmap = Bitmap.createScaledBitmap(bitmap, optimalSize.getWidth(), optimalSize.getHeight(), false);
        }
        Palette palette = ActivityManager.isLowRamDeviceStatic() ? Palette.from(bitmap, new VariationalKMeansQuantizer()).maximumColorCount(5).resizeBitmapArea(12544).generate() : Palette.from(bitmap, new CelebiQuantizer()).maximumColorCount(128).resizeBitmapArea(12544).generate();
        ArrayList<Palette.Swatch> swatches = new ArrayList<Palette.Swatch>(palette.getSwatches());
        swatches.sort((a, b) -> b.getPopulation() - a.getPopulation());
        int swatchesSize = swatches.size();
        HashMap<Integer, Integer> populationByColor = new HashMap<Integer, Integer>();
        for (int i = 0; i < swatchesSize; ++i) {
            Palette.Swatch swatch = swatches.get(i);
            int colorInt = swatch.getInt();
            populationByColor.put(colorInt, swatch.getPopulation());
        }
        int hints = WallpaperColors.calculateDarkHints(bitmap);
        if (shouldRecycle) {
            bitmap.recycle();
        }
        return new WallpaperColors(populationByColor, 4 | hints);
    }

    public WallpaperColors(Color primaryColor, Color secondaryColor, Color tertiaryColor) {
        this(primaryColor, secondaryColor, tertiaryColor, 0);
        float[] tmpHsl = new float[3];
        ColorUtils.colorToHSL(primaryColor.toArgb(), tmpHsl);
        float luminance = tmpHsl[2];
        if (luminance < 0.3f) {
            this.mColorHints |= 2;
        }
    }

    public WallpaperColors(Color primaryColor, Color secondaryColor, Color tertiaryColor, int colorHints) {
        if (primaryColor == null) {
            throw new IllegalArgumentException("Primary color should never be null.");
        }
        this.mMainColors = new ArrayList<Color>(3);
        this.mAllColors = new HashMap<Integer, Integer>();
        this.mMainColors.add(primaryColor);
        this.mAllColors.put(primaryColor.toArgb(), 0);
        if (secondaryColor != null) {
            this.mMainColors.add(secondaryColor);
            this.mAllColors.put(secondaryColor.toArgb(), 0);
        }
        if (tertiaryColor != null) {
            if (secondaryColor == null) {
                throw new IllegalArgumentException("tertiaryColor can't be specified when secondaryColor is null");
            }
            this.mMainColors.add(tertiaryColor);
            this.mAllColors.put(tertiaryColor.toArgb(), 0);
        }
        this.mColorHints = colorHints;
    }

    public WallpaperColors(Map<Integer, Integer> colorToPopulation, int colorHints) {
        this.mAllColors = colorToPopulation;
        HashMap<Integer, Cam> colorToCam = new HashMap<Integer, Cam>();
        for (int color2 : colorToPopulation.keySet()) {
            colorToCam.put(color2, Cam.fromInt(color2));
        }
        double[] hueProportions = WallpaperColors.hueProportions(colorToCam, colorToPopulation);
        Map<Integer, Double> colorToHueProportion = WallpaperColors.colorToHueProportion(colorToPopulation.keySet(), colorToCam, hueProportions);
        HashMap<Integer, Double> colorToScore = new HashMap<Integer, Double>();
        for (Map.Entry<Integer, Double> mapEntry : colorToHueProportion.entrySet()) {
            int color3 = mapEntry.getKey();
            double proportion = mapEntry.getValue();
            double score = WallpaperColors.score((Cam)colorToCam.get(color3), proportion);
            colorToScore.put(color3, score);
        }
        ArrayList mapEntries = new ArrayList(colorToScore.entrySet());
        mapEntries.sort((a, b) -> ((Double)b.getValue()).compareTo((Double)a.getValue()));
        ArrayList<Integer> colorsByScoreDescending = new ArrayList<Integer>();
        for (Map.Entry colorToScoreEntry : mapEntries) {
            colorsByScoreDescending.add((Integer)colorToScoreEntry.getKey());
        }
        ArrayList<Integer> mainColorInts = new ArrayList<Integer>();
        Iterator colorToScoreEntry = colorsByScoreDescending.iterator();
        block3: while (colorToScoreEntry.hasNext()) {
            int color4 = (Integer)colorToScoreEntry.next();
            Cam cam = (Cam)colorToCam.get(color4);
            Iterator iterator = mainColorInts.iterator();
            while (iterator.hasNext()) {
                int otherColor = (Integer)iterator.next();
                Cam otherCam = (Cam)colorToCam.get(otherColor);
                if (!(WallpaperColors.hueDiff(cam, otherCam) < 15.0)) continue;
                continue block3;
            }
            mainColorInts.add(color4);
        }
        ArrayList<Color> mainColors = new ArrayList<Color>();
        Iterator iterator = mainColorInts.iterator();
        while (iterator.hasNext()) {
            int colorInt = (Integer)iterator.next();
            mainColors.add(Color.valueOf(colorInt));
        }
        this.mMainColors = mainColors;
        this.mColorHints = colorHints;
    }

    private static double hueDiff(Cam a, Cam b) {
        return 180.0f - Math.abs(Math.abs(a.getHue() - b.getHue()) - 180.0f);
    }

    private static double score(Cam cam, double proportion) {
        return (double)cam.getChroma() + proportion * 100.0;
    }

    private static Map<Integer, Double> colorToHueProportion(Set<Integer> colors, Map<Integer, Cam> colorToCam, double[] hueProportions) {
        HashMap<Integer, Double> colorToHueProportion = new HashMap<Integer, Double>();
        for (int color2 : colors) {
            int hue = WallpaperColors.wrapDegrees(Math.round(colorToCam.get(color2).getHue()));
            double proportion = 0.0;
            for (int i = hue - 15; i < hue + 15; ++i) {
                proportion += hueProportions[WallpaperColors.wrapDegrees(i)];
            }
            colorToHueProportion.put(color2, proportion);
        }
        return colorToHueProportion;
    }

    private static int wrapDegrees(int degrees) {
        if (degrees < 0) {
            return degrees % 360 + 360;
        }
        if (degrees >= 360) {
            return degrees % 360;
        }
        return degrees;
    }

    private static double[] hueProportions(Map<Integer, Cam> colorToCam, Map<Integer, Integer> colorToPopulation) {
        double[] proportions = new double[360];
        double totalPopulation = 0.0;
        for (Map.Entry<Integer, Integer> entry : colorToPopulation.entrySet()) {
            totalPopulation += (double)entry.getValue().intValue();
        }
        for (Map.Entry<Integer, Integer> entry : colorToPopulation.entrySet()) {
            int color2 = entry.getKey();
            int population = colorToPopulation.get(color2);
            Cam cam = colorToCam.get(color2);
            int hue = WallpaperColors.wrapDegrees(Math.round(cam.getHue()));
            proportions[hue] = proportions[hue] + (double)population / totalPopulation;
        }
        return proportions;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        List<Color> mainColors = this.getMainColors();
        int count = mainColors.size();
        dest.writeInt(count);
        for (int i = 0; i < count; ++i) {
            Color color2 = mainColors.get(i);
            dest.writeInt(color2.toArgb());
        }
        count = this.mAllColors.size();
        dest.writeInt(count);
        for (Map.Entry<Integer, Integer> colorEntry : this.mAllColors.entrySet()) {
            if (colorEntry.getKey() == null) continue;
            dest.writeInt(colorEntry.getKey());
            Integer population = colorEntry.getValue();
            int populationInt = population != null ? population : 0;
            dest.writeInt(populationInt);
        }
        dest.writeInt(this.mColorHints);
    }

    public Color getPrimaryColor() {
        return this.mMainColors.get(0);
    }

    public Color getSecondaryColor() {
        return this.mMainColors.size() < 2 ? null : this.mMainColors.get(1);
    }

    public Color getTertiaryColor() {
        return this.mMainColors.size() < 3 ? null : this.mMainColors.get(2);
    }

    public List<Color> getMainColors() {
        return Collections.unmodifiableList(this.mMainColors);
    }

    public Map<Integer, Integer> getAllColors() {
        return Collections.unmodifiableMap(this.mAllColors);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WallpaperColors other = (WallpaperColors)o;
        return this.mMainColors.equals(other.mMainColors) && this.mAllColors.equals(other.mAllColors) && this.mColorHints == other.mColorHints;
    }

    public int hashCode() {
        return 31 * this.mMainColors.hashCode() * this.mAllColors.hashCode() + this.mColorHints;
    }

    public int getColorHints() {
        return this.mColorHints;
    }

    private static int calculateDarkHints(Bitmap source) {
        if (source == null) {
            return 0;
        }
        int[] pixels = new int[source.getWidth() * source.getHeight()];
        double totalLuminance = 0.0;
        int maxDarkPixels = (int)((float)pixels.length * 0.05f);
        int darkPixels = 0;
        source.getPixels(pixels, 0, source.getWidth(), 0, 0, source.getWidth(), source.getHeight());
        float[] tmpHsl = new float[3];
        for (int i = 0; i < pixels.length; ++i) {
            boolean satisfiesTextContrast;
            ColorUtils.colorToHSL(pixels[i], tmpHsl);
            float luminance = tmpHsl[2];
            int alpha = Color.alpha(pixels[i]);
            boolean bl = satisfiesTextContrast = ContrastColorUtil.calculateContrast(pixels[i], -16777216) > 5.5;
            if (!satisfiesTextContrast && alpha != 0) {
                ++darkPixels;
            }
            totalLuminance += (double)luminance;
        }
        int hints = 0;
        double meanLuminance = totalLuminance / (double)pixels.length;
        if (meanLuminance > (double)0.7f && darkPixels < maxDarkPixels) {
            hints |= 1;
        }
        if (meanLuminance < (double)0.3f) {
            hints |= 2;
        }
        return hints;
    }

    private static Size calculateOptimalSize(int width, int height) {
        int requestedArea = width * height;
        double scale = 1.0;
        if (requestedArea > 12544) {
            scale = Math.sqrt(12544.0 / (double)requestedArea);
        }
        int newWidth = (int)((double)width * scale);
        int newHeight = (int)((double)height * scale);
        if (newWidth == 0) {
            newWidth = 1;
        }
        if (newHeight == 0) {
            newHeight = 1;
        }
        return new Size(newWidth, newHeight);
    }

    public String toString() {
        StringBuilder colors = new StringBuilder();
        for (int i = 0; i < this.mMainColors.size(); ++i) {
            colors.append(Integer.toHexString(this.mMainColors.get(i).toArgb())).append(" ");
        }
        return "[WallpaperColors: " + colors.toString() + "h: " + this.mColorHints + "]";
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ColorsHints {
    }
}

