/*
 * Decompiled with CFR 0.152.
 */
package android.app.admin;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.util.TypedXmlPullParser;
import android.util.TypedXmlSerializer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.xmlpull.v1.XmlPullParserException;

public class FactoryResetProtectionPolicy
implements Parcelable {
    private static final String LOG_TAG = "FactoryResetProtectionPolicy";
    private static final String KEY_FACTORY_RESET_PROTECTION_ACCOUNT = "factory_reset_protection_account";
    private static final String KEY_FACTORY_RESET_PROTECTION_ENABLED = "factory_reset_protection_enabled";
    private static final String ATTR_VALUE = "value";
    private final List<String> mFactoryResetProtectionAccounts;
    private final boolean mFactoryResetProtectionEnabled;
    public static final Parcelable.Creator<FactoryResetProtectionPolicy> CREATOR = new Parcelable.Creator<FactoryResetProtectionPolicy>(){

        @Override
        public FactoryResetProtectionPolicy createFromParcel(Parcel in) {
            ArrayList<String> factoryResetProtectionAccounts = new ArrayList<String>();
            int accountsCount = in.readInt();
            for (int i = 0; i < accountsCount; ++i) {
                factoryResetProtectionAccounts.add(in.readString());
            }
            boolean factoryResetProtectionEnabled = in.readBoolean();
            return new FactoryResetProtectionPolicy(factoryResetProtectionAccounts, factoryResetProtectionEnabled);
        }

        public FactoryResetProtectionPolicy[] newArray(int size) {
            return new FactoryResetProtectionPolicy[size];
        }
    };

    private FactoryResetProtectionPolicy(List<String> factoryResetProtectionAccounts, boolean factoryResetProtectionEnabled) {
        this.mFactoryResetProtectionAccounts = factoryResetProtectionAccounts;
        this.mFactoryResetProtectionEnabled = factoryResetProtectionEnabled;
    }

    public List<String> getFactoryResetProtectionAccounts() {
        return this.mFactoryResetProtectionAccounts;
    }

    public boolean isFactoryResetProtectionEnabled() {
        return this.mFactoryResetProtectionEnabled;
    }

    public String toString() {
        return "FactoryResetProtectionPolicy{mFactoryResetProtectionAccounts=" + this.mFactoryResetProtectionAccounts + ", mFactoryResetProtectionEnabled=" + this.mFactoryResetProtectionEnabled + '}';
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        int accountsCount = this.mFactoryResetProtectionAccounts.size();
        dest.writeInt(accountsCount);
        for (String account : this.mFactoryResetProtectionAccounts) {
            dest.writeString(account);
        }
        dest.writeBoolean(this.mFactoryResetProtectionEnabled);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static FactoryResetProtectionPolicy readFromXml(TypedXmlPullParser parser) {
        try {
            int type;
            boolean factoryResetProtectionEnabled = parser.getAttributeBoolean(null, KEY_FACTORY_RESET_PROTECTION_ENABLED, false);
            ArrayList<String> factoryResetProtectionAccounts = new ArrayList<String>();
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                if (type == 3 || type == 4 || !parser.getName().equals(KEY_FACTORY_RESET_PROTECTION_ACCOUNT)) continue;
                factoryResetProtectionAccounts.add(parser.getAttributeValue(null, ATTR_VALUE));
            }
            return new FactoryResetProtectionPolicy(factoryResetProtectionAccounts, factoryResetProtectionEnabled);
        }
        catch (IOException | XmlPullParserException e) {
            Log.w(LOG_TAG, "Reading from xml failed", e);
            return null;
        }
    }

    public void writeToXml(TypedXmlSerializer out) throws IOException {
        out.attributeBoolean(null, KEY_FACTORY_RESET_PROTECTION_ENABLED, this.mFactoryResetProtectionEnabled);
        for (String account : this.mFactoryResetProtectionAccounts) {
            out.startTag(null, KEY_FACTORY_RESET_PROTECTION_ACCOUNT);
            out.attribute(null, ATTR_VALUE, account);
            out.endTag(null, KEY_FACTORY_RESET_PROTECTION_ACCOUNT);
        }
    }

    public boolean isNotEmpty() {
        return !this.mFactoryResetProtectionAccounts.isEmpty() && this.mFactoryResetProtectionEnabled;
    }

    public static class Builder {
        private List<String> mFactoryResetProtectionAccounts;
        private boolean mFactoryResetProtectionEnabled = true;

        public Builder setFactoryResetProtectionAccounts(List<String> factoryResetProtectionAccounts) {
            this.mFactoryResetProtectionAccounts = new ArrayList<String>(factoryResetProtectionAccounts);
            return this;
        }

        public Builder setFactoryResetProtectionEnabled(boolean factoryResetProtectionEnabled) {
            this.mFactoryResetProtectionEnabled = factoryResetProtectionEnabled;
            return this;
        }

        public FactoryResetProtectionPolicy build() {
            return new FactoryResetProtectionPolicy(this.mFactoryResetProtectionAccounts, this.mFactoryResetProtectionEnabled);
        }
    }
}

