/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchSchema;
import android.os.Bundle;
import android.util.ArraySet;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;

public class GetSchemaResponse {
    private static final String VERSION_FIELD = "version";
    private static final String SCHEMAS_FIELD = "schemas";
    private final Bundle mBundle;

    GetSchemaResponse(Bundle bundle) {
        this.mBundle = Objects.requireNonNull(bundle);
    }

    public Bundle getBundle() {
        return this.mBundle;
    }

    public int getVersion() {
        return this.mBundle.getInt(VERSION_FIELD);
    }

    public Set<AppSearchSchema> getSchemas() {
        ArrayList schemaBundles = this.mBundle.getParcelableArrayList(SCHEMAS_FIELD);
        ArraySet<AppSearchSchema> schemas = new ArraySet<AppSearchSchema>(schemaBundles.size());
        for (int i = 0; i < schemaBundles.size(); ++i) {
            schemas.add(new AppSearchSchema((Bundle)schemaBundles.get(i)));
        }
        return schemas;
    }

    public static class Builder {
        private int mVersion = 0;
        private ArrayList<Bundle> mSchemaBundles = new ArrayList();
        private boolean mBuilt = false;

        public Builder setVersion(int version) {
            this.resetIfBuilt();
            this.mVersion = version;
            return this;
        }

        public Builder addSchema(AppSearchSchema schema) {
            Objects.requireNonNull(schema);
            this.resetIfBuilt();
            this.mSchemaBundles.add(schema.getBundle());
            return this;
        }

        public GetSchemaResponse build() {
            Bundle bundle = new Bundle();
            bundle.putInt(GetSchemaResponse.VERSION_FIELD, this.mVersion);
            bundle.putParcelableArrayList(GetSchemaResponse.SCHEMAS_FIELD, this.mSchemaBundles);
            this.mBuilt = true;
            return new GetSchemaResponse(bundle);
        }

        private void resetIfBuilt() {
            if (this.mBuilt) {
                this.mSchemaBundles = new ArrayList<Bundle>(this.mSchemaBundles);
                this.mBuilt = false;
            }
        }
    }
}

