/*
 * Decompiled with CFR 0.152.
 */
package android.app.appsearch;

import android.app.appsearch.AppSearchResult;
import android.app.appsearch.ReportSystemUsageRequest;
import android.app.appsearch.SearchResults;
import android.app.appsearch.SearchSpec;
import android.app.appsearch.aidl.AppSearchResultParcel;
import android.app.appsearch.aidl.IAppSearchManager;
import android.app.appsearch.aidl.IAppSearchResultCallback;
import android.app.appsearch.internal.util.Preconditions;
import android.os.RemoteException;
import android.os.SystemClock;
import android.os.UserHandle;
import android.util.Log;
import java.io.Closeable;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

public class GlobalSearchSession
implements Closeable {
    private static final String TAG = "AppSearchGlobalSearchSe";
    private final String mPackageName;
    private final UserHandle mUserHandle;
    private final IAppSearchManager mService;
    private boolean mIsMutated = false;
    private boolean mIsClosed = false;

    static void createGlobalSearchSession(IAppSearchManager service, UserHandle userHandle, String packageName, Executor executor, Consumer<AppSearchResult<GlobalSearchSession>> callback) {
        GlobalSearchSession globalSearchSession = new GlobalSearchSession(service, userHandle, packageName);
        globalSearchSession.initialize(executor, callback);
    }

    private void initialize(final Executor executor, final Consumer<AppSearchResult<GlobalSearchSession>> callback) {
        try {
            this.mService.initialize(this.mPackageName, this.mUserHandle, SystemClock.elapsedRealtime(), new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    executor.execute(() -> {
                        AppSearchResult result = resultParcel.getResult();
                        if (result.isSuccess()) {
                            callback.accept(AppSearchResult.newSuccessfulResult(GlobalSearchSession.this));
                        } else {
                            callback.accept(AppSearchResult.newFailedResult(result));
                        }
                    });
                }
            });
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    private GlobalSearchSession(IAppSearchManager service, UserHandle userHandle, String packageName) {
        this.mService = service;
        this.mUserHandle = userHandle;
        this.mPackageName = packageName;
    }

    public SearchResults search(String queryExpression, SearchSpec searchSpec) {
        Objects.requireNonNull(queryExpression);
        Objects.requireNonNull(searchSpec);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        return new SearchResults(this.mService, this.mPackageName, null, queryExpression, searchSpec, this.mUserHandle);
    }

    public void reportSystemUsage(ReportSystemUsageRequest request, final Executor executor, final Consumer<AppSearchResult<Void>> callback) {
        Objects.requireNonNull(request);
        Objects.requireNonNull(executor);
        Objects.requireNonNull(callback);
        Preconditions.checkState(!this.mIsClosed, "GlobalSearchSession has already been closed");
        try {
            this.mService.reportUsage(request.getPackageName(), request.getDatabaseName(), request.getNamespace(), request.getDocumentId(), request.getUsageTimestampMillis(), true, this.mUserHandle, new IAppSearchResultCallback.Stub(){

                @Override
                public void onResult(AppSearchResultParcel resultParcel) {
                    executor.execute(() -> callback.accept(resultParcel.getResult()));
                }
            });
            this.mIsMutated = true;
        }
        catch (RemoteException e) {
            throw e.rethrowFromSystemServer();
        }
    }

    @Override
    public void close() {
        if (this.mIsMutated && !this.mIsClosed) {
            try {
                this.mService.persistToDisk(this.mPackageName, this.mUserHandle, SystemClock.elapsedRealtime());
                this.mIsClosed = true;
            }
            catch (RemoteException e) {
                Log.e(TAG, "Unable to close the GlobalSearchSession", e);
            }
        }
    }
}

